/*
 * Decompiled with CFR 0.152.
 */
package com.github.zly2006.reden;

import com.github.zly2006.reden.malilib.MalilibSettingsKt;
import com.github.zly2006.reden.utils.DebugKt;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fi.dy.masa.malilib.config.ConfigUtils;
import fi.dy.masa.malilib.util.FileUtils;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u0010\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\r\u0010\u0001\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0001\u0010\u0002\u001a\r\u0010\u0003\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0003\u0010\u0002\"\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"", "loadMalilibSettings", "()V", "saveMalilibOptions", "Lcom/google/gson/Gson;", "GSON", "Lcom/google/gson/Gson;", "getGSON", "()Lcom/google/gson/Gson;", "reden_client"})
@Environment(value=EnvType.CLIENT)
public final class RedenClientKt {
    @NotNull
    private static final Gson GSON = new Gson();

    @NotNull
    public static final Gson getGSON() {
        return GSON;
    }

    public static final void loadMalilibSettings() {
        Path path = FileUtils.getConfigDirectoryAsPath().resolve("reden/config.json");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        Path path2 = PathsKt.createParentDirectories((Path)path, (FileAttribute[])new FileAttribute[0]);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(path2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return;
        }
        JsonObject jo = (JsonObject)GSON.fromJson(Files.readString(path2), JsonObject.class);
        ConfigUtils.readConfigBase((JsonObject)jo, (String)"Reden", MalilibSettingsKt.getAllOptions());
        if (DebugKt.isDebug()) {
            DebugKt.startDebugAppender();
        }
    }

    public static final void saveMalilibOptions() {
        JsonObject jo = new JsonObject();
        ConfigUtils.writeConfigBase((JsonObject)jo, (String)"Reden", MalilibSettingsKt.getAllOptions());
        Path path = FileUtils.getConfigDirectoryAsPath().resolve("reden/config.json");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        Files.writeString(PathsKt.createParentDirectories((Path)path, (FileAttribute[])new FileAttribute[0]), (CharSequence)GSON.toJson((JsonElement)jo), new OpenOption[0]);
    }
}

