/*
 * Decompiled with CFR 0.152.
 */
package com.github.zly2006.reden.gui;

import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_6379;
import net.minecraft.class_6382;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public abstract class QuickMenuWidget
implements class_6379,
class_4068,
class_364 {
    private final class_437 parent;
    private final List<MenuEntry> entries = new ArrayList<MenuEntry>();
    private final class_310 client = class_310.method_1551();
    int x;
    int y;
    int width;
    public static final ClickAction CLOSE_ACTION = (entry, button) -> entry.getParent().remove();
    public static final ClickAction EMPTY_ACTION = (entry, button) -> {};

    public QuickMenuWidget(class_437 parent, int x, int y) {
        this.parent = parent;
        this.x = x;
        this.y = y;
    }

    public void addEntry(class_2561 name, ClickAction action) {
        this.entries.add(new MenuEntry(name, action));
    }

    public abstract void remove();

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        if (this.entries.isEmpty()) {
            this.remove();
            return;
        }
        int height = this.entries.size() * 14;
        this.width = Integer.max(this.entries.stream().map(x -> this.client.field_1772.method_27525((class_5348)x.name)).max(Integer::compareTo).get(), 80);
        if (this.x + this.width > this.parent.field_22789) {
            this.x = this.parent.field_22789 - this.width;
        }
        if (this.y + height > this.parent.field_22790) {
            this.y = this.parent.field_22790 - height;
        }
        context.method_51448().method_22903();
        context.method_51448().method_46416(0.0f, 0.0f, 100.0f);
        context.method_51740(class_1921.method_51785(), this.x, this.y, this.x + this.width, this.y + height, Integer.MIN_VALUE, Integer.MIN_VALUE, 0);
        for (int i = 0; i < this.entries.size(); ++i) {
            MenuEntry entry = this.entries.get(i);
            int color = 0xFFFFFF;
            if (mouseX >= this.x && mouseX <= this.x + this.width && mouseY >= this.y + i * 14 && mouseY <= this.y + i * 14 + 14) {
                color = 0xFFFF00;
            }
            context.method_27534(this.client.field_1772, entry.name, this.x + this.width / 2, this.y + i * 14 + 2, color);
        }
        context.method_51448().method_22909();
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.entries.isEmpty()) {
            return false;
        }
        for (int i = 0; i < this.entries.size(); ++i) {
            MenuEntry entry = this.entries.get(i);
            if (!(mouseX >= (double)this.x) || !(mouseX <= (double)(this.x + this.width)) || !(mouseY >= (double)(this.y + i * 14)) || !(mouseY <= (double)(this.y + i * 14 + 14))) continue;
            ClickAction action = entry.action;
            entry.action = CLOSE_ACTION;
            action.onClick(entry, button);
            return true;
        }
        this.remove();
        return false;
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        this.remove();
        return false;
    }

    public void method_25365(boolean focused) {
    }

    public boolean method_25370() {
        return false;
    }

    @NotNull
    public class_6379.class_6380 method_37018() {
        return class_6379.class_6380.field_33784;
    }

    public void method_37020(class_6382 narrationElementOutput) {
    }

    @Environment(value=EnvType.CLIENT)
    public class MenuEntry {
        class_2561 name;
        ClickAction action;

        public MenuEntry(class_2561 name, ClickAction action) {
            this.name = name;
            this.action = action;
        }

        QuickMenuWidget getParent() {
            return QuickMenuWidget.this;
        }

        public void setName(class_2561 name) {
            this.name = name;
        }

        public void setAction(ClickAction action) {
            this.action = action;
        }

        public class_2561 getName() {
            return this.name;
        }

        public ClickAction getAction() {
            return this.action;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static interface ClickAction {
        public void onClick(MenuEntry var1, int var2);
    }
}

