/*
 * Decompiled with CFR 0.152.
 */
package com.github.zly2006.reden.utils;

import com.github.zly2006.reden.Reden;
import com.google.gson.Gson;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\u000b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000b\u0010\nJ%\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0018\u00010\r2\u0006\u0010\f\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/github/zly2006/reden/utils/ResourceLoader;", "", "<init>", "()V", "", "path", "", "loadBytes", "(Ljava/lang/String;)[B", "loadString", "(Ljava/lang/String;)Ljava/lang/String;", "loadStringOrNull", "lang", "", "loadLang", "(Ljava/lang/String;)Ljava/util/Map;", "reden"})
@SourceDebugExtension(value={"SMAP\nUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utils.kt\ncom/github/zly2006/reden/utils/ResourceLoader\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,257:1\n506#2,7:258\n*S KotlinDebug\n*F\n+ 1 Utils.kt\ncom/github/zly2006/reden/utils/ResourceLoader\n*L\n129#1:258,7\n*E\n"})
public final class ResourceLoader {
    @NotNull
    public static final ResourceLoader INSTANCE = new ResourceLoader();

    private ResourceLoader() {
    }

    @Nullable
    public final byte[] loadBytes(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        InputStream inputStream = Reden.class.getClassLoader().getResourceAsStream(path);
        return (byte[])(inputStream != null ? inputStream.readAllBytes() : null);
    }

    @NotNull
    public final String loadString(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        byte[] byArray = this.loadBytes(path);
        Intrinsics.checkNotNull((Object)byArray);
        return StringsKt.decodeToString((byte[])byArray);
    }

    @Nullable
    public final String loadStringOrNull(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        byte[] byArray = this.loadBytes(path);
        return byArray != null ? StringsKt.decodeToString((byte[])byArray) : null;
    }

    @JvmStatic
    @Nullable
    public static final Map<String, String> loadLang(@NotNull String lang) {
        Map map;
        Intrinsics.checkNotNullParameter((Object)lang, (String)"lang");
        String string = INSTANCE.loadStringOrNull("assets/reden/lang/" + lang + ".json");
        if (string != null) {
            String it = string;
            boolean bl = false;
            Object object = new Gson().fromJson(it, Map.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
            Map $this$filterValues$iv = (Map)object;
            boolean $i$f$filterValues = false;
            LinkedHashMap result$iv = new LinkedHashMap();
            for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
                Object value = entry$iv.getValue();
                boolean bl2 = false;
                if (!(value instanceof String)) continue;
                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
            }
            map = result$iv;
        } else {
            map = null;
        }
        return map;
    }
}

