/*
 * Decompiled with CFR 0.152.
 */
package com.devnemo.nemos.carpentry.block.seats.parents;

import com.devnemo.nemos.carpentry.block.enums.ChairPart;
import com.devnemo.nemos.carpentry.block.seats.parents.SitableBlock;
import com.devnemo.nemos.carpentry.property.ModProperties;
import net.minecraft.class_10225;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2464;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;

public class MultipleBlockChair
extends SitableBlock
implements class_3737 {
    private final class_265 northShape;
    private final class_265 eastShape;
    private final class_265 southShape;
    private final class_265 westShape;
    private static final class_2754<class_2350> FACING = class_2383.field_11177;
    public static final class_2754<ChairPart> PART = ModProperties.CHAIR_PART;

    protected MultipleBlockChair(class_4970.class_2251 settings, float height, class_265 northShape, class_265 eastShape, class_265 southShape, class_265 westShape) {
        super(settings, height, northShape, eastShape, southShape, westShape);
        this.northShape = northShape;
        this.eastShape = eastShape;
        this.southShape = southShape;
        this.westShape = westShape;
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657(FACING, (Comparable)class_2350.field_11043)).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false))).method_11657(PART, (Comparable)((Object)ChairPart.LOWER)));
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 view, class_2338 pos, class_3726 context) {
        return this.getShapeIndex(state);
    }

    @Override
    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return this.getShapeIndex(state);
    }

    private class_265 getShapeIndex(class_2680 state) {
        ChairPart chairPart = (ChairPart)((Object)state.method_11654(PART));
        boolean isLowerChairPart = chairPart == ChairPart.LOWER;
        switch ((class_2350)state.method_11654(FACING)) {
            case field_11043: {
                return isLowerChairPart ? this.northShape : this.northShape.method_1096(0.0, -1.0, 0.0);
            }
            case field_11035: {
                return isLowerChairPart ? this.southShape : this.southShape.method_1096(0.0, -1.0, 0.0);
            }
            case field_11034: {
                return isLowerChairPart ? this.eastShape : this.eastShape.method_1096(0.0, -1.0, 0.0);
            }
            case field_11039: {
                return isLowerChairPart ? this.westShape : this.westShape.method_1096(0.0, -1.0, 0.0);
            }
        }
        return this.northShape;
    }

    @Override
    public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hitResult) {
        if (state.method_11654(PART) == ChairPart.UPPER) {
            return super.method_55766(state, world, pos.method_10093(class_2350.field_11033), player, hitResult);
        }
        return super.method_55766(state, world, pos, player, hitResult);
    }

    @Override
    public class_2680 method_9559(class_2680 state, class_4538 world, class_10225 tickView, class_2338 pos, class_2350 direction, class_2338 neighborPos, class_2680 neighborState, class_5819 random) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            tickView.method_64312(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789(world));
        }
        if (!(direction != this.getDirectionToOtherChairHalf((ChairPart)((Object)state.method_11654(PART))) || neighborState.method_27852((class_2248)this) && neighborState.method_11654(PART) != state.method_11654(PART))) {
            return class_2246.field_10124.method_9564();
        }
        return super.method_9559(state, world, tickView, pos, direction, neighborPos, neighborState, random);
    }

    @Override
    public class_2464 method_9604(class_2680 state) {
        return state.method_11654(PART) == ChairPart.LOWER ? class_2464.field_11458 : class_2464.field_11455;
    }

    @Override
    public class_2680 method_9605(class_1750 ctx) {
        class_1937 world = ctx.method_8045();
        class_2338 blockPos = ctx.method_8037();
        class_2350 direction = ctx.method_8042().method_10153();
        class_2338 blockPosOfOtherChairPart = blockPos.method_10093(class_2350.field_11036);
        if (this.canBlockBePlaced(world, blockPosOfOtherChairPart, ctx)) {
            class_3610 fluidState = ctx.method_8045().method_8316(ctx.method_8037());
            return (class_2680)((class_2680)((class_2680)this.method_9564().method_11657(FACING, (Comparable)direction)).method_11657(PART, (Comparable)((Object)ChairPart.LOWER))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910));
        }
        return null;
    }

    private boolean canBlockBePlaced(class_1937 world, class_2338 blockPos, class_1750 ctx) {
        boolean canSecondChairPartBePlaced = world.method_8320(blockPos).method_26166(ctx);
        boolean isSecondChairPartInWorldBorder = world.method_8621().method_11952(blockPos);
        return canSecondChairPartBePlaced && isSecondChairPartInWorldBorder;
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING, WATERLOGGED, PART});
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, class_1309 placer, class_1799 itemStack) {
        super.method_9567(world, pos, state, placer, itemStack);
        if (!world.method_8608()) {
            class_2338 blockPos = pos.method_10093(class_2350.field_11036);
            world.method_8652(blockPos, this.getNewBlockState(world, blockPos, state), 3);
            world.method_8408(pos, class_2246.field_10124);
            state.method_30101((class_1936)world, pos, 3);
        }
    }

    private class_2680 getNewBlockState(class_1937 world, class_2338 blockPos, class_2680 state) {
        class_2680 newBlockState = (class_2680)((class_2680)this.method_9564().method_11657(PART, (Comparable)((Object)ChairPart.UPPER))).method_11657(FACING, (Comparable)((class_2350)state.method_11654(FACING)));
        if (this.isStillWater(world.method_8320(blockPos))) {
            return (class_2680)newBlockState.method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(true));
        }
        return newBlockState;
    }

    private boolean isStillWater(class_2680 blockState) {
        return blockState.method_27852(class_2246.field_10382) && blockState.method_26227().method_15771();
    }

    public class_2680 method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        ChairPart chairPart;
        if (!world.method_8608() && player.method_68878() && (chairPart = (ChairPart)((Object)state.method_11654(PART))).equals((Object)ChairPart.UPPER)) {
            this.breakOtherChairPart(world, pos, player, chairPart);
        }
        return super.method_9576(world, pos, state, player);
    }

    private void breakOtherChairPart(class_1937 world, class_2338 pos, class_1657 player, ChairPart chairPart) {
        class_2338 positionOfOtherChairPart = pos.method_10093(this.getDirectionToOtherChairHalf(chairPart));
        class_2680 stateOfOtherChairPart = world.method_8320(positionOfOtherChairPart);
        if (stateOfOtherChairPart.method_27852((class_2248)this) && stateOfOtherChairPart.method_11654(PART) == ChairPart.getOppositeChairPart(chairPart)) {
            class_2680 newBlockState = (Boolean)world.method_8320(positionOfOtherChairPart).method_11654((class_2769)WATERLOGGED) != false ? class_2246.field_10382.method_9564() : class_2246.field_10124.method_9564();
            world.method_8652(positionOfOtherChairPart, newBlockState, 35);
            world.method_8444((class_1297)player, 2001, positionOfOtherChairPart, class_2248.method_9507((class_2680)stateOfOtherChairPart));
        }
    }

    private class_2350 getDirectionToOtherChairHalf(ChairPart chairPart) {
        boolean isLowerChairPart = chairPart.equals((Object)ChairPart.LOWER);
        return isLowerChairPart ? class_2350.field_11036 : class_2350.field_11033;
    }
}

