/*
 * Decompiled with CFR 0.152.
 */
package com.devnemo.nemos.carpentry.screen;

import com.devnemo.nemos.carpentry.recipe.display.CarpentryRecipeDisplay;
import com.devnemo.nemos.carpentry.screen.CarpentryScreenHandler;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10302;
import net.minecraft.class_10352;
import net.minecraft.class_10363;
import net.minecraft.class_10799;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_11909;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_465;

@Environment(value=EnvType.CLIENT)
public class CarpentryScreen
extends class_465<CarpentryScreenHandler> {
    private static final class_2960 TEXTURE = class_2960.method_60655((String)"nemos-carpentry", (String)"textures/gui/container/carpenters_workbench.png");
    private static final class_2960 SCROLLER_TEXTURE = class_2960.method_60655((String)"nemos-carpentry", (String)"container/carpenters_workbench/scroller");
    private static final class_2960 SCROLLER_DISABLED_TEXTURE = class_2960.method_60655((String)"nemos-carpentry", (String)"container/carpenters_workbench/scroller_disabled");
    private static final class_2960 RECIPE_SELECTED_TEXTURE = class_2960.method_60655((String)"nemos-carpentry", (String)"container/carpenters_workbench/recipe_selected");
    private static final class_2960 RECIPE_HIGHLIGHTED_TEXTURE = class_2960.method_60655((String)"nemos-carpentry", (String)"container/carpenters_workbench/recipe_highlighted");
    private static final class_2960 RECIPE_DISABLED_TEXTURE = class_2960.method_60655((String)"nemos-carpentry", (String)"container/carpenters_workbench/recipe_disabled");
    private static final class_2960 RECIPE_TEXTURE = class_2960.method_60655((String)"nemos-carpentry", (String)"container/carpenters_workbench/recipe");
    private static final int RECIPES_IMAGE_SIZE_WIDTH = 16;
    private static final int RECIPES_IMAGE_SIZE_HEIGHT = 18;
    private static final int RELATIVE_RECIPE_X = 52;
    private static final int RELATIVE_RECIPE_Y = 14;
    private float scrollAmount;
    private int firstVisibleRecipeIndex;
    private boolean mouseClicked;
    private boolean hasAvailableRecipes;

    public CarpentryScreen(CarpentryScreenHandler handler, class_1661 inventory, class_2561 title) {
        super((class_1703)handler, inventory, title);
        handler.setContentsChangedListener(this::onInventoryChange);
        --this.field_25268;
    }

    protected void method_2389(class_332 context, float delta, int mouseX, int mouseY) {
        context.method_25290(class_10799.field_56883, TEXTURE, this.field_2776, this.field_2800, 0.0f, 0.0f, this.field_2792, this.field_2779, 256, 256);
        this.drawScroll(context);
        this.renderRecipeBackground(context, mouseX, mouseY, this.field_2776 + 52, this.field_2800 + 14, this.firstVisibleRecipeIndex + 12);
        this.renderRecipeIcons(context, this.field_2776 + 52, this.field_2800 + 14, this.firstVisibleRecipeIndex + 12);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        this.method_2380(context, mouseX, mouseY);
    }

    public boolean method_25402(class_11909 click, boolean bl) {
        this.mouseClicked = false;
        if (this.hasAvailableRecipes) {
            int firstRecipeX = this.field_2776 + 52;
            int firstRecipeY = this.field_2800 + 14;
            int maxVisibleRecipeCount = 12;
            int lastVisibleRecipeIndex = this.firstVisibleRecipeIndex + maxVisibleRecipeCount;
            for (int recipeIndex = this.firstVisibleRecipeIndex; recipeIndex < lastVisibleRecipeIndex; ++recipeIndex) {
                int visibleRecipeIndex = recipeIndex - this.firstVisibleRecipeIndex;
                double mouseDistanceToRecipeX = click.comp_4798() - (double)(firstRecipeX + visibleRecipeIndex % 4 * 16);
                double mouseDistanceToRecipeY = click.comp_4799() - (double)(firstRecipeY + visibleRecipeIndex / 4 * 18);
                if (!(mouseDistanceToRecipeX >= 0.0) || !(mouseDistanceToRecipeY >= 0.0) || !(mouseDistanceToRecipeX < 16.0) || !(mouseDistanceToRecipeY < 18.0) || !((CarpentryScreenHandler)this.field_2797).method_7604((class_1657)this.field_22787.field_1724, recipeIndex)) continue;
                if (((CarpentryScreenHandler)this.field_2797).getAvailableRecipeCount() > recipeIndex) {
                    if (!((CarpentryScreenHandler)this.field_2797).canCraftSelectedRecipe()) {
                        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_17711, (float)4.0f));
                    } else {
                        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_17711, (float)1.0f));
                    }
                }
                this.field_22787.field_1761.method_2900(((CarpentryScreenHandler)this.field_2797).field_7763, recipeIndex);
                return true;
            }
            firstRecipeX = this.field_2776 + 119;
            firstRecipeY = this.field_2800 + 9;
            if (click.comp_4798() >= (double)firstRecipeX && click.comp_4798() < (double)(firstRecipeX + 12) && click.comp_4799() >= (double)firstRecipeY && click.comp_4799() < (double)(firstRecipeY + 54)) {
                this.mouseClicked = true;
            }
        }
        return super.method_25402(click, bl);
    }

    protected boolean method_2381(double mouseX, double mouseY, int left, int top) {
        return mouseX < (double)left - 22.0 || mouseY < (double)top || mouseX >= (double)(left + this.field_2792) || mouseY >= (double)(top + this.field_2779);
    }

    public boolean method_25403(class_11909 click, double offsetX, double offsetY) {
        if (this.mouseClicked && this.shouldScroll()) {
            int i = this.field_2800 + 14;
            int j = i + 54;
            this.scrollAmount = ((float)click.comp_4799() - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            this.scrollAmount = class_3532.method_15363((float)this.scrollAmount, (float)0.0f, (float)1.0f);
            this.firstVisibleRecipeIndex = (int)((double)(this.scrollAmount * (float)this.getMaxScroll()) + 0.5) * 4;
            return true;
        }
        return super.method_25403(click, offsetX, offsetY);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (this.shouldScroll()) {
            int i = this.getMaxScroll();
            float f = (float)verticalAmount / (float)i;
            this.scrollAmount = class_3532.method_15363((float)(this.scrollAmount - f), (float)0.0f, (float)1.0f);
            this.firstVisibleRecipeIndex = (int)((double)(this.scrollAmount * (float)i) + 0.5) * 4;
        }
        return true;
    }

    protected void method_2380(class_332 drawContext, int x, int y) {
        super.method_2380(drawContext, x, y);
        int toolPosX = this.field_2776 + 52;
        int toolPosY = this.field_2800 + 14;
        int scrollOffset = this.firstVisibleRecipeIndex + 12;
        CarpentryRecipeDisplay.Grouping availableRecipes = ((CarpentryScreenHandler)this.field_2797).getAvailableRecipes();
        for (int l = this.firstVisibleRecipeIndex; l < scrollOffset && l < availableRecipes.size(); ++l) {
            int m = l - this.firstVisibleRecipeIndex;
            int n = toolPosX + m % 4 * 16;
            int o = toolPosY + m / 4 * 18 + 2;
            if (x < n || x >= n + 16 || y < o || y >= o + 18) continue;
            class_10352 contextParameterMap = class_10363.method_65008((class_1937)this.field_22787.field_1687);
            class_10302 slotDisplay = availableRecipes.entries().get(l).recipe().optionDisplay();
            drawContext.method_51446(this.field_22793, slotDisplay.method_64742(contextParameterMap), x, y);
        }
    }

    private void renderRecipeBackground(class_332 context, int mouseX, int mouseY, int x, int y, int scrollOffset) {
        for (int i = this.firstVisibleRecipeIndex; i < scrollOffset && i < ((CarpentryScreenHandler)this.field_2797).getAvailableRecipeCount(); ++i) {
            int j = i - this.firstVisibleRecipeIndex;
            int k = x + j % 4 * 16;
            int l = j / 4;
            int m = y + l * 18 + 2;
            if (!((CarpentryScreenHandler)this.field_2797).canCraftRecipe(i)) {
                context.method_52706(class_10799.field_56883, RECIPE_DISABLED_TEXTURE, k, m - 1, 16, 18);
                continue;
            }
            this.renderRecipeBackgroundForCraftableRecipe(context, i, mouseX, mouseY, k, m);
        }
    }

    private void renderRecipeBackgroundForCraftableRecipe(class_332 context, int i, int mouseX, int mouseY, int k, int m) {
        class_2960 identifier = i == ((CarpentryScreenHandler)this.field_2797).getSelectedRecipeIndex() ? RECIPE_SELECTED_TEXTURE : (mouseX >= k && mouseY >= m && mouseX < k + 16 && mouseY < m + 18 ? RECIPE_HIGHLIGHTED_TEXTURE : RECIPE_TEXTURE);
        context.method_52706(class_10799.field_56883, identifier, k, m - 1, 16, 18);
    }

    private void renderRecipeIcons(class_332 context, int x, int y, int scrollOffset) {
        CarpentryRecipeDisplay.Grouping availableRecipes = ((CarpentryScreenHandler)this.field_2797).getAvailableRecipes();
        class_10352 contextParameterMap = class_10363.method_65008((class_1937)this.field_22787.field_1687);
        for (int i = this.firstVisibleRecipeIndex; i < scrollOffset && i < availableRecipes.size(); ++i) {
            int yPosWithoutScrollOffset = i - this.firstVisibleRecipeIndex;
            int k = x + yPosWithoutScrollOffset % 4 * 16;
            int l = yPosWithoutScrollOffset / 4;
            int m = y + l * 18 + 2;
            class_10302 slotDisplay = availableRecipes.entries().get(i).recipe().optionDisplay();
            context.method_51427(slotDisplay.method_64742(contextParameterMap), k, m);
        }
    }

    private void drawScroll(class_332 context) {
        int yPosAfterScrolling = (int)(41.0f * this.scrollAmount);
        class_2960 identifier = this.shouldScroll() ? SCROLLER_TEXTURE : SCROLLER_DISABLED_TEXTURE;
        context.method_52706(class_10799.field_56883, identifier, this.field_2776 + 119, this.field_2800 + 15 + yPosAfterScrolling, 12, 15);
    }

    private boolean shouldScroll() {
        return ((CarpentryScreenHandler)this.field_2797).getAvailableRecipeCount() > 12;
    }

    protected int getMaxScroll() {
        return (((CarpentryScreenHandler)this.field_2797).getAvailableRecipeCount() + 4 - 1) / 4 - 3;
    }

    private void onInventoryChange() {
        this.hasAvailableRecipes = ((CarpentryScreenHandler)this.field_2797).hasAvailableRecipes();
        if (!this.hasAvailableRecipes) {
            this.scrollAmount = 0.0f;
            this.firstVisibleRecipeIndex = 0;
        }
    }
}

