/*
 * Decompiled with CFR 0.152.
 */
package com.devnemo.nemos.carpentry.screen;

import com.devnemo.nemos.carpentry.block.ModBlocks;
import com.devnemo.nemos.carpentry.interfaces.CarpentryRecipeGetter;
import com.devnemo.nemos.carpentry.interfaces.ModRecipeManagerGetter;
import com.devnemo.nemos.carpentry.recipe.CarpentryRecipe;
import com.devnemo.nemos.carpentry.recipe.display.CarpentryRecipeDisplay;
import com.devnemo.nemos.carpentry.screen.ModScreenHandlerTypes;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1731;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3914;
import net.minecraft.class_3915;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_9696;

public class CarpentryScreenHandler
extends class_1703 {
    private final class_3914 context;
    private final class_1937 world;
    private final class_3915 selectedRecipeIndex = class_3915.method_17403();
    private class_1799 inputStack = class_1799.field_8037;
    private class_1799 secondInputStack = class_1799.field_8037;
    private CarpentryRecipeDisplay.Grouping availableRecipes = CarpentryRecipeDisplay.Grouping.empty();
    long lastTakeTime;
    final class_1735 inputSlotOne;
    final class_1735 inputSlotTwo;
    final class_1735 outputSlot;
    Runnable contentsChangedListener = () -> {};
    public final class_1263 input = new class_1277(2){

        public void method_5431() {
            super.method_5431();
            CarpentryScreenHandler.this.method_7609((class_1263)this);
            CarpentryScreenHandler.this.contentsChangedListener.run();
        }
    };
    final class_1731 output = new class_1731();

    public CarpentryScreenHandler(int syncId, class_1661 playerInventory) {
        this(syncId, playerInventory, class_3914.field_17304);
    }

    public CarpentryScreenHandler(int syncId, class_1661 playerInventory, final class_3914 context) {
        super(ModScreenHandlerTypes.CARPENTRY_SCREEN_HANDLER, syncId);
        this.world = playerInventory.field_7546.method_73183();
        this.context = context;
        this.inputSlotOne = this.method_7621(new class_1735(this.input, 0, 20, 19));
        this.inputSlotTwo = this.method_7621(new class_1735(this.input, 1, 20, 47));
        this.outputSlot = this.method_7621(new class_1735((class_1263)this.output, 0, 143, 33){

            public boolean method_7680(class_1799 stack) {
                return false;
            }

            public void method_7667(class_1657 player, class_1799 stack) {
                stack.method_7982(player, stack.method_7947());
                CarpentryScreenHandler.this.output.method_7664(player, this.getInputStacks());
                CarpentryRecipeDisplay.GroupEntry recipeGroupEntry = CarpentryScreenHandler.this.availableRecipes.entries().get(CarpentryScreenHandler.this.selectedRecipeIndex.method_17407());
                this.takeStacksOfIngredients(recipeGroupEntry.inputCounts());
                context.method_17393((world, pos) -> {
                    long l = world.method_8510();
                    if (CarpentryScreenHandler.this.lastTakeTime != l) {
                        world.method_8396(null, player.method_24515(), class_3417.field_17710, class_3419.field_15245, 1.0f, 1.0f);
                        CarpentryScreenHandler.this.lastTakeTime = l;
                    }
                });
                super.method_7667(player, stack);
            }

            private void takeStacksOfIngredients(List<Integer> inputCounts) {
                int firstIngredientCount = inputCounts.get(0);
                class_1799 itemStack = CarpentryScreenHandler.this.inputSlotOne.method_7671(firstIngredientCount);
                if (inputCounts.size() > 1) {
                    int secondIngredientCount = inputCounts.get(1);
                    CarpentryScreenHandler.this.inputSlotTwo.method_7671(secondIngredientCount);
                }
                if (!itemStack.method_7960()) {
                    CarpentryScreenHandler.this.populateResult(CarpentryScreenHandler.this.selectedRecipeIndex.method_17407());
                }
            }

            private List<class_1799> getInputStacks() {
                return List.of(CarpentryScreenHandler.this.inputSlotOne.method_7677(), CarpentryScreenHandler.this.inputSlotTwo.method_7677());
            }
        });
        this.addPlayerInventory(playerInventory);
        this.addPlayerHotbar(playerInventory);
        this.method_17362(this.selectedRecipeIndex);
    }

    public class_1799 method_7601(class_1657 player, int slotIndex) {
        class_1799 itemStack = class_1799.field_8037;
        class_1735 movingSlot = (class_1735)this.field_7761.get(slotIndex);
        if (movingSlot.method_7681()) {
            class_1799 movingItemStack = movingSlot.method_7677();
            class_1792 item = movingItemStack.method_7909();
            itemStack = movingItemStack.method_7972();
            if (slotIndex == 2) {
                item.method_7843(movingItemStack, player.method_73183());
                if (!this.method_7616(movingItemStack, 3, 39, true)) {
                    return class_1799.field_8037;
                }
                movingSlot.method_7670(movingItemStack, itemStack);
            }
            if (!(slotIndex != 0 && slotIndex != 1 || this.method_7616(movingItemStack, 3, 39, false))) {
                return class_1799.field_8037;
            }
            if (!this.getCarpentryRecipesForItemStack(((class_1735)this.field_7761.get(0)).method_7677()).isEmpty() && this.isMovingItemSecondIngredient(((class_1735)this.field_7761.get(0)).method_7677(), movingItemStack) ? !this.method_7616(movingItemStack, 1, 2, false) : (!this.getCarpentryRecipesForItemStack(movingItemStack).isEmpty() ? !this.method_7616(movingItemStack, 0, 1, false) : (slotIndex >= 3 && slotIndex < 30 ? !this.method_7616(movingItemStack, 30, 39, false) : slotIndex >= 30 && slotIndex < 39 && !this.method_7616(movingItemStack, 3, 30, false)))) {
                return class_1799.field_8037;
            }
            if (movingItemStack.method_7960()) {
                movingSlot.method_53512(class_1799.field_8037);
            }
            movingSlot.method_7668();
            if (movingItemStack.method_7947() == itemStack.method_7947()) {
                return class_1799.field_8037;
            }
            movingSlot.method_7667(player, itemStack);
            this.method_7623();
        }
        return itemStack;
    }

    private boolean isMovingItemSecondIngredient(class_1799 firstIngredient, class_1799 secondIngredient) {
        CarpentryRecipeDisplay.Grouping carpentryRecipes = this.getCarpentryRecipesForItemStack(firstIngredient);
        return carpentryRecipes.entries().stream().anyMatch(recipe -> this.isItemSecondIngredient(recipe.ingredients(), secondIngredient));
    }

    private CarpentryRecipeDisplay.Grouping getCarpentryRecipesForItemStack(class_1799 itemStack) {
        CarpentryRecipeDisplay.Grouping carpentryRecipes = CarpentryRecipeDisplay.Grouping.empty();
        if (!this.world.method_8608()) {
            carpentryRecipes = ((CarpentryRecipeGetter)this.world.method_8433()).nemo_sCarpentry$getCarpentryRecipes().filter(itemStack);
        } else if (this.world.method_8608()) {
            carpentryRecipes = ((ModRecipeManagerGetter)this.world).nemo_sCarpentry$getModRecipeManager().getCarpentryRecipes().filter(itemStack);
        }
        return carpentryRecipes;
    }

    private boolean isItemSecondIngredient(List<class_1856> ingredients, class_1799 secondIngredient) {
        return ingredients.size() == 2 && this.itemIsInMatchingStacks(ingredients.get(1).method_8105().toList(), secondIngredient.method_7909());
    }

    public boolean method_7597(class_1657 player) {
        return CarpentryScreenHandler.method_17695((class_3914)this.context, (class_1657)player, (class_2248)ModBlocks.CARPENTERS_WORKBENCH);
    }

    public boolean method_7604(class_1657 player, int index) {
        if (this.isInBounds(index)) {
            if (this.canCraftRecipe(index)) {
                this.selectedRecipeIndex.method_17404(index);
            } else {
                this.selectedRecipeIndex.method_17404(-1);
            }
            this.populateResult(index);
        }
        return true;
    }

    private boolean isInBounds(int id) {
        return id >= 0 && id < this.availableRecipes.size();
    }

    public void method_7595(class_1657 player) {
        super.method_7595(player);
        this.output.method_5441(0);
        this.method_7607(player, this.input);
    }

    public void setContentsChangedListener(Runnable contentsChangedListener) {
        this.contentsChangedListener = contentsChangedListener;
    }

    public void method_7609(class_1263 inventory) {
        class_1799 firstIngredient = this.inputSlotOne.method_7677();
        class_1799 secondIngredient = this.inputSlotTwo.method_7677();
        if (!firstIngredient.method_31574(this.inputStack.method_7909()) || !secondIngredient.method_31574(this.secondInputStack.method_7909())) {
            this.inputStack = firstIngredient.method_7972();
            this.secondInputStack = secondIngredient.method_7972();
            this.updateInput(firstIngredient);
        }
    }

    private static class_9696 createRecipeInput(class_1263 inventory) {
        return new class_9696(inventory.method_5438(0));
    }

    private void updateInput(class_1799 itemStack) {
        this.selectedRecipeIndex.method_17404(-1);
        this.outputSlot.method_7673(class_1799.field_8037);
        this.availableRecipes = !itemStack.method_7960() ? this.getCarpentryRecipesForItemStack(itemStack) : CarpentryRecipeDisplay.Grouping.empty();
    }

    public int getSelectedRecipeIndex() {
        return this.selectedRecipeIndex.method_17407();
    }

    public CarpentryRecipeDisplay.Grouping getAvailableRecipes() {
        return this.availableRecipes;
    }

    public int getAvailableRecipeCount() {
        return this.availableRecipes.size();
    }

    public boolean hasAvailableRecipes() {
        return !this.availableRecipes.isEmpty();
    }

    public boolean canCraftRecipe(int index) {
        boolean hasRecipes = !this.availableRecipes.isEmpty();
        boolean hasFirstInputSlotStack = this.inputSlotOne.method_7681();
        if (!hasRecipes || !hasFirstInputSlotStack) {
            return false;
        }
        return this.hasRecipeIngredients(index);
    }

    public boolean canCraftSelectedRecipe() {
        boolean hasRecipes = !this.availableRecipes.isEmpty();
        boolean hasFirstInputSlotStack = this.inputSlotOne.method_7681();
        int selectedRecipeIndex = this.selectedRecipeIndex.method_17407();
        if (!hasRecipes || !hasFirstInputSlotStack || selectedRecipeIndex == -1) {
            return false;
        }
        return this.hasRecipeIngredients(selectedRecipeIndex);
    }

    private boolean hasRecipeIngredients(int index) {
        CarpentryRecipeDisplay.GroupEntry recipe = this.availableRecipes.entries().get(index);
        List<class_1856> ingredients = recipe.ingredients();
        List<class_6880<class_1792>> firstIngredientMatchingItems = ingredients.get(0).method_8105().toList();
        List<Integer> inputCounts = recipe.inputCounts();
        class_1799 firstInputItemStack = this.inputSlotOne.method_7677();
        boolean hasFirstInputIngredient = this.itemIsInMatchingStacks(firstIngredientMatchingItems, firstInputItemStack.method_7909()) && firstInputItemStack.method_7947() >= inputCounts.get(0);
        boolean hasSecondInputIngredient = true;
        if (ingredients.size() > 1) {
            class_1856 secondIngredient = ingredients.get(1);
            class_1799 secondInputItemStack = this.inputSlotTwo.method_7677();
            hasSecondInputIngredient = this.itemIsInMatchingStacks(secondIngredient.method_8105().toList(), secondInputItemStack.method_7909()) && secondInputItemStack.method_7947() >= inputCounts.get(1);
        }
        return hasFirstInputIngredient && hasSecondInputIngredient;
    }

    private boolean itemIsInMatchingStacks(List<class_6880<class_1792>> matchingItems, class_1792 item) {
        return matchingItems.stream().anyMatch(registryEntry -> ((class_1792)registryEntry.comp_349()).equals(item));
    }

    private void addPlayerInventory(class_1661 playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.method_7621(new class_1735((class_1263)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(class_1661 playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.method_7621(new class_1735((class_1263)playerInventory, i, 8 + i * 18, 142));
        }
    }

    private void populateResult(int selectedId) {
        Optional<Object> optionalRecipe;
        if (this.hasAvailableRecipes() && this.isInBounds(selectedId) && this.canCraftSelectedRecipe()) {
            CarpentryRecipeDisplay.GroupEntry recipeGroupEntry = this.availableRecipes.entries().get(selectedId);
            optionalRecipe = recipeGroupEntry.recipe().recipe();
        } else {
            optionalRecipe = Optional.empty();
        }
        optionalRecipe.ifPresentOrElse(recipeEntry -> {
            CarpentryRecipe carpentryRecipe = (CarpentryRecipe)recipeEntry.comp_1933();
            class_1799 itemStack = carpentryRecipe.craft(CarpentryScreenHandler.createRecipeInput(this.input), (class_7225.class_7874)this.world.method_30349());
            this.output.method_7662(recipeEntry);
            this.outputSlot.method_7673(itemStack);
        }, () -> {
            this.outputSlot.method_7673(class_1799.field_8037);
            this.output.method_7662(null);
        });
        this.method_7623();
    }
}

