/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import jagm.classicpipes.block.FluidPipeBlock;
import jagm.classicpipes.blockentity.FluidPipeEntity;
import jagm.classicpipes.client.renderer.FluidRenderInfo;
import jagm.classicpipes.services.Services;
import jagm.classicpipes.util.FluidInPipe;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class FluidPipeRenderer
implements BlockEntityRenderer<FluidPipeEntity, FluidPipeRenderState> {
    private final BlockEntityRendererProvider.Context context;
    private final Map<FluidPipeEntity, Float> lastWidths;

    public FluidPipeRenderer(BlockEntityRendererProvider.Context context) {
        this.context = context;
        this.lastWidths = new HashMap<FluidPipeEntity, Float>();
    }

    public FluidPipeRenderState createRenderState() {
        return new FluidPipeRenderState();
    }

    public void extractRenderState(FluidPipeEntity pipe, FluidPipeRenderState pipeState, float partialTicks, Vec3 cameraPos, ModelFeatureRenderer.CrumblingOverlay breakProgress) {
        super.extractRenderState((BlockEntity)pipe, (BlockEntityRenderState)pipeState, partialTicks, cameraPos, breakProgress);
        FluidRenderInfo fluidInfo = Services.LOADER_SERVICE.getFluidRenderInfo(pipe.getFluid().defaultFluidState(), (BlockAndTintGetter)pipe.getLevel(), pipe.getBlockPos());
        boolean[] middleSides = new boolean[6];
        Arrays.fill(middleSides, true);
        boolean[] pipeDirections = new boolean[6];
        for (int i = 0; i < 6; ++i) {
            pipeDirections[i] = (Boolean)pipe.getBlockState().getValue((Property)FluidPipeBlock.PROPERTY_BY_DIRECTION.get(Direction.from3DDataValue((int)i)));
        }
        int totalAmount = 0;
        for (FluidInPipe fluidPacket : pipe.getContents()) {
            totalAmount += fluidPacket.getAmount();
            middleSides[fluidPacket.getFromDirection().get3DDataValue()] = false;
            middleSides[fluidPacket.getTargetDirection().get3DDataValue()] = false;
        }
        float targetWidth = Math.min(7.0f, (float)totalAmount * 7.0f / 1000.0f) / 16.0f;
        float lastWidth = this.lastWidths.getOrDefault((Object)pipe, Float.valueOf(0.0f)).floatValue();
        float width = lastWidth + (targetWidth - lastWidth) / 32.0f;
        this.lastWidths.put(pipe, Float.valueOf(width));
        pipeState.initialise(fluidInfo, width, middleSides, pipeDirections);
    }

    public boolean shouldRender(FluidPipeEntity pipe, Vec3 cameraPos) {
        boolean shouldRender = super.shouldRender((BlockEntity)pipe, cameraPos);
        if (!shouldRender) {
            this.lastWidths.remove((Object)pipe);
        }
        return shouldRender;
    }

    public void submit(FluidPipeRenderState pipeState, PoseStack poses, SubmitNodeCollector queue, CameraRenderState cameraState) {
        poses.pushPose();
        if (pipeState.width() > 0.01f) {
            TextureAtlasSprite fluidSprite = pipeState.fluidInfo().sprite() == null ? Minecraft.getInstance().getBlockRenderer().getBlockModelShaper().getParticleIcon(Blocks.WATER.defaultBlockState()) : pipeState.fluidInfo().sprite();
            queue.submitCustomGeometry(poses, RenderType.text((ResourceLocation)fluidSprite.atlasLocation()), (pose, vertexBuffer) -> {
                Matrix4f matrix = pose.pose();
                float start = 0.5f - pipeState.width() / 2.0f;
                float end = 0.5f + pipeState.width() / 2.0f;
                boolean renderMiddle = false;
                block8: for (Direction direction : Direction.values()) {
                    if (pipeState.middleSides()[direction.get3DDataValue()] || !pipeState.pipeDirections()[direction.get3DDataValue()]) continue;
                    renderMiddle = true;
                    boolean[] renderSides = new boolean[6];
                    Arrays.fill(renderSides, true);
                    renderSides[direction.getOpposite().get3DDataValue()] = false;
                    switch (direction) {
                        case UP: {
                            this.renderFluidCuboid(vertexBuffer, matrix, start, end, start, end, 1.0f, end, fluidSprite, pipeState.fluidInfo().tint(), pipeState.lightCoords, renderSides);
                            continue block8;
                        }
                        case DOWN: {
                            this.renderFluidCuboid(vertexBuffer, matrix, start, 0.0f, start, end, start, end, fluidSprite, pipeState.fluidInfo().tint(), pipeState.lightCoords, renderSides);
                            continue block8;
                        }
                        case EAST: {
                            this.renderFluidCuboid(vertexBuffer, matrix, end, start, start, 1.0f, end, end, fluidSprite, pipeState.fluidInfo().tint(), pipeState.lightCoords, renderSides);
                            continue block8;
                        }
                        case WEST: {
                            this.renderFluidCuboid(vertexBuffer, matrix, 0.0f, start, start, start, end, end, fluidSprite, pipeState.fluidInfo().tint(), pipeState.lightCoords, renderSides);
                            continue block8;
                        }
                        case SOUTH: {
                            this.renderFluidCuboid(vertexBuffer, matrix, start, start, end, end, end, 1.0f, fluidSprite, pipeState.fluidInfo().tint(), pipeState.lightCoords, renderSides);
                            continue block8;
                        }
                        case NORTH: {
                            this.renderFluidCuboid(vertexBuffer, matrix, start, start, 0.0f, end, end, start, fluidSprite, pipeState.fluidInfo().tint(), pipeState.lightCoords, renderSides);
                        }
                    }
                }
                if (renderMiddle) {
                    this.renderFluidCuboid(vertexBuffer, matrix, start, start, start, end, end, end, fluidSprite, pipeState.fluidInfo().tint(), pipeState.lightCoords, pipeState.middleSides());
                }
            });
        }
        poses.popPose();
    }

    public void renderFluidCuboid(VertexConsumer vertexBuffer, Matrix4f matrix, float x1, float y1, float z1, float x2, float y2, float z2, TextureAtlasSprite fluidSprite, int tint, int light, boolean[] renderSide) {
        float u1 = fluidSprite.getU(x1);
        float u2 = fluidSprite.getU(x2);
        float v1 = fluidSprite.getV(z1);
        float v2 = fluidSprite.getV(z2);
        if (renderSide[Direction.DOWN.get3DDataValue()]) {
            vertexBuffer.addVertex(matrix, x1, y1, z2).setColor(tint).setUv(u1, v2).setLight(light);
            vertexBuffer.addVertex(matrix, x1, y1, z1).setColor(tint).setUv(u1, v1).setLight(light);
            vertexBuffer.addVertex(matrix, x2, y1, z1).setColor(tint).setUv(u2, v1).setLight(light);
            vertexBuffer.addVertex(matrix, x2, y1, z2).setColor(tint).setUv(u2, v2).setLight(light);
        }
        if (renderSide[Direction.UP.get3DDataValue()]) {
            vertexBuffer.addVertex(matrix, x1, y2, z1).setColor(tint).setUv(u1, v2).setLight(light);
            vertexBuffer.addVertex(matrix, x1, y2, z2).setColor(tint).setUv(u1, v1).setLight(light);
            vertexBuffer.addVertex(matrix, x2, y2, z2).setColor(tint).setUv(u2, v1).setLight(light);
            vertexBuffer.addVertex(matrix, x2, y2, z1).setColor(tint).setUv(u2, v2).setLight(light);
        }
        u1 = fluidSprite.getU(y1);
        u2 = fluidSprite.getU(y2);
        v1 = fluidSprite.getV(z1);
        v2 = fluidSprite.getV(z2);
        if (renderSide[Direction.WEST.get3DDataValue()]) {
            vertexBuffer.addVertex(matrix, x1, y2, z2).setColor(tint).setUv(u1, v2).setLight(light);
            vertexBuffer.addVertex(matrix, x1, y2, z1).setColor(tint).setUv(u1, v1).setLight(light);
            vertexBuffer.addVertex(matrix, x1, y1, z1).setColor(tint).setUv(u2, v1).setLight(light);
            vertexBuffer.addVertex(matrix, x1, y1, z2).setColor(tint).setUv(u2, v2).setLight(light);
        }
        if (renderSide[Direction.EAST.get3DDataValue()]) {
            vertexBuffer.addVertex(matrix, x2, y2, z1).setColor(tint).setUv(u1, v2).setLight(light);
            vertexBuffer.addVertex(matrix, x2, y2, z2).setColor(tint).setUv(u1, v1).setLight(light);
            vertexBuffer.addVertex(matrix, x2, y1, z2).setColor(tint).setUv(u2, v1).setLight(light);
            vertexBuffer.addVertex(matrix, x2, y1, z1).setColor(tint).setUv(u2, v2).setLight(light);
        }
        u1 = fluidSprite.getU(y1);
        u2 = fluidSprite.getU(y2);
        v1 = fluidSprite.getV(x1);
        v2 = fluidSprite.getV(x2);
        if (renderSide[Direction.NORTH.get3DDataValue()]) {
            vertexBuffer.addVertex(matrix, x1, y2, z1).setColor(tint).setUv(u1, v2).setLight(light);
            vertexBuffer.addVertex(matrix, x2, y2, z1).setColor(tint).setUv(u1, v1).setLight(light);
            vertexBuffer.addVertex(matrix, x2, y1, z1).setColor(tint).setUv(u2, v1).setLight(light);
            vertexBuffer.addVertex(matrix, x1, y1, z1).setColor(tint).setUv(u2, v2).setLight(light);
        }
        if (renderSide[Direction.SOUTH.get3DDataValue()]) {
            vertexBuffer.addVertex(matrix, x2, y2, z2).setColor(tint).setUv(u1, v2).setLight(light);
            vertexBuffer.addVertex(matrix, x1, y2, z2).setColor(tint).setUv(u1, v1).setLight(light);
            vertexBuffer.addVertex(matrix, x1, y1, z2).setColor(tint).setUv(u2, v1).setLight(light);
            vertexBuffer.addVertex(matrix, x2, y1, z2).setColor(tint).setUv(u2, v2).setLight(light);
        }
    }

    public static class FluidPipeRenderState
    extends BlockEntityRenderState {
        private FluidRenderInfo fluidInfo;
        private float width;
        private boolean[] middleSides;
        private boolean[] pipeDirections;

        public void initialise(FluidRenderInfo fluidInfo, float width, boolean[] middleSides, boolean[] pipeDirections) {
            this.fluidInfo = fluidInfo;
            this.width = width;
            this.middleSides = middleSides;
            this.pipeDirections = pipeDirections;
        }

        public FluidRenderInfo fluidInfo() {
            return this.fluidInfo;
        }

        public float width() {
            return this.width;
        }

        public boolean[] middleSides() {
            return this.middleSides;
        }

        public boolean[] pipeDirections() {
            return this.pipeDirections;
        }
    }
}

