/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import jagm.classicpipes.blockentity.RecipePipeEntity;
import jagm.classicpipes.client.renderer.PipeRenderer;
import java.util.ArrayList;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionfc;

public class RecipePipeRenderer
extends PipeRenderer<RecipePipeEntity> {
    public RecipePipeRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    @Override
    public void extractRenderState(RecipePipeEntity pipe, PipeRenderer.PipeRenderState pipeState, float partialTicks, Vec3 cameraPos, ModelFeatureRenderer.CrumblingOverlay breakProgress) {
        super.extractRenderState(pipe, pipeState, partialTicks, cameraPos, breakProgress);
        ArrayList<ItemStackRenderState> heldItems = new ArrayList<ItemStackRenderState>();
        ArrayList<Float> angles = new ArrayList<Float>();
        int i = 0;
        for (ItemStack stack : pipe.getHeldItems()) {
            if (!stack.isEmpty() && pipe.getLevel() != null) {
                ItemStackRenderState stackState = new ItemStackRenderState();
                this.context.itemModelResolver().updateForTopItem(stackState, stack, ItemDisplayContext.FIXED, pipe.getLevel(), null, 0);
                heldItems.add(stackState);
                angles.add(Float.valueOf(((float)((pipe.getLevel().getGameTime() + (long)(i * 8)) % 80L) + partialTicks) * 2.0f * (float)Math.PI / 80.0f));
            } else {
                heldItems.add(null);
                angles.add(Float.valueOf(0.0f));
            }
            ++i;
        }
        pipeState.setHeldItems(heldItems, angles);
    }

    @Override
    public void submit(PipeRenderer.PipeRenderState pipeState, PoseStack poses, SubmitNodeCollector queue, CameraRenderState cameraState) {
        super.submit(pipeState, poses, queue, cameraState);
        for (int i = 0; i < pipeState.heldItems().size(); ++i) {
            ItemStackRenderState stackState = pipeState.heldItems().get(i);
            if (stackState == null) continue;
            int a = i;
            float xOff = a % 2 == 0 ? 0.05f : -0.05f;
            float zOff = (a /= 2) % 2 == 0 ? 0.05f : -0.05f;
            float yOff = (a /= 2) % 2 == 0 ? 0.05f : -0.05f;
            poses.pushPose();
            poses.translate(0.5f + xOff, 0.5f + yOff, 0.5f + zOff);
            poses.scale(0.4375f, 0.4375f, 0.4375f);
            poses.mulPose((Quaternionfc)Axis.YP.rotation(pipeState.angles().get(i).floatValue()));
            stackState.submit(poses, queue, pipeState.lightCoords, OverlayTexture.NO_OVERLAY, 0);
            poses.popPose();
        }
    }
}

