/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import jagm.classicpipes.block.PipeBlock;
import jagm.classicpipes.services.Services;
import jagm.classicpipes.util.Tuple;
import java.util.Comparator;
import java.util.function.Consumer;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class MiscUtil {
    public static final boolean DEBUG_MODE = false;
    public static final Comparator<Tuple<ItemStack, Boolean>> AMOUNT = Comparator.comparing(tuple -> ((ItemStack)tuple.a()).getCount() - ((Boolean)tuple.b() != false ? 1 : 0));
    public static final Comparator<Tuple<ItemStack, Boolean>> NAME = Comparator.comparing(tuple -> ((ItemStack)tuple.a()).getDisplayName().getString());
    public static final Comparator<Tuple<ItemStack, Boolean>> MOD = Comparator.comparing(tuple -> Services.LOADER_SERVICE.getModName(MiscUtil.modFromItem((ItemStack)tuple.a())));
    public static final Comparator<Tuple<ItemStack, Boolean>> CRAFTABLE = Comparator.comparing(Tuple::b);
    public static final Codec<ItemStack> UNLIMITED_STACK_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemStack.ITEM_NON_AIR_CODEC.fieldOf("id").forGetter(ItemStack::getItemHolder), (App)Codec.INT.fieldOf("count").forGetter(ItemStack::getCount), (App)DataComponentPatch.CODEC.optionalFieldOf("components", (Object)DataComponentPatch.EMPTY).forGetter(ItemStack::getComponentsPatch)).apply((Applicative)instance, ItemStack::new));

    public static ResourceLocation resourceLocation(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)"classicpipes", (String)name);
    }

    public static <T> ResourceKey<T> makeKey(ResourceKey<? extends Registry<T>> registry, String name) {
        return ResourceKey.create(registry, (ResourceLocation)MiscUtil.resourceLocation(name));
    }

    public static Direction nextDirection(Direction direction) {
        return Direction.from3DDataValue((int)((direction.get3DDataValue() + 1) % 6));
    }

    public static Direction prevDirection(Direction direction) {
        return Direction.from3DDataValue((int)((direction.get3DDataValue() + 5) % 6));
    }

    public static boolean itemIsPipe(ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            return blockItem.getBlock() instanceof PipeBlock;
        }
        return false;
    }

    public static String modFromItem(ItemStack stack) {
        return BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).toString().split(":")[0];
    }

    public static <T> void loadFromTag(Tag tag, Codec<T> codec, HolderLookup.Provider registries, Consumer<? super T> resultConsumer) {
        codec.parse((DynamicOps)registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag).result().ifPresent(resultConsumer);
    }

    public static <T> void saveToTag(Tag tag, T thing, Codec<T> codec, HolderLookup.Provider registries, Consumer<? super Tag> resultConsumer) {
        codec.encode(thing, (DynamicOps)registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag).result().ifPresent(resultConsumer);
    }
}

