/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.blockentity;

import jagm.classicpipes.block.ContainerAdjacentNetworkedPipeBlock;
import jagm.classicpipes.block.NetworkedPipeBlock;
import jagm.classicpipes.blockentity.MatchingPipe;
import jagm.classicpipes.blockentity.RecipePipeEntity;
import jagm.classicpipes.blockentity.RoundRobinPipeEntity;
import jagm.classicpipes.blockentity.RoutingPipeEntity;
import jagm.classicpipes.blockentity.StockingPipeEntity;
import jagm.classicpipes.util.FacingOrNone;
import jagm.classicpipes.util.ItemInPipe;
import jagm.classicpipes.util.MiscUtil;
import jagm.classicpipes.util.PipeNetwork;
import jagm.classicpipes.util.RequestedItem;
import jagm.classicpipes.util.ScheduledRoute;
import jagm.classicpipes.util.SortingMode;
import jagm.classicpipes.util.Tuple;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.ItemStackWithSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public abstract class NetworkedPipeEntity
extends RoundRobinPipeEntity {
    private final Map<ItemStack, ScheduledRoute> routingSchedule = new HashMap<ItemStack, ScheduledRoute>();
    private PipeNetwork network = null;
    private boolean controller = false;
    public BlockPos syncedNetworkPos = this.getBlockPos();

    public NetworkedPipeEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(blockEntityType, pos, state);
    }

    @Override
    public void tickServer(ServerLevel level, BlockPos pos, BlockState state) {
        super.tickServer(level, pos, state);
        if (!this.routingSchedule.isEmpty()) {
            Iterator<ItemStack> iterator = this.routingSchedule.keySet().iterator();
            while (iterator.hasNext()) {
                ScheduledRoute route = this.routingSchedule.get(iterator.next());
                route.tick();
                if (!route.timedOut()) continue;
                iterator.remove();
                this.setChanged();
            }
        }
        if (this.isController()) {
            this.getNetwork().tick(level);
        }
    }

    @Override
    protected void initialiseNetworking(ServerLevel level, BlockState state, BlockPos pos) {
        if (this.isController() && this.hasNetwork()) {
            this.distributeNetwork(level, this.getBlockPos(), new HashSet<NetworkedPipeEntity>(), this.getNetwork());
        }
        super.initialiseNetworking(level, state, pos);
    }

    protected Set<NetworkedPipeEntity> distributeNetwork(ServerLevel level, BlockPos pos, Set<NetworkedPipeEntity> visited, PipeNetwork network) {
        if (visited.contains((Object)this)) {
            return visited;
        }
        visited.add(this);
        for (Direction direction : this.networkDistances.keySet()) {
            BlockPos nextPos = (BlockPos)((Tuple)this.networkDistances.get(direction)).a();
            BlockEntity blockEntity = level.getBlockEntity(nextPos);
            if (!(blockEntity instanceof NetworkedPipeEntity)) continue;
            NetworkedPipeEntity nextPipe = (NetworkedPipeEntity)blockEntity;
            visited = nextPipe.distributeNetwork(level, nextPos, visited, network);
        }
        this.setController(pos.equals((Object)network.getPos()));
        this.setNetwork(network, level);
        return visited;
    }

    @Override
    protected List<Direction> getValidDirections(BlockState state, ItemInPipe item) {
        ArrayList<Direction> validDirections = new ArrayList<Direction>();
        Direction direction = MiscUtil.nextDirection(item.getFromDirection());
        for (int i = 0; i < 5; ++i) {
            if (((NetworkedPipeBlock.ConnectionState)((Object)state.getValue((Property)NetworkedPipeBlock.PROPERTY_BY_DIRECTION.get(direction)))).equals((Object)NetworkedPipeBlock.ConnectionState.LINKED)) {
                validDirections.add(direction);
            }
            direction = MiscUtil.nextDirection(direction);
        }
        if (validDirections.isEmpty()) {
            return super.getValidDirections(state, item);
        }
        return validDirections;
    }

    @Override
    public void routeItem(BlockState state, ItemInPipe item) {
        Level level;
        if (!this.hasNetwork()) {
            super.routeItem(state, item);
            return;
        }
        if (!this.checkRoutingSchedule(item) && (level = this.getLevel()) instanceof ServerLevel) {
            Block block;
            ServerLevel serverLevel = (ServerLevel)level;
            ArrayList<Object> validTargets = new ArrayList<Object>();
            RequestedItem thisRequestedItem = null;
            ArrayList<ItemInPipe> spareItems = new ArrayList<ItemInPipe>();
            for (RequestedItem requestedItem : this.getNetwork().getRequestedItems()) {
                Object target;
                if (!requestedItem.matches(item) || this.getLevel() == null || (target = requestedItem.getTarget(this.getLevel())) == null) continue;
                if (item.getStack().getCount() > requestedItem.getAmountRemaining()) {
                    spareItems.add(item.copyWithCount(item.getStack().getCount() - requestedItem.getAmountRemaining()));
                    item.getStack().setCount(requestedItem.getAmountRemaining());
                }
                thisRequestedItem = requestedItem;
                validTargets.add(target);
                break;
            }
            if (validTargets.isEmpty()) {
                block1: for (StockingPipeEntity stockingPipeEntity : this.network.getStockingPipes()) {
                    for (ItemStack stack : stockingPipeEntity.getMissingItemsCache()) {
                        if (!stack.is(item.getStack().getItem()) || stockingPipeEntity.shouldMatchComponents() && !ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)item.getStack())) continue;
                        int surplus = item.getStack().getCount() - stack.getCount();
                        if (surplus > 0) {
                            spareItems.add(item.copyWithCount(surplus));
                            item.getStack().setCount(stack.getCount());
                        }
                        validTargets.add((Object)stockingPipeEntity);
                        continue block1;
                    }
                }
            }
            if (validTargets.isEmpty()) {
                for (MatchingPipe matchingPipe : this.network.getMatchingPipes()) {
                    if (!matchingPipe.matches(item.getStack())) continue;
                    validTargets.add((Object)matchingPipe.getAsPipe());
                }
            }
            if (validTargets.isEmpty()) {
                for (RoutingPipeEntity routingPipeEntity : this.network.getRoutingPipes()) {
                    if (!routingPipeEntity.canRouteItemHere(item.getStack())) continue;
                    validTargets.add((Object)routingPipeEntity);
                }
            }
            if (validTargets.isEmpty()) {
                validTargets.addAll(this.network.getDefaultRoutes());
            }
            if (validTargets.contains((Object)this) && (block = state.getBlock()) instanceof NetworkedPipeBlock) {
                NetworkedPipeBlock networkedBlock = (NetworkedPipeBlock)block;
                ArrayList<Object> arrayList = new ArrayList<Object>();
                if (networkedBlock instanceof ContainerAdjacentNetworkedPipeBlock && state.getValue(ContainerAdjacentNetworkedPipeBlock.FACING) != FacingOrNone.NONE) {
                    arrayList.add(((FacingOrNone)((Object)state.getValue(ContainerAdjacentNetworkedPipeBlock.FACING))).getDirection());
                } else {
                    for (Direction direction : Direction.values()) {
                        if (!this.isPipeConnected(state, direction) || networkedBlock.isLinked(state, direction)) continue;
                        arrayList.add(direction);
                    }
                }
                if (arrayList.isEmpty() || this instanceof RecipePipeEntity) {
                    item.setEjecting(true);
                    item.setTargetDirection(item.getFromDirection().getOpposite());
                } else {
                    item.setEjecting(false);
                    item.setTargetDirection((Direction)arrayList.get(serverLevel.getRandom().nextInt(arrayList.size())));
                }
                if (thisRequestedItem != null) {
                    int remaining = thisRequestedItem.getAmountRemaining();
                    int leftover = item.getStack().getCount() - remaining;
                    thisRequestedItem.arrived(item.getStack().getCount());
                    if (thisRequestedItem.isDelivered()) {
                        this.getNetwork().removeRequestedItem(thisRequestedItem);
                    }
                    if (leftover > 0) {
                        item.setStack(item.getStack().copyWithCount(remaining));
                        spareItems.add(item.copyWithCount(leftover));
                    }
                }
            } else if (!validTargets.isEmpty()) {
                this.schedulePath(serverLevel, item, (NetworkedPipeEntity)((Object)validTargets.get(serverLevel.getRandom().nextInt(validTargets.size()))));
                this.checkRoutingSchedule(item);
            } else {
                super.routeItem(state, item);
            }
            for (ItemInPipe itemInPipe : spareItems) {
                this.queued.add(itemInPipe);
                this.routeItem(state, itemInPipe);
            }
        }
    }

    private boolean checkRoutingSchedule(ItemInPipe item) {
        Iterator<ItemStack> iterator = this.routingSchedule.keySet().iterator();
        while (iterator.hasNext()) {
            ItemStack stack = iterator.next();
            if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)item.getStack()) || stack.getCount() != item.getStack().getCount()) continue;
            item.setEjecting(false);
            item.setTargetDirection(this.routingSchedule.get(stack).getDirection());
            iterator.remove();
            return true;
        }
        return false;
    }

    public void schedule(ItemStack stack, Direction direction) {
        this.routingSchedule.put(stack, new ScheduledRoute(direction));
    }

    public void schedulePath(ServerLevel level, ItemInPipe item, NetworkedPipeEntity target) {
        HashMap<NetworkedPipeEntity, Tuple<NetworkedPipeEntity, Direction>> cameFrom = new HashMap<NetworkedPipeEntity, Tuple<NetworkedPipeEntity, Direction>>();
        HashMap<NetworkedPipeEntity, Integer> gScore = new HashMap<NetworkedPipeEntity, Integer>();
        gScore.put(this, 0);
        HashMap<NetworkedPipeEntity, Integer> fScore = new HashMap<NetworkedPipeEntity, Integer>();
        fScore.put(this, 0);
        PriorityQueue<NetworkedPipeEntity> openSet = new PriorityQueue<NetworkedPipeEntity>(Comparator.comparingInt(fScore::get));
        openSet.add(this);
        while (!openSet.isEmpty()) {
            NetworkedPipeEntity current = openSet.poll();
            if (current == target) {
                while (cameFrom.containsKey((Object)current)) {
                    Tuple tuple = (Tuple)cameFrom.get((Object)current);
                    current = (NetworkedPipeEntity)((Object)tuple.a());
                    current.schedule(item.getStack(), (Direction)tuple.b());
                    current.setChanged();
                    level.sendBlockUpdated(current.getBlockPos(), current.getBlockState(), current.getBlockState(), 2);
                }
            }
            for (Direction side : current.networkDistances.keySet()) {
                Tuple tuple = (Tuple)current.networkDistances.get(side);
                BlockEntity blockEntity = level.getBlockEntity((BlockPos)tuple.a());
                if (!(blockEntity instanceof NetworkedPipeEntity)) continue;
                NetworkedPipeEntity neighbour = (NetworkedPipeEntity)blockEntity;
                int newScore = (Integer)gScore.get((Object)current) + (Integer)tuple.b();
                if (gScore.containsKey((Object)neighbour) && newScore >= (Integer)gScore.get((Object)neighbour)) continue;
                cameFrom.put(neighbour, new Tuple<NetworkedPipeEntity, Direction>(current, side));
                gScore.put(neighbour, newScore);
                fScore.put(neighbour, newScore + this.worldPosition.distChessboard((Vec3i)neighbour.worldPosition));
                if (openSet.contains((Object)neighbour)) continue;
                openSet.add(neighbour);
            }
        }
    }

    public void setNetwork(PipeNetwork network, ServerLevel level) {
        if (network != null) {
            network.addPipe(this);
        }
        this.network = network;
        this.setChanged();
        if (level != null) {
            level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
        }
    }

    public PipeNetwork getNetwork() {
        return this.network;
    }

    public boolean hasNetwork() {
        return this.network != null;
    }

    public void setController(boolean controller) {
        this.controller = controller;
    }

    public boolean isController() {
        return this.controller;
    }

    public void disconnect(ServerLevel level) {
        this.setController(false);
        this.routingSchedule.clear();
        if (this.hasNetwork()) {
            this.getNetwork().removePipe(level, this);
        }
        this.setNetwork(null, level);
    }

    public Tuple<Boolean, Set<NetworkedPipeEntity>> stillLinkedToNetwork(PipeNetwork network, ServerLevel level, BlockPos thisPos, Set<NetworkedPipeEntity> visited) {
        if (visited.contains((Object)this)) {
            return new Tuple<Boolean, Set<NetworkedPipeEntity>>(false, visited);
        }
        visited.add(this);
        if (network.getPos().equals((Object)thisPos)) {
            return new Tuple<Boolean, Set<NetworkedPipeEntity>>(true, visited);
        }
        for (Direction direction : this.networkDistances.keySet()) {
            BlockPos nextPos = (BlockPos)((Tuple)this.networkDistances.get(direction)).a();
            BlockEntity blockEntity = level.getBlockEntity(nextPos);
            if (!(blockEntity instanceof NetworkedPipeEntity)) continue;
            NetworkedPipeEntity nextPipe = (NetworkedPipeEntity)blockEntity;
            Tuple<Boolean, Set<NetworkedPipeEntity>> tuple = nextPipe.stillLinkedToNetwork(network, level, nextPos, visited);
            visited = tuple.b();
            if (!tuple.a().booleanValue()) continue;
            return tuple;
        }
        return new Tuple<Boolean, Set<NetworkedPipeEntity>>(false, visited);
    }

    public Tuple<PipeNetwork, Set<NetworkedPipeEntity>> findLinkedNetwork(ServerLevel level, BlockPos thisPos, Set<NetworkedPipeEntity> visited) {
        if (visited.contains((Object)this)) {
            return new Tuple<Object, Set<NetworkedPipeEntity>>(null, visited);
        }
        visited.add(this);
        if (this.hasNetwork() && this.getNetwork().getPos().equals((Object)thisPos)) {
            return new Tuple<PipeNetwork, Set<NetworkedPipeEntity>>(this.getNetwork(), visited);
        }
        for (Direction direction : this.networkDistances.keySet()) {
            BlockPos nextPos = (BlockPos)((Tuple)this.networkDistances.get(direction)).a();
            BlockEntity blockEntity = level.getBlockEntity(nextPos);
            if (!(blockEntity instanceof NetworkedPipeEntity)) continue;
            NetworkedPipeEntity nextPipe = (NetworkedPipeEntity)blockEntity;
            Tuple<PipeNetwork, Set<NetworkedPipeEntity>> tuple = nextPipe.findLinkedNetwork(level, nextPos, visited);
            visited = tuple.b();
            if (tuple.a() == null) continue;
            return tuple;
        }
        return new Tuple<Object, Set<NetworkedPipeEntity>>(null, visited);
    }

    public Set<NetworkedPipeEntity> disconnectAllLinked(ServerLevel level, Set<NetworkedPipeEntity> visited) {
        if (visited.contains((Object)this)) {
            return visited;
        }
        visited.add(this);
        this.disconnect(level);
        for (Direction direction : this.networkDistances.keySet()) {
            BlockPos nextPos = (BlockPos)((Tuple)this.networkDistances.get(direction)).a();
            BlockEntity blockEntity = level.getBlockEntity(nextPos);
            if (!(blockEntity instanceof NetworkedPipeEntity)) continue;
            NetworkedPipeEntity nextPipe = (NetworkedPipeEntity)blockEntity;
            visited = nextPipe.disconnectAllLinked(level, visited);
        }
        return visited;
    }

    public void networkChanged(ServerLevel level, BlockPos pos, boolean isLinked) {
        if (this.hasNetwork()) {
            if (!isLinked) {
                if (!this.stillLinkedToNetwork(this.getNetwork(), level, pos, new HashSet<NetworkedPipeEntity>()).a().booleanValue()) {
                    this.disconnectAllLinked(level, new HashSet<NetworkedPipeEntity>());
                    this.distributeNetwork(level, pos, new HashSet<NetworkedPipeEntity>(), new PipeNetwork(pos));
                }
            } else {
                this.distributeNetwork(level, pos, new HashSet<NetworkedPipeEntity>(), this.getNetwork());
            }
        } else {
            PipeNetwork network = this.findLinkedNetwork(level, pos, new HashSet<NetworkedPipeEntity>()).a();
            if (network != null) {
                this.setNetwork(network, level);
                this.setController(network.getPos().equals((Object)pos));
            } else {
                this.distributeNetwork(level, pos, new HashSet<NetworkedPipeEntity>(), new PipeNetwork(pos));
            }
        }
    }

    public void setRemoved() {
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.disconnect(serverLevel);
        }
        super.setRemoved();
    }

    @Override
    public short getTargetSpeed() {
        return 1024;
    }

    @Override
    public short getAcceleration() {
        return 64;
    }

    public boolean isDefaultRoute() {
        return false;
    }

    @Override
    protected void loadAdditional(ValueInput valueInput) {
        super.loadAdditional(valueInput);
        this.routingSchedule.clear();
        this.setController(valueInput.getBooleanOr("controller", false));
        if (this.isController()) {
            this.network = new PipeNetwork(this.getBlockPos(), SortingMode.fromByte(valueInput.getByteOr("sorting_mode", (byte)1)));
            ValueInput.TypedInputList requestedItems = valueInput.listOrEmpty("requested_items", RequestedItem.CODEC);
            for (RequestedItem requestedItem : requestedItems) {
                this.network.addRequestedItem(requestedItem);
            }
            this.syncedNetworkPos = this.getBlockPos();
        } else {
            this.syncedNetworkPos = valueInput.read("synced_network_pos", BlockPos.CODEC).orElse(this.getBlockPos());
        }
        ValueInput.TypedInputList routingList = valueInput.listOrEmpty("routing_schedule", ItemStackWithSlot.CODEC);
        for (ItemStackWithSlot slotStack : routingList) {
            this.routingSchedule.put(slotStack.stack(), new ScheduledRoute(Direction.from3DDataValue((int)slotStack.slot())));
        }
    }

    @Override
    protected void saveAdditional(ValueOutput valueOutput) {
        super.saveAdditional(valueOutput);
        valueOutput.putBoolean("controller", this.isController());
        if (this.hasNetwork() && this.isController()) {
            valueOutput.putByte("sorting_mode", this.getNetwork().getSortingMode().getValue());
            ValueOutput.TypedOutputList requestedItems = valueOutput.list("requested_items", RequestedItem.CODEC);
            for (RequestedItem requestedItem : this.getNetwork().getRequestedItems()) {
                if (requestedItem.isDelivered()) continue;
                requestedItems.add((Object)requestedItem);
            }
        }
        valueOutput.store("synced_network_pos", BlockPos.CODEC, (Object)(this.hasNetwork() ? this.network.getPos() : this.getBlockPos()));
        ValueOutput.TypedOutputList routingList = valueOutput.list("routing_schedule", ItemStackWithSlot.CODEC);
        for (ItemStack stack : this.routingSchedule.keySet()) {
            routingList.add((Object)new ItemStackWithSlot(this.routingSchedule.get(stack).getDirection().get3DDataValue(), stack));
        }
    }
}

