/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import jagm.classicpipes.blockentity.ItemPipeEntity;
import jagm.classicpipes.util.ItemInPipe;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionfc;

public class PipeRenderer
implements BlockEntityRenderer<ItemPipeEntity> {
    private final BlockEntityRendererProvider.Context context;

    public PipeRenderer(BlockEntityRendererProvider.Context context) {
        this.context = context;
    }

    public void render(ItemPipeEntity pipe, float partialTicks, PoseStack poses, MultiBufferSource bufferSource, int light, int overlay, Vec3 cameraPos) {
        PipeRenderer.renderPipeItems(this.context, pipe, partialTicks, poses, bufferSource, light, overlay);
    }

    public static void renderPipeItems(BlockEntityRendererProvider.Context context, ItemPipeEntity pipe, float partialTicks, PoseStack poses, MultiBufferSource bufferSource, int light, int overlay) {
        if (!pipe.isEmpty()) {
            for (ItemInPipe item : pipe.getContents()) {
                Direction direction = item.getProgress() < 1024 ? item.getFromDirection() : item.getTargetDirection();
                poses.pushPose();
                poses.translate(item.getRenderPosition(partialTicks));
                poses.scale(0.4375f, 0.4375f, 0.4375f);
                if (direction.equals((Object)Direction.EAST) || direction.equals((Object)Direction.WEST)) {
                    poses.mulPose((Quaternionfc)Axis.YP.rotationDegrees(90.0f));
                } else if (direction.equals((Object)Direction.UP) || direction.equals((Object)Direction.DOWN)) {
                    poses.mulPose((Quaternionfc)Axis.XP.rotationDegrees(90.0f));
                }
                context.getItemRenderer().renderStatic(item.getStack(), ItemDisplayContext.FIXED, light, overlay, poses, bufferSource, pipe.getLevel(), 0);
                poses.popPose();
            }
        }
    }
}

