/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.client.screen;

import jagm.classicpipes.client.screen.FilterScreen;
import jagm.classicpipes.client.screen.widget.SmallerCheckbox;
import jagm.classicpipes.inventory.menu.DiamondPipeMenu;
import jagm.classicpipes.network.ServerBoundMatchComponentsPayload;
import jagm.classicpipes.services.Services;
import jagm.classicpipes.util.MiscUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class DiamondPipeScreen
extends FilterScreen<DiamondPipeMenu> {
    private static final ResourceLocation BACKGROUND = MiscUtil.resourceLocation("textures/gui/container/diamond_pipe.png");

    public DiamondPipeScreen(DiamondPipeMenu menu, Inventory playerInventory, Component title) {
        super(menu, playerInventory, title);
        this.imageWidth = 176;
        this.imageHeight = 236;
        this.inventoryLabelY = this.imageHeight - 94;
    }

    protected void init() {
        super.init();
        this.leftPos = (this.width - 176) / 2;
        this.addRenderableWidget((GuiEventListener)SmallerCheckbox.builder().pos(this.leftPos + 8, this.topPos + 126).onValueChange(this::matchComponentsCheckboxChanged).tooltip(Tooltip.create((Component)Component.translatable((String)"tooltip.classicpipes.match_components"))).selected(((DiamondPipeMenu)this.getMenu()).getFilter().shouldMatchComponents()).label((Component)Component.translatable((String)"widget.classicpipes.match_components"), this.font).build());
    }

    public void render(GuiGraphics graphics, int x, int y, float f) {
        super.render(graphics, x, y, f);
        for (int i = 0; i < 6; ++i) {
            MutableComponent text = Component.translatable((String)("direction.classicpipes." + Direction.from3DDataValue((int)i).name().toLowerCase())).withStyle(ChatFormatting.BLACK);
            graphics.drawString(this.font, (Component)text, this.leftPos - 30 + (35 - this.font.width((FormattedText)text)) / 2, this.topPos + 22 + 18 * i, -12566464, false);
        }
        this.renderTooltip(graphics, x, y);
    }

    protected void renderBg(GuiGraphics graphics, float f, int x, int y) {
        int i = (this.width - 176) / 2 - 32;
        int j = (this.height - this.imageHeight) / 2;
        graphics.blit(RenderPipelines.GUI_TEXTURED, BACKGROUND, i, j, 0.0f, 0.0f, this.imageWidth + 32, this.imageHeight, 256, 256);
    }

    private void matchComponentsCheckboxChanged(SmallerCheckbox checkbox, boolean checked) {
        Services.LOADER_SERVICE.sendToServer(new ServerBoundMatchComponentsPayload(checked));
    }
}

