/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.item;

import jagm.classicpipes.ClassicPipes;
import jagm.classicpipes.item.LabelItem;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.stats.Stats;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.Level;

public class TagLabelItem
extends LabelItem {
    public TagLabelItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        block3: {
            String currentTag;
            ItemStack labelStack;
            ArrayList<String> tags;
            block5: {
                block4: {
                    block2: {
                        ItemStack targetStack = player.getItemInHand(hand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND);
                        tags = new ArrayList<String>();
                        for (TagKey tagKey : targetStack.getTags().toList()) {
                            tags.add(tagKey.location().toString());
                        }
                        if (!targetStack.isEmpty()) break block2;
                        if (!level.isClientSide()) break block3;
                        player.displayClientMessage((Component)Component.translatable((String)"chat.classicpipes.nothing_in_offhand"), false);
                        break block3;
                    }
                    if (!tags.isEmpty()) break block4;
                    if (!level.isClientSide()) break block3;
                    player.displayClientMessage((Component)Component.translatable((String)"chat.classicpipes.no_tags_in_hand"), false);
                    break block3;
                }
                labelStack = player.getItemInHand(hand);
                currentTag = (String)labelStack.get(ClassicPipes.LABEL_COMPONENT);
                if (currentTag != null && tags.contains(currentTag)) break block5;
                labelStack.set(ClassicPipes.LABEL_COMPONENT, (Object)((String)tags.getFirst()));
                if (!level.isClientSide()) break block3;
                player.displayClientMessage(this.tagSetMessage((String)tags.getFirst()), false);
                break block3;
            }
            for (int i = 0; i < tags.size(); ++i) {
                if (!((String)tags.get(i)).equals(currentTag)) continue;
                String tag = (String)tags.get((i + 1) % tags.size());
                labelStack.set(ClassicPipes.LABEL_COMPONENT, (Object)tag);
                if (!level.isClientSide()) break;
                player.displayClientMessage(this.tagSetMessage(tag), false);
                break;
            }
        }
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        return InteractionResult.SUCCESS;
    }

    private Component tagSetMessage(String tag) {
        MutableComponent tagTranslation = Component.translatableWithFallback((String)TagLabelItem.labelToTranslationKey(tag), (String)"");
        if (tagTranslation.getString().isEmpty()) {
            return Component.translatable((String)"chat.classicpipes.tag_set", (Object[])new Object[]{Component.literal((String)("#" + tag)).withStyle(ChatFormatting.YELLOW)});
        }
        return Component.translatable((String)"chat.classicpipes.tag_set_translatable", (Object[])new Object[]{Component.literal((String)("#" + tag)).withStyle(ChatFormatting.YELLOW), tagTranslation.withStyle(ChatFormatting.YELLOW)});
    }

    private static String labelToTranslationKey(String label) {
        String[] split = label.split(":");
        if (split.length < 2) {
            return "tag.item.minecraft." + label.replace("/", ".");
        }
        return "tag.item." + split[0] + "." + split[1].replace("/", ".");
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> tooltipAdder, TooltipFlag flag) {
        String tag = (String)stack.get(ClassicPipes.LABEL_COMPONENT);
        if (tag != null) {
            MutableComponent tagTranslation = Component.translatableWithFallback((String)TagLabelItem.labelToTranslationKey(tag), (String)"");
            if (!tagTranslation.getString().isEmpty()) {
                tooltipAdder.accept((Component)tagTranslation.withStyle(ChatFormatting.YELLOW));
            }
            tooltipAdder.accept((Component)Component.literal((String)("#" + tag)).withStyle(ChatFormatting.YELLOW));
        } else {
            tooltipAdder.accept((Component)Component.translatable((String)"item.classicpipes.tag_label.desc").withStyle(ChatFormatting.GRAY));
        }
    }

    @Override
    public boolean itemMatches(ItemStack tagStack, ItemStack compareStack) {
        String tag = (String)tagStack.get(ClassicPipes.LABEL_COMPONENT);
        if (tag != null) {
            for (TagKey tagKey : compareStack.getTags().toList()) {
                if (!tag.equals(tagKey.location().toString())) continue;
                return true;
            }
        }
        return false;
    }
}

