/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.blockentity;

import jagm.classicpipes.ClassicPipes;
import jagm.classicpipes.blockentity.CopperPipeEntity;
import jagm.classicpipes.inventory.container.Filter;
import jagm.classicpipes.inventory.container.SingleItemFilterContainer;
import jagm.classicpipes.inventory.menu.AdvancedCopperPipeMenu;
import jagm.classicpipes.util.MiscUtil;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;

public class AdvancedCopperPipeEntity
extends CopperPipeEntity
implements MenuProvider {
    private final SingleItemFilterContainer filter = new SingleItemFilterContainer(this, 9, false);

    public AdvancedCopperPipeEntity(BlockPos pos, BlockState state) {
        super(ClassicPipes.ADVANCED_COPPER_PIPE_ENTITY, pos, state);
    }

    @Override
    protected int extractAmount() {
        return 64;
    }

    @Override
    protected Predicate<ItemStack> filterPredicate() {
        return stack -> this.filter.isEmpty() || this.filter.matches((ItemStack)stack);
    }

    public Component getDisplayName() {
        return Component.translatable((String)"container.classicpipes.advanced_copper_pipe");
    }

    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
        return new AdvancedCopperPipeMenu(id, inventory, (Filter)this.filter);
    }

    @Override
    public short getTargetSpeed() {
        return 512;
    }

    @Override
    public short getAcceleration() {
        return 16;
    }

    public boolean shouldMatchComponents() {
        return this.filter.shouldMatchComponents();
    }

    @Override
    protected void loadAdditional(CompoundTag valueInput, HolderLookup.Provider registries) {
        this.filter.clearContent();
        super.loadAdditional(valueInput, registries);
        ListTag filterList = valueInput.getList("filter", 10);
        filterList.forEach(tag -> {
            if (tag instanceof CompoundTag) {
                CompoundTag compoundTag = (CompoundTag)tag;
                int slot = compoundTag.getInt("slot");
                MiscUtil.loadFromTag(tag, ItemStack.CODEC, registries, stack -> this.filter.setItem(slot, (ItemStack)stack));
            }
        });
        this.filter.setMatchComponents(valueInput.getBoolean("match_components"));
    }

    @Override
    protected void saveAdditional(CompoundTag valueOutput, HolderLookup.Provider registries) {
        super.saveAdditional(valueOutput, registries);
        ListTag filterList = new ListTag();
        for (int slot = 0; slot < this.filter.getContainerSize(); ++slot) {
            ItemStack stack = this.filter.getItem(slot);
            if (stack.isEmpty()) continue;
            CompoundTag tag = new CompoundTag();
            tag.putInt("slot", slot);
            MiscUtil.saveToTag((Tag)tag, stack, ItemStack.CODEC, registries, arg_0 -> filterList.add(arg_0));
        }
        valueOutput.put("filter", (Tag)filterList);
        valueOutput.putBoolean("match_components", this.filter.shouldMatchComponents());
    }
}

