/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.block;

import jagm.classicpipes.block.FluidPipeBlock;
import jagm.classicpipes.blockentity.ItemPipeEntity;
import jagm.classicpipes.blockentity.PipeEntity;
import jagm.classicpipes.services.Services;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.TransparentBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class PipeBlock
extends TransparentBlock
implements SimpleWaterloggedBlock,
EntityBlock,
Equipable {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    protected final VoxelShape[] shapeByIndex;

    public PipeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.shapeByIndex = this.makeShapes();
    }

    private VoxelShape[] makeShapes() {
        float a = 0.25f;
        float f = 0.5f - a;
        float f1 = 0.5f + a;
        VoxelShape voxelshape = Block.box((double)(f * 16.0f), (double)(f * 16.0f), (double)(f * 16.0f), (double)(f1 * 16.0f), (double)(f1 * 16.0f), (double)(f1 * 16.0f));
        VoxelShape[] avoxelshape = new VoxelShape[6];
        for (int i = 0; i < 6; ++i) {
            Direction direction = Direction.from3DDataValue((int)i);
            avoxelshape[i] = Shapes.box((double)(0.5 + Math.min((double)(-a), (double)direction.getStepX() * 0.5)), (double)(0.5 + Math.min((double)(-a), (double)direction.getStepY() * 0.5)), (double)(0.5 + Math.min((double)(-a), (double)direction.getStepZ() * 0.5)), (double)(0.5 + Math.max((double)a, (double)direction.getStepX() * 0.5)), (double)(0.5 + Math.max((double)a, (double)direction.getStepY() * 0.5)), (double)(0.5 + Math.max((double)a, (double)direction.getStepZ() * 0.5)));
        }
        VoxelShape[] avoxelshape1 = new VoxelShape[64];
        for (int k = 0; k < 64; ++k) {
            VoxelShape voxelshape1 = voxelshape;
            for (int j = 0; j < 6; ++j) {
                if ((k & 1 << j) == 0) continue;
                voxelshape1 = Shapes.or((VoxelShape)voxelshape1, (VoxelShape)avoxelshape[j]);
            }
            avoxelshape1[k] = voxelshape1;
        }
        return avoxelshape1;
    }

    public abstract boolean isPipeConnected(BlockState var1, Direction var2);

    public abstract BlockState setPipeConnected(BlockState var1, Direction var2, boolean var3);

    protected boolean canConnect(Level level, BlockPos pipePos, Direction direction) {
        BlockPos neighbourPos = pipePos.relative(direction);
        Block block = level.getBlockState(neighbourPos).getBlock();
        if (block instanceof PipeBlock) {
            PipeBlock pipeBlock = (PipeBlock)block;
            return PipeBlock.canConnectToPipeBothWays(this, pipeBlock);
        }
        return Services.LOADER_SERVICE.canAccessContainer(level, neighbourPos, direction.getOpposite());
    }

    protected static boolean canConnectToPipeBothWays(PipeBlock pipe1, PipeBlock pipe2) {
        return pipe1.canConnectToPipe(pipe2) && pipe2.canConnectToPipe(pipe1);
    }

    protected boolean canConnectToPipe(PipeBlock pipeBlock) {
        return true;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().trySetValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.getLevel().getFluidState(context.getClickedPos()).is((Fluid)Fluids.WATER)));
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pipePos, BlockPos neighborPos) {
        BlockEntity blockEntity;
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pipePos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        boolean wasConnected = this.isPipeConnected(state, direction);
        boolean willConnect = this.canConnect((Level)level, pipePos, direction);
        BlockState newState = this.setPipeConnected(state, direction, willConnect);
        if (wasConnected != willConnect && (blockEntity = level.getBlockEntity(pipePos)) instanceof PipeEntity) {
            PipeEntity pipe = (PipeEntity)blockEntity;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                pipe.update(serverLevel, newState, pipePos, direction, wasConnected);
            }
        }
        return newState;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WATERLOGGED});
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    protected FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    protected boolean propagatesSkylightDown(BlockState state, BlockGetter level, BlockPos pos) {
        return false;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.shapeByIndex[this.getAABBIndex(state)];
    }

    protected int getAABBIndex(BlockState state) {
        int i = 0;
        for (int j = 0; j < 6; ++j) {
            if (!this.isPipeConnected(state, Direction.from3DDataValue((int)j))) continue;
            i |= 1 << j;
        }
        return i;
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        ServerLevel serverLevel;
        BlockEntity blockEntity;
        if (!(this instanceof FluidPipeBlock) && level instanceof ServerLevel && (blockEntity = (serverLevel = (ServerLevel)level).getBlockEntity(pos)) instanceof ItemPipeEntity) {
            ItemPipeEntity pipe = (ItemPipeEntity)blockEntity;
            pipe.dropItems(serverLevel, pos);
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    protected boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    protected int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof PipeEntity) {
            PipeEntity pipe = (PipeEntity)blockEntity;
            return pipe.getComparatorOutput();
        }
        return 0;
    }

    public EquipmentSlot getEquipmentSlot() {
        return EquipmentSlot.HEAD;
    }

    public InteractionResultHolder<ItemStack> swapWithEquipmentSlot(Item item, Level level, Player player, InteractionHand hand) {
        return InteractionResultHolder.fail((Object)player.getItemInHand(hand));
    }
}

