/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.blockentity;

import jagm.classicpipes.ClassicPipes;
import jagm.classicpipes.block.NetworkedPipeBlock;
import jagm.classicpipes.blockentity.MatchingPipe;
import jagm.classicpipes.blockentity.NetworkedPipeEntity;
import jagm.classicpipes.blockentity.PipeEntity;
import jagm.classicpipes.services.Services;
import jagm.classicpipes.util.ItemInPipe;
import jagm.classicpipes.util.MiscUtil;
import jagm.classicpipes.util.Tuple;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public abstract class ItemPipeEntity
extends PipeEntity {
    protected final List<ItemInPipe> contents = new ArrayList<ItemInPipe>();
    protected final List<ItemInPipe> queued = new ArrayList<ItemInPipe>();
    public final Map<Direction, Tuple<BlockPos, Integer>> networkDistances = new HashMap<Direction, Tuple<BlockPos, Integer>>();
    private boolean networkingInitialised = false;
    private final Map<ItemInPipe, Long> tickAdded = new HashMap<ItemInPipe, Long>();

    public ItemPipeEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void tickServer(ServerLevel level, BlockPos pos, BlockState state) {
        boolean sendBlockUpdate = false;
        if (!this.networkingInitialised) {
            this.initialiseNetworking(level, state, pos);
            this.networkingInitialised = true;
            sendBlockUpdate = true;
        }
        if (!this.isEmpty()) {
            ListIterator<ItemInPipe> iterator = this.contents.listIterator();
            while (iterator.hasNext()) {
                ItemInPipe item = iterator.next();
                if (this.tickAdded.containsKey(item)) {
                    if (this.tickAdded.get(item).longValue() == level.m_46467_()) continue;
                    this.tickAdded.remove(item);
                }
                item.move(this.getTargetSpeed(), this.getAcceleration());
                if (item.getAge() > 24000) {
                    iterator.remove();
                    sendBlockUpdate = true;
                    continue;
                }
                if (item.getProgress() >= 1024 && item.isEjecting()) {
                    iterator.remove();
                    this.eject(level, pos, item);
                    sendBlockUpdate = true;
                    continue;
                }
                if (item.getProgress() < 2048) continue;
                if (Services.LOADER_SERVICE.handleItemInsertion(this, level, pos, state, item)) {
                    iterator.remove();
                } else {
                    ItemPipeEntity itemPipeEntity = this;
                    if (itemPipeEntity instanceof MatchingPipe) {
                        MatchingPipe matchingPipe = (MatchingPipe)((Object)itemPipeEntity);
                        matchingPipe.markCannotFit(item.getStack());
                    }
                }
                sendBlockUpdate = true;
            }
            this.addQueuedItems((Level)level, false);
        }
        if (sendBlockUpdate) {
            level.m_7260_(pos, state, state, 2);
        }
    }

    @Override
    public void tickClient(Level level, BlockPos pos) {
        if (!this.isEmpty()) {
            ListIterator<ItemInPipe> iterator = this.contents.listIterator();
            while (iterator.hasNext()) {
                BlockPos nextPos;
                BlockEntity blockEntity;
                ItemInPipe item = iterator.next();
                if (this.tickAdded.containsKey(item)) {
                    if (this.tickAdded.get(item).longValue() == level.m_46467_()) continue;
                    this.tickAdded.remove(item);
                }
                item.move(this.getTargetSpeed(), this.getAcceleration());
                if (item.getProgress() < 2048 || !((blockEntity = level.m_7702_(nextPos = pos.m_121945_(item.getTargetDirection()))) instanceof ItemPipeEntity)) continue;
                ItemPipeEntity nextPipe = (ItemPipeEntity)blockEntity;
                item.resetProgress(item.getTargetDirection().m_122424_());
                nextPipe.insertPipeItem(level, item);
                iterator.remove();
            }
        }
    }

    public void insertPipeItem(Level level, ItemInPipe item) {
        this.queued.add(item);
        this.routeItem(item);
        this.addQueuedItems(level, true);
    }

    public void addQueuedItems(Level level, boolean waitForNextTick) {
        for (ItemInPipe item : this.queued) {
            this.contents.add(item);
            if (!waitForNextTick) continue;
            this.tickAdded.put(item, level.m_46467_());
        }
        this.m_6596_();
        this.queued.clear();
    }

    public abstract void routeItem(BlockState var1, ItemInPipe var2);

    public final void routeItem(ItemInPipe item) {
        this.routeItem(this.m_58900_(), item);
    }

    protected boolean canJoinNetwork() {
        return true;
    }

    @Override
    public void update(ServerLevel level, BlockState state, BlockPos pos, Direction direction, boolean wasConnected) {
        if (!this.isEmpty()) {
            ListIterator<ItemInPipe> iterator = this.contents.listIterator();
            while (iterator.hasNext()) {
                ItemInPipe item = iterator.next();
                if (!wasConnected || item.getTargetDirection() == direction && item.getFromDirection() != direction && item.getProgress() < 1024) {
                    this.routeItem(state, item);
                    continue;
                }
                if ((item.getFromDirection() != direction || item.getProgress() >= 1024) && (item.getTargetDirection() != direction || item.getProgress() < 1024)) continue;
                iterator.remove();
                item.drop(level, pos);
            }
            this.addQueuedItems((Level)level, false);
        }
        if (wasConnected) {
            this.networkDistances.remove(direction);
        }
        boolean flaggedChange = false;
        for (Direction otherDirection : Direction.values()) {
            if (this.isPipeConnected(state, otherDirection)) continue;
            this.networkDistances.remove(otherDirection);
            ItemPipeEntity itemPipeEntity = this;
            if (!(itemPipeEntity instanceof NetworkedPipeEntity)) continue;
            NetworkedPipeEntity networkedPipe = (NetworkedPipeEntity)itemPipeEntity;
            if (flaggedChange) continue;
            networkedPipe.networkChanged(level, pos, false);
            flaggedChange = true;
        }
        for (Direction otherDirection : Direction.values()) {
            BlockEntity blockEntity;
            BlockPos nextPos = pos.m_121945_(otherDirection);
            if (!this.isPipeConnected(state, otherDirection) || !((blockEntity = level.m_7702_(nextPos)) instanceof ItemPipeEntity)) continue;
            ItemPipeEntity nextPipe = (ItemPipeEntity)blockEntity;
            this.updateNetworking(level, state, pos, nextPipe, nextPos, otherDirection, new HashSet<Tuple<BlockPos, Direction>>(), true);
        }
        this.m_6596_();
        level.m_7260_(pos, state, state, 2);
    }

    protected void initialiseNetworking(ServerLevel level, BlockState state, BlockPos pos) {
        Set<Tuple<BlockPos, Direction>> visited = new HashSet<Tuple<BlockPos, Direction>>();
        for (Direction direction : Direction.values()) {
            BlockEntity blockEntity;
            BlockPos nextPos = pos.m_121945_(direction);
            if (this.isPipeConnected(state, direction) && (blockEntity = level.m_7702_(nextPos)) instanceof ItemPipeEntity) {
                ItemPipeEntity nextPipe = (ItemPipeEntity)blockEntity;
                visited = this.updateNetworking(level, state, pos, nextPipe, nextPos, direction, visited, false);
                continue;
            }
            this.networkDistances.remove(direction);
        }
        this.m_6596_();
    }

    private Set<Tuple<BlockPos, Direction>> updateNetworking(ServerLevel level, BlockState state, BlockPos pos, ItemPipeEntity nextPipe, BlockPos nextPos, Direction nextDirection, Set<Tuple<BlockPos, Direction>> visited, boolean triggerNetworkChanges) {
        Block wasLinked22;
        NetworkedPipeEntity networkedPipe;
        Tuple<BlockPos, Integer> tuple;
        for (Tuple<BlockPos, Direction> tuple2 : visited) {
            if (!tuple2.a().equals((Object)pos) || !tuple2.b().equals((Object)nextDirection)) continue;
            return visited;
        }
        visited.add(new Tuple<BlockPos, Direction>(pos, nextDirection));
        if (this instanceof NetworkedPipeEntity && nextPipe.canJoinNetwork()) {
            nextPipe.networkDistances.put(nextDirection.m_122424_(), new Tuple<BlockPos, Integer>(pos, 1));
        } else {
            boolean hasNetworkConnection = false;
            if (this.countConnections(state) < 3) {
                for (Direction direction : this.networkDistances.keySet()) {
                    if (direction.equals((Object)nextDirection) || !nextPipe.canJoinNetwork()) continue;
                    tuple = this.networkDistances.get(direction);
                    nextPipe.networkDistances.put(nextDirection.m_122424_(), new Tuple<BlockPos, Integer>(tuple.a(), tuple.b() + 1));
                    hasNetworkConnection = true;
                }
            }
            if (!hasNetworkConnection) {
                nextPipe.networkDistances.remove(nextDirection.m_122424_());
            }
        }
        if (nextPipe instanceof NetworkedPipeEntity && this.canJoinNetwork()) {
            this.networkDistances.put(nextDirection, new Tuple<BlockPos, Integer>(nextPos, 1));
        } else {
            boolean hasNetworkConnection = false;
            if (nextPipe.countConnections(nextPipe.m_58900_()) < 3) {
                for (Direction direction : nextPipe.networkDistances.keySet()) {
                    if (direction.equals((Object)nextDirection.m_122424_()) || !this.canJoinNetwork()) continue;
                    tuple = nextPipe.networkDistances.get(direction);
                    this.networkDistances.put(nextDirection, new Tuple<BlockPos, Integer>(tuple.a(), tuple.b() + 1));
                    hasNetworkConnection = true;
                }
            }
            if (!hasNetworkConnection) {
                this.networkDistances.remove(nextDirection);
            }
            for (Direction direction : Direction.values()) {
                BlockEntity blockEntity;
                if (direction.equals((Object)nextDirection.m_122424_())) continue;
                BlockPos anotherPos = nextPos.m_121945_(direction);
                if (nextPipe.isPipeConnected(nextPipe.m_58900_(), direction) && (blockEntity = level.m_7702_(anotherPos)) instanceof ItemPipeEntity) {
                    ItemPipeEntity anotherPipe = (ItemPipeEntity)blockEntity;
                    visited = nextPipe.updateNetworking(level, nextPipe.m_58900_(), nextPos, anotherPipe, anotherPos, direction, visited, triggerNetworkChanges);
                    continue;
                }
                nextPipe.networkDistances.remove(direction);
            }
        }
        ItemPipeEntity direction = this;
        if (direction instanceof NetworkedPipeEntity) {
            networkedPipe = (NetworkedPipeEntity)direction;
            direction = state.m_60734_();
            if (direction instanceof NetworkedPipeBlock) {
                boolean isLinked;
                NetworkedPipeBlock networkedPipeBlock = (NetworkedPipeBlock)((Object)direction);
                boolean wasLinked22 = networkedPipeBlock.isLinked(state, nextDirection);
                if (wasLinked22 != (isLinked = this.networkDistances.containsKey(nextDirection)) && triggerNetworkChanges) {
                    networkedPipe.networkChanged(level, pos, isLinked);
                }
                level.m_7731_(pos, networkedPipeBlock.setLinked(state, nextDirection, isLinked), 3);
            }
        }
        if (nextPipe instanceof NetworkedPipeEntity && (wasLinked22 = (networkedPipe = (NetworkedPipeEntity)nextPipe).m_58900_().m_60734_()) instanceof NetworkedPipeBlock) {
            boolean isLinked;
            NetworkedPipeBlock networkedPipeBlock = (NetworkedPipeBlock)wasLinked22;
            boolean wasLinked3 = networkedPipeBlock.isLinked(networkedPipe.m_58900_(), nextDirection.m_122424_());
            if (wasLinked3 != (isLinked = networkedPipe.networkDistances.containsKey(nextDirection.m_122424_())) && triggerNetworkChanges) {
                networkedPipe.networkChanged(level, nextPos, isLinked);
            }
            level.m_7731_(nextPos, networkedPipeBlock.setLinked(networkedPipe.m_58900_(), nextDirection.m_122424_(), isLinked), 3);
        }
        this.m_6596_();
        level.m_7260_(pos, state, state, 2);
        nextPipe.m_6596_();
        level.m_7260_(nextPos, nextPipe.m_58900_(), nextPipe.m_58900_(), 2);
        return visited;
    }

    public void eject(ServerLevel level, BlockPos pos, ItemInPipe item) {
        if (!item.getStack().m_41619_()) {
            Vec3 offset = new Vec3(item.getTargetDirection() == Direction.WEST ? 0.125 : (double)(item.getTargetDirection() == Direction.EAST ? 0.875f : 0.5f), item.getTargetDirection() == Direction.DOWN ? 0.0 : (double)(item.getTargetDirection() == Direction.UP ? 0.75f : 0.375f), item.getTargetDirection() == Direction.NORTH ? 0.125 : (double)(item.getTargetDirection() == Direction.SOUTH ? 0.875f : 0.5f));
            ItemEntity ejectedItem = new ItemEntity((Level)level, (double)pos.m_123341_() + offset.f_82479_, (double)pos.m_123342_() + offset.f_82480_, (double)pos.m_123343_() + offset.f_82481_, item.getStack());
            float v = (float)item.getSpeed() / 2048.0f;
            ejectedItem.m_20334_(item.getTargetDirection() == Direction.WEST ? (double)(-v) : (double)(item.getTargetDirection() == Direction.EAST ? v : 0.0f), item.getTargetDirection() == Direction.DOWN ? (double)(-v) : (double)(item.getTargetDirection() == Direction.UP ? v : 0.0f), item.getTargetDirection() == Direction.NORTH ? (double)(-v) : (double)(item.getTargetDirection() == Direction.SOUTH ? v : 0.0f));
            ejectedItem.m_32060_();
            level.m_7967_((Entity)ejectedItem);
            level.m_247517_(null, pos, ClassicPipes.PIPE_EJECT_SOUND, SoundSource.BLOCKS);
        }
    }

    public void dropItems(ServerLevel serverLevel, BlockPos pos) {
        for (ItemInPipe item : this.contents) {
            item.drop(serverLevel, pos);
        }
    }

    public List<ItemInPipe> getContents() {
        return this.contents;
    }

    public void setItem(Direction side, ItemStack stack) {
        Level level = this.m_58904_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (!stack.m_41619_()) {
                ItemInPipe item = new ItemInPipe(stack, side, side.m_122424_());
                this.insertPipeItem((Level)serverLevel, item);
                serverLevel.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
            }
        }
        this.m_6596_();
    }

    public void m_142466_(CompoundTag valueInput) {
        this.clearContent();
        this.networkDistances.clear();
        this.tickAdded.clear();
        super.m_142466_(valueInput);
        ListTag itemsList = valueInput.m_128437_("items", 10);
        itemsList.forEach(tag -> MiscUtil.loadFromTag(tag, ItemInPipe.CODEC, this.contents::add));
        for (Direction direction : Direction.values()) {
            MiscUtil.loadFromTag(valueInput.m_128423_(direction.m_122433_() + "_pos"), BlockPos.f_121852_, pos -> {
                if (valueInput.m_128441_(direction.m_122433_() + "_distance")) {
                    this.networkDistances.put(direction, new Tuple<BlockPos, Integer>((BlockPos)pos, valueInput.m_128451_(direction.m_122433_() + "_distance")));
                }
            });
        }
    }

    protected void m_183515_(CompoundTag valueOutput) {
        super.m_183515_(valueOutput);
        ListTag itemsList = new ListTag();
        for (ItemInPipe item : this.contents) {
            if (item.getStack().m_41619_()) continue;
            MiscUtil.saveToTag(item, ItemInPipe.CODEC, arg_0 -> itemsList.add(arg_0));
        }
        valueOutput.m_128365_("items", (Tag)itemsList);
        for (Direction direction : this.networkDistances.keySet()) {
            Tuple<BlockPos, Integer> tuple = this.networkDistances.get(direction);
            MiscUtil.saveToTag(tuple.a(), BlockPos.f_121852_, tag -> valueOutput.m_128365_(direction.m_122433_() + "_pos", tag));
            valueOutput.m_128405_(direction.m_122433_() + "_distance", tuple.b().intValue());
        }
    }

    public void clearContent() {
        this.contents.clear();
    }

    public boolean isEmpty() {
        return this.contents.isEmpty();
    }

    public boolean stillValid(Player player) {
        return Container.m_272074_((BlockEntity)this, (Player)player);
    }

    @Override
    public int getComparatorOutput() {
        return Math.min(15, this.getContents().size());
    }
}

