/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.blockentity;

import jagm.classicpipes.ClassicPipes;
import jagm.classicpipes.block.NetworkedPipeBlock;
import jagm.classicpipes.block.RecipePipeBlock;
import jagm.classicpipes.blockentity.ItemPipeEntity;
import jagm.classicpipes.blockentity.NetworkedPipeEntity;
import jagm.classicpipes.inventory.container.FilterContainer;
import jagm.classicpipes.inventory.menu.RecipePipeMenu;
import jagm.classicpipes.services.Services;
import jagm.classicpipes.util.ItemInPipe;
import jagm.classicpipes.util.MiscUtil;
import jagm.classicpipes.util.RequestedItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class RecipePipeEntity
extends NetworkedPipeEntity
implements MenuProvider {
    private static final byte DEFAULT_COOLDOWN = 8;
    private final FilterContainer filter = new FilterContainer(this, 10, true);
    private final Direction[] slotDirections = new Direction[10];
    private final NonNullList<ItemStack> heldItems;
    private int waitingForCraft;
    private byte cooldown;

    public RecipePipeEntity(BlockPos pos, BlockState state) {
        super(ClassicPipes.RECIPE_PIPE_ENTITY, pos, state);
        List<Direction> buttonDirections = this.getDirectionsForButtons(state);
        Arrays.fill(this.slotDirections, buttonDirections.isEmpty() ? Direction.DOWN : buttonDirections.get(0));
        this.heldItems = NonNullList.m_122780_((int)9, (Object)ItemStack.f_41583_);
    }

    public Direction[] getSlotDirections() {
        return this.slotDirections;
    }

    public void setSlotDirection(int slot, Direction direction) {
        this.slotDirections[slot] = direction;
    }

    @Override
    public void tickServer(ServerLevel level, BlockPos pos, BlockState state) {
        super.tickServer(level, pos, state);
        BlockPos crafterPos = pos.m_121945_(this.slotDirections[9]);
        if (this.waitingForCraft > 0) {
            BlockEntity container = level.m_7702_(crafterPos);
            byte by = this.cooldown;
            this.cooldown = (byte)(by - 1);
            if (by <= 0) {
                if (!(container instanceof ItemPipeEntity) && Services.LOADER_SERVICE.extractSpecificItem(this, level, crafterPos, this.slotDirections[9].m_122424_(), this.getResult().m_255036_(1))) {
                    level.m_7260_(pos, state, state, 2);
                    this.m_6596_();
                }
                this.cooldown = (byte)8;
            }
        } else if (!this.queued.isEmpty()) {
            this.addQueuedItems((Level)level, false);
        }
    }

    @Override
    public void update(ServerLevel level, BlockState state, BlockPos pos, Direction direction, boolean wasConnected) {
        super.update(level, state, pos, direction, wasConnected);
        this.checkSlotDirections();
    }

    @Override
    protected void initialiseNetworking(ServerLevel level, BlockState state, BlockPos pos) {
        super.initialiseNetworking(level, state, pos);
        this.checkSlotDirections();
    }

    private void checkSlotDirections() {
        List<Direction> buttonDirections = this.getDirectionsForButtons(this.m_58900_());
        if (!buttonDirections.isEmpty()) {
            for (int i = 0; i < this.slotDirections.length; ++i) {
                if (buttonDirections.contains(this.slotDirections[i])) continue;
                this.slotDirections[i] = buttonDirections.get(0);
                this.m_6596_();
            }
        }
    }

    @Override
    public void eject(ServerLevel level, BlockPos pos, ItemInPipe item) {
        ArrayList<Integer> matchingSlots = new ArrayList<Integer>();
        for (int slot = 0; slot < 9; ++slot) {
            if (!ItemStack.m_150942_((ItemStack)this.filter.m_8020_(slot), (ItemStack)item.getStack())) continue;
            matchingSlots.add(slot);
        }
        if (!matchingSlots.isEmpty()) {
            ItemStack stack = item.getStack().m_41777_();
            while (!stack.m_41619_()) {
                int minSlot = (Integer)matchingSlots.get(0);
                int minAmount = ((ItemStack)this.heldItems.get(minSlot)).m_41613_();
                Iterator iterator = matchingSlots.iterator();
                while (iterator.hasNext()) {
                    int slot = (Integer)iterator.next();
                    int slotAmount = ((ItemStack)this.heldItems.get(slot)).m_41613_();
                    if (slotAmount >= minAmount) continue;
                    minSlot = slot;
                    minAmount = slotAmount;
                }
                this.heldItems.set(minSlot, (Object)stack.m_255036_(((ItemStack)this.heldItems.get(minSlot)).m_41613_() + 1));
                stack.m_41774_(1);
            }
        } else {
            super.eject(level, pos, item);
        }
        this.attemptCraft();
        this.m_6596_();
    }

    private void attemptCraft() {
        if (this.waitingForCraft == 0) {
            int slot;
            boolean readyToCraft = true;
            for (slot = 0; slot < 9; ++slot) {
                if (((ItemStack)this.heldItems.get(slot)).m_41613_() < this.filter.m_8020_(slot).m_41613_()) {
                    readyToCraft = false;
                    break;
                }
                BlockState state = this.m_58900_();
                if (this.filter.m_8020_(slot).m_41619_() || ((NetworkedPipeBlock.ConnectionState)((Object)state.m_61143_((Property)RecipePipeBlock.PROPERTY_BY_DIRECTION.get(this.slotDirections[slot])))).equals((Object)NetworkedPipeBlock.ConnectionState.UNLINKED)) continue;
                readyToCraft = false;
                Level level = this.m_58904_();
                if (!(level instanceof ServerLevel)) break;
                ServerLevel serverLevel = (ServerLevel)level;
                if (!this.hasNetwork()) break;
                for (RequestedItem requestedItem : this.getNetwork().getRequestedItems()) {
                    if (!requestedItem.matches(this.getResult())) continue;
                    requestedItem.sendMessage(serverLevel, (Component)Component.m_237110_((String)"chat.classicpipes.missing_recipe_pipe_direction", (Object[])new Object[]{this.m_58899_().m_123344_()}).m_130940_(ChatFormatting.RED));
                }
                this.waitingForCraft = 0;
                this.getNetwork().resetRequests(serverLevel);
                this.m_6596_();
                serverLevel.m_7260_(this.m_58899_(), state, state, 2);
                break;
            }
            if (readyToCraft) {
                for (slot = 0; slot < 9; ++slot) {
                    ItemStack ingredient = this.filter.m_8020_(slot);
                    if (ingredient.m_41619_()) continue;
                    ((ItemStack)this.heldItems.get(slot)).m_41774_(ingredient.m_41613_());
                    this.queued.add(new ItemInPipe(ingredient.m_41777_(), 64, 1024, Direction.DOWN, this.slotDirections[slot], false, 0));
                }
                this.waitingForCraft = this.getResult().m_41613_();
            }
        }
    }

    public ItemStack getResult() {
        return this.filter.m_8020_(9).m_41777_();
    }

    public List<ItemStack> getIngredients() {
        ArrayList<ItemStack> ingredients = new ArrayList<ItemStack>();
        for (int i = 0; i < 9; ++i) {
            ItemStack ingredient = this.filter.m_8020_(i).m_41777_();
            if (ingredient.m_41619_()) continue;
            ingredients.add(ingredient);
        }
        return ingredients;
    }

    public List<ItemStack> getIngredientsCollated() {
        List<ItemStack> ingredients = this.getIngredients();
        ArrayList<ItemStack> collated = new ArrayList<ItemStack>();
        for (ItemStack ingredient : ingredients) {
            boolean matched = false;
            for (ItemStack stack : collated) {
                if (!ItemStack.m_150942_((ItemStack)ingredient, (ItemStack)stack)) continue;
                stack.m_41769_(ingredient.m_41613_());
                matched = true;
                break;
            }
            if (matched) continue;
            collated.add(ingredient);
        }
        return collated;
    }

    public NonNullList<ItemStack> getHeldItems() {
        return this.heldItems;
    }

    public void dropHeldItems(ServerLevel serverLevel, BlockPos pos) {
        for (ItemStack stack : this.heldItems) {
            if (stack.m_41619_()) continue;
            ItemEntity droppedItem = new ItemEntity((Level)serverLevel, (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f), (double)((float)pos.m_123343_() + 0.5f), stack);
            droppedItem.m_32060_();
            serverLevel.m_7967_((Entity)droppedItem);
        }
        this.heldItems.clear();
    }

    @Override
    public void disconnect(ServerLevel level) {
        this.dropHeldItems(level, this.m_58899_());
        super.disconnect(level);
    }

    @Override
    public void m_7651_() {
        Level level = this.m_58904_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            super.disconnect(serverLevel);
        }
        this.f_58859_ = true;
    }

    @Override
    public void insertPipeItem(Level level, ItemInPipe item) {
        ItemStack stack = item.getStack();
        if (!stack.m_41619_() && this.waitingForCraft > 0 && item.getFromDirection().equals((Object)this.slotDirections[9]) && ItemStack.m_150942_((ItemStack)this.getResult(), (ItemStack)stack)) {
            this.waitingForCraft -= stack.m_41613_();
            if (this.waitingForCraft <= 0) {
                this.waitingForCraft = 0;
                this.attemptCraft();
            }
        }
        super.insertPipeItem(level, item);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"container.classicpipes.recipe_pipe");
    }

    public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player player) {
        return new RecipePipeMenu(id, playerInventory, this.filter, this.slotDirections, this.getDirectionsForButtons(this.m_58900_()), this.m_58899_());
    }

    public List<Direction> getDirectionsForButtons(BlockState state) {
        ArrayList<Direction> availableDirections = new ArrayList<Direction>();
        for (Direction direction : Direction.values()) {
            if (!((NetworkedPipeBlock.ConnectionState)((Object)state.m_61143_((Property)NetworkedPipeBlock.PROPERTY_BY_DIRECTION.get(direction)))).equals((Object)NetworkedPipeBlock.ConnectionState.UNLINKED)) continue;
            availableDirections.add(direction);
        }
        return availableDirections;
    }

    @Override
    public void m_142466_(CompoundTag valueInput) {
        this.filter.m_6211_();
        this.heldItems.clear();
        super.m_142466_(valueInput);
        byte[] directionsByteList = valueInput.m_128463_("slot_directions");
        int i = 0;
        for (byte directionByte : directionsByteList) {
            if (i >= 10) break;
            this.slotDirections[i] = Direction.m_122376_((int)directionByte);
            ++i;
        }
        ListTag filterList = valueInput.m_128437_("filter", 10);
        filterList.forEach(tag -> {
            if (tag instanceof CompoundTag) {
                CompoundTag compoundTag = (CompoundTag)tag;
                int slot = compoundTag.m_128451_("slot");
                MiscUtil.loadFromTag(tag, ItemStack.f_41582_, stack -> this.filter.m_6836_(slot, (ItemStack)stack));
            }
        });
        ListTag heldItemList = valueInput.m_128437_("held_items", 10);
        heldItemList.forEach(tag -> {
            CompoundTag compoundTag;
            int slot;
            if (tag instanceof CompoundTag && (slot = (compoundTag = (CompoundTag)tag).m_128451_("slot")) >= 0 && slot < 9) {
                MiscUtil.loadFromTag(tag, ItemStack.f_41582_, stack -> this.heldItems.set(slot, stack));
            }
        });
        this.waitingForCraft = valueInput.m_128451_("waiting_for_craft");
        this.cooldown = valueInput.m_128445_("cooldown");
    }

    @Override
    protected void m_183515_(CompoundTag valueOutput) {
        super.m_183515_(valueOutput);
        byte[] directionsByteArray = new byte[10];
        for (int i = 0; i < this.slotDirections.length; ++i) {
            directionsByteArray[i] = this.slotDirections[i] == null ? (byte)0 : (byte)this.slotDirections[i].m_122411_();
        }
        valueOutput.m_128382_("slot_directions", directionsByteArray);
        ListTag filterList = new ListTag();
        for (int slot = 0; slot < this.filter.m_6643_(); ++slot) {
            ItemStack stack = this.filter.m_8020_(slot);
            if (stack.m_41619_()) continue;
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("slot", slot);
            MiscUtil.saveToTag((Tag)tag, stack, ItemStack.f_41582_, arg_0 -> filterList.add(arg_0));
        }
        valueOutput.m_128365_("filter", (Tag)filterList);
        ListTag heldItemList = new ListTag();
        for (int slot = 0; slot < this.heldItems.size(); ++slot) {
            ItemStack stack = (ItemStack)this.heldItems.get(slot);
            if (stack.m_41619_()) continue;
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("slot", slot);
            MiscUtil.saveToTag((Tag)tag, stack, ItemStack.f_41582_, arg_0 -> heldItemList.add(arg_0));
        }
        valueOutput.m_128365_("held_items", (Tag)heldItemList);
        valueOutput.m_128405_("waiting_for_craft", this.waitingForCraft);
        valueOutput.m_128344_("cooldown", this.cooldown);
    }
}

