/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.client.screen;

import jagm.classicpipes.client.screen.FilterScreen;
import jagm.classicpipes.inventory.menu.RecipePipeMenu;
import jagm.classicpipes.network.ServerBoundSlotDirectionPayload;
import jagm.classicpipes.services.Services;
import jagm.classicpipes.util.MiscUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;

public class RecipePipeScreen
extends FilterScreen<RecipePipeMenu> {
    private static final ResourceLocation BACKGROUND = MiscUtil.resourceLocation("textures/gui/container/recipe_pipe.png");
    private static final ChatFormatting[] DIRECTION_COLOURS = new ChatFormatting[]{ChatFormatting.LIGHT_PURPLE, ChatFormatting.GREEN, ChatFormatting.YELLOW, ChatFormatting.BLUE, ChatFormatting.GRAY, ChatFormatting.RED};
    private final Button[] slotDirectionButtons = new Button[10];
    private boolean buttonsNeedUpdate;

    public RecipePipeScreen(RecipePipeMenu menu, Inventory playerInventory, Component title) {
        super(menu, playerInventory, title);
        this.f_97727_ = 171;
        this.f_97731_ = this.f_97727_ - 94;
        this.buttonsNeedUpdate = true;
    }

    protected void m_7856_() {
        super.m_7856_();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                int slot = j + i * 3;
                Direction slotDirection = ((RecipePipeMenu)this.f_97732_).getSlotDirection(slot);
                this.slotDirectionButtons[slot] = Button.m_253074_((Component)Component.m_237115_((String)("direction.classicpipes.short." + slotDirection.name().toLowerCase())).m_130940_(DIRECTION_COLOURS[slotDirection.m_122411_()]), button -> this.cycleSlotDirection(slot)).m_252987_(this.f_97735_ + 9 + j * 12, this.f_97736_ + 25 + i * 12, 12, 12).m_253136_();
            }
        }
        Direction slotDirection = ((RecipePipeMenu)this.f_97732_).getSlotDirection(9);
        this.slotDirectionButtons[9] = Button.m_253074_((Component)Component.m_237115_((String)("direction.classicpipes.short." + slotDirection.name().toLowerCase())).m_130940_(DIRECTION_COLOURS[slotDirection.m_122411_()]), button -> this.cycleSlotDirection(9)).m_252987_(this.f_97735_ + 149, this.f_97736_ + 37, 12, 12).m_253136_();
        for (Button button2 : this.slotDirectionButtons) {
            this.m_142416_((GuiEventListener)button2);
        }
        this.buttonsNeedUpdate = true;
    }

    private void cycleSlotDirection(int slot) {
        Direction newDirection = RecipePipeScreen.m_96638_() ? ((RecipePipeMenu)this.f_97732_).prevDirection(((RecipePipeMenu)this.f_97732_).getSlotDirection(slot)) : ((RecipePipeMenu)this.f_97732_).nextDirection(((RecipePipeMenu)this.f_97732_).getSlotDirection(slot));
        ((RecipePipeMenu)this.f_97732_).setSlotDirection(slot, newDirection);
        this.buttonsNeedUpdate = true;
        Services.LOADER_SERVICE.sendToServer(new ServerBoundSlotDirectionPayload(((RecipePipeMenu)this.f_97732_).getPos(), slot, newDirection));
    }

    private Tooltip createDirectionTooltip(Direction direction, boolean result) {
        return Tooltip.m_257550_((Component)Component.m_237110_((String)("tooltip.classicpipes" + (result ? ".recipe_pipe_result" : ".recipe_pipe_grid")), (Object[])new Object[]{Component.m_237115_((String)("direction.classicpipes." + direction.name().toLowerCase())).m_130940_(DIRECTION_COLOURS[direction.m_122411_()])}));
    }

    private void updateButtons() {
        for (int slot = 0; slot < 10; ++slot) {
            boolean active = ((RecipePipeMenu)this.f_97732_).slotHasItem(slot) && ((RecipePipeMenu)this.f_97732_).hasAvailableDirections();
            Direction direction = ((RecipePipeMenu)this.f_97732_).getSlotDirection(slot);
            this.slotDirectionButtons[slot].f_93623_ = active;
            this.slotDirectionButtons[slot].m_93666_((Component)(active ? Component.m_237115_((String)("direction.classicpipes.short." + direction.name().toLowerCase())).m_130940_(DIRECTION_COLOURS[direction.m_122411_()]) : Component.m_237119_()));
            this.slotDirectionButtons[slot].m_257544_(active ? this.createDirectionTooltip(direction, slot == 9) : null);
        }
        this.m_7522_(null);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.buttonsNeedUpdate) {
            this.updateButtons();
            this.buttonsNeedUpdate = false;
        }
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        this.m_280072_(graphics, mouseX, mouseY);
    }

    protected void m_181908_() {
        this.buttonsNeedUpdate = true;
        super.m_181908_();
    }

    protected void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.m_280614_(this.f_96547_, this.f_96539_, (this.f_97726_ - this.f_96547_.m_92852_((FormattedText)this.f_96539_)) / 2 - 9, this.f_97729_, -12566464, false);
        graphics.m_280614_(this.f_96547_, this.f_169604_, this.f_97730_, this.f_97731_, -12566464, false);
    }

    protected void m_7286_(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        graphics.m_280163_(BACKGROUND, i, j, 0.0f, 0.0f, this.f_97726_, this.f_97727_, 256, 256);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        this.buttonsNeedUpdate = true;
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.buttonsNeedUpdate = true;
        return super.m_6348_(mouseX, mouseY, button);
    }
}

