/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.inventory.container;

import jagm.classicpipes.blockentity.PipeEntity;
import jagm.classicpipes.inventory.container.Filter;
import jagm.classicpipes.item.LabelItem;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public class DirectionalFilterContainer
implements Filter {
    private final Map<Direction, NonNullList<ItemStack>> filterMap;
    private final PipeEntity pipe;
    private boolean matchComponents;

    public DirectionalFilterContainer(PipeEntity pipe, boolean matchComponents) {
        this.pipe = pipe;
        this.filterMap = new HashMap<Direction, NonNullList<ItemStack>>();
        this.matchComponents = matchComponents;
        this.m_6211_();
    }

    public boolean directionMatches(ItemStack stack, Direction direction) {
        for (ItemStack filterStack : this.filterMap.get(direction)) {
            LabelItem labelItem;
            Item item = filterStack.m_41720_();
            if (item instanceof LabelItem && (labelItem = (LabelItem)item).itemMatches(filterStack, stack)) {
                return true;
            }
            if (!filterStack.m_150930_(stack.m_41720_()) || this.shouldMatchComponents() && !ItemStack.m_150942_((ItemStack)stack, (ItemStack)filterStack)) continue;
            return true;
        }
        return false;
    }

    public boolean directionEmpty(Direction direction) {
        return this.filterMap.get(direction).stream().allMatch(ItemStack::m_41619_);
    }

    public int m_6893_() {
        return 1;
    }

    public int m_6643_() {
        return 54;
    }

    public boolean m_7983_() {
        for (Direction direction : Direction.values()) {
            if (this.directionEmpty(direction)) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int slot) {
        int row = slot / 9;
        int col = slot % 9;
        return (ItemStack)this.filterMap.get(Direction.m_122376_((int)row)).get(col);
    }

    public ItemStack m_7407_(int slot, int amount) {
        int row = slot / 9;
        int col = slot % 9;
        this.filterMap.get(Direction.m_122376_((int)row)).set(col, (Object)ItemStack.f_41583_);
        return ItemStack.f_41583_;
    }

    public ItemStack m_8016_(int slot) {
        return this.m_7407_(slot, 1);
    }

    public void m_6836_(int slot, ItemStack stack) {
        int row = slot / 9;
        int col = slot % 9;
        this.filterMap.get(Direction.m_122376_((int)row)).set(col, (Object)stack);
    }

    public void m_6596_() {
        if (this.pipe != null && this.pipe.m_58904_() != null) {
            this.pipe.m_58904_().m_7260_(this.pipe.m_58899_(), this.pipe.m_58900_(), this.pipe.m_58900_(), 2);
            this.pipe.m_6596_();
        }
    }

    public boolean m_6542_(Player player) {
        if (this.pipe != null) {
            return Container.m_272074_((BlockEntity)this.pipe, (Player)player);
        }
        return true;
    }

    public void m_6211_() {
        for (Direction direction : Direction.values()) {
            this.filterMap.put(direction, (NonNullList<ItemStack>)NonNullList.m_122780_((int)9, (Object)ItemStack.f_41583_));
        }
    }

    @Override
    public void setMatchComponents(boolean matchComponents) {
        this.matchComponents = matchComponents;
        this.m_6596_();
    }

    @Override
    public boolean shouldMatchComponents() {
        return this.matchComponents;
    }

    @Override
    public PipeEntity getPipe() {
        return this.pipe;
    }
}

