/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.inventory.container;

import jagm.classicpipes.blockentity.PipeEntity;
import jagm.classicpipes.blockentity.ProviderPipeEntity;
import jagm.classicpipes.blockentity.StockingPipeEntity;
import jagm.classicpipes.inventory.container.Filter;
import jagm.classicpipes.item.LabelItem;
import java.util.Collection;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public class FilterContainer
implements Filter {
    private final NonNullList<ItemStack> filter;
    private final PipeEntity pipe;
    private final int size;
    private boolean matchComponents;

    public FilterContainer(PipeEntity pipe, int size, boolean matchComponents) {
        this.pipe = pipe;
        this.filter = NonNullList.m_122779_();
        this.size = size;
        this.matchComponents = matchComponents;
        this.m_6211_();
    }

    public int m_6893_() {
        return 999;
    }

    public int m_6643_() {
        return this.size;
    }

    public boolean m_7983_() {
        return this.filter.stream().allMatch(ItemStack::m_41619_);
    }

    public ItemStack m_8020_(int slot) {
        return (ItemStack)this.filter.get(slot);
    }

    public ItemStack m_7407_(int slot, int amount) {
        this.filter.set(slot, (Object)ItemStack.f_41583_);
        return ItemStack.f_41583_;
    }

    public ItemStack m_8016_(int slot) {
        return this.m_7407_(slot, 1);
    }

    public void m_6836_(int slot, ItemStack stack) {
        this.filter.set(slot, (Object)stack);
    }

    public void m_6596_() {
        if (this.pipe != null) {
            this.pipe.m_6596_();
            PipeEntity pipeEntity = this.pipe;
            if (pipeEntity instanceof ProviderPipeEntity) {
                ProviderPipeEntity providerPipe = (ProviderPipeEntity)pipeEntity;
                providerPipe.updateCache();
            } else {
                pipeEntity = this.pipe;
                if (pipeEntity instanceof StockingPipeEntity) {
                    StockingPipeEntity stockingPipe = (StockingPipeEntity)pipeEntity;
                    stockingPipe.updateCache();
                }
            }
        }
    }

    public boolean m_6542_(Player player) {
        if (this.pipe != null) {
            return Container.m_272074_((BlockEntity)this.pipe, (Player)player);
        }
        return true;
    }

    public void m_6211_() {
        this.filter.clear();
        this.filter.addAll((Collection)NonNullList.m_122780_((int)this.size, (Object)ItemStack.f_41583_));
    }

    @Override
    public void setMatchComponents(boolean matchComponents) {
        this.matchComponents = matchComponents;
        this.m_6596_();
    }

    @Override
    public boolean shouldMatchComponents() {
        return this.matchComponents;
    }

    @Override
    public PipeEntity getPipe() {
        return this.pipe;
    }

    public boolean matches(ItemStack stack) {
        for (ItemStack filterStack : this.filter) {
            LabelItem labelItem;
            Item item = filterStack.m_41720_();
            if (item instanceof LabelItem && (labelItem = (LabelItem)item).itemMatches(filterStack, stack)) {
                return true;
            }
            if (!filterStack.m_150930_(stack.m_41720_()) || this.shouldMatchComponents() && !ItemStack.m_150942_((ItemStack)stack, (ItemStack)filterStack)) continue;
            return true;
        }
        return false;
    }
}

