/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ItemInPipe {
    public static final short PIPE_LENGTH = 2048;
    public static final short HALFWAY = 1024;
    public static final short DEFAULT_SPEED = 64;
    public static final short DEFAULT_ACCELERATION = 1;
    public static final short SPEED_LIMIT = 1024;
    public static final short DESPAWN_AGE = 24000;
    public static final Codec<ItemInPipe> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemStack.f_41582_.fieldOf("item").orElse((Object)ItemStack.f_41583_).forGetter(ItemInPipe::getStack), (App)Codec.SHORT.fieldOf("speed").orElse((Object)64).forGetter(ItemInPipe::getSpeed), (App)Codec.SHORT.fieldOf("progress").orElse((Object)0).forGetter(ItemInPipe::getProgress), (App)Codec.BYTE.fieldOf("from_direction").orElse((Object)0).forGetter(item -> (byte)item.getFromDirection().m_122411_()), (App)Codec.BYTE.fieldOf("target_direction").orElse((Object)0).forGetter(item -> (byte)item.getTargetDirection().m_122411_()), (App)Codec.BOOL.fieldOf("ejecting").orElse((Object)true).forGetter(ItemInPipe::isEjecting), (App)Codec.SHORT.fieldOf("age").orElse((Object)0).forGetter(ItemInPipe::getAge)).apply((Applicative)instance, ItemInPipe::new));
    private ItemStack stack;
    private short speed;
    private short progress;
    private Direction fromDirection;
    private Direction targetDirection;
    private boolean ejecting;
    private short age;

    public ItemInPipe(ItemStack stack, short speed, short progress, Direction fromDirection, Direction targetDirection, boolean ejecting, short age) {
        this.stack = stack;
        this.speed = (short)Math.min(speed, 1024);
        this.progress = progress;
        this.fromDirection = fromDirection;
        this.targetDirection = targetDirection;
        this.ejecting = ejecting;
        this.age = age;
    }

    public ItemInPipe(ItemStack stack, Direction fromDirection, Direction toDirection) {
        this(stack, fromDirection, toDirection, true);
    }

    public ItemInPipe(ItemStack stack, Direction fromDirection, Direction toDirection, boolean ejecting) {
        this(stack, 64, 0, fromDirection, toDirection, ejecting, 0);
    }

    public ItemInPipe(ItemStack stack, short speed, short progress, byte fromDirection, byte targetDirection, boolean ejecting, short age) {
        this(stack, speed, progress, Direction.m_122376_((int)fromDirection), Direction.m_122376_((int)targetDirection), ejecting, age);
    }

    public ItemInPipe copyWithCount(int count) {
        return new ItemInPipe(this.getStack().m_255036_(count), this.speed, this.progress, this.fromDirection, this.targetDirection, this.ejecting, this.age);
    }

    public void move(short targetSpeed, short acceleration) {
        if (this.speed < targetSpeed) {
            this.speed = (short)Math.min(this.speed + acceleration, Math.min(targetSpeed, 1024));
        } else if (this.speed > targetSpeed) {
            this.speed = (short)Math.max(this.speed - acceleration, Math.max(targetSpeed, 1));
        }
        this.progress = (short)(this.progress + this.speed);
        this.age = (short)(this.age + 1);
    }

    public void drop(ServerLevel level, BlockPos pos) {
        if (!this.stack.m_41619_()) {
            Vec3 offset = this.getRenderPosition(0.0f);
            ItemEntity droppedItem = new ItemEntity((Level)level, (double)pos.m_123341_() + offset.f_82479_, (double)pos.m_123342_() + offset.f_82480_, (double)pos.m_123343_() + offset.f_82481_, this.stack);
            droppedItem.m_32060_();
            level.m_7967_((Entity)droppedItem);
        }
    }

    public Vec3 getRenderPosition(float partialTicks) {
        Direction d;
        float p = (float)this.progress / 2048.0f + partialTicks * (float)this.speed / 2048.0f;
        float q = 1.0f - p;
        boolean h = p < 0.5f;
        Direction direction = d = h ? this.fromDirection : this.targetDirection;
        return new Vec3(d == Direction.WEST ? (double)(h ? p : q) : (double)(d == Direction.EAST ? (h ? q : p) : 0.5f), d == Direction.DOWN ? (double)(h ? p : q) : (double)(d == Direction.UP ? (h ? q : p) : 0.5f), d == Direction.NORTH ? (double)(h ? p : q) : (double)(d == Direction.SOUTH ? (h ? q : p) : 0.5f));
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public void setStack(ItemStack stack) {
        this.stack = stack;
    }

    public short getProgress() {
        return this.progress;
    }

    public void resetProgress(Direction direction) {
        this.progress = (short)(this.progress - 2048);
        this.fromDirection = direction;
        this.targetDirection = direction;
    }

    public boolean isEjecting() {
        return this.ejecting;
    }

    public void setEjecting(boolean ejecting) {
        this.ejecting = ejecting;
    }

    public Direction getFromDirection() {
        return this.fromDirection;
    }

    public Direction getTargetDirection() {
        return this.targetDirection;
    }

    public void setTargetDirection(Direction direction) {
        this.targetDirection = direction;
    }

    public short getSpeed() {
        return this.speed;
    }

    public short getAge() {
        return this.age;
    }
}

