/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.util;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import jagm.classicpipes.block.PipeBlock;
import jagm.classicpipes.services.Services;
import jagm.classicpipes.util.Tuple;
import java.util.Comparator;
import java.util.function.Consumer;
import net.minecraft.core.Direction;
import net.minecraft.core.IdMap;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class MiscUtil {
    public static final boolean DEBUG_MODE = false;
    public static final Comparator<Tuple<ItemStack, Boolean>> AMOUNT = Comparator.comparing(tuple -> ((ItemStack)tuple.a()).m_41613_() - ((Boolean)tuple.b() != false ? 1 : 0));
    public static final Comparator<Tuple<ItemStack, Boolean>> NAME = Comparator.comparing(tuple -> ((ItemStack)tuple.a()).m_41611_().getString());
    public static final Comparator<Tuple<ItemStack, Boolean>> MOD = Comparator.comparing(tuple -> Services.LOADER_SERVICE.getModName(MiscUtil.modFromItem((ItemStack)tuple.a())));
    public static final Comparator<Tuple<ItemStack, Boolean>> CRAFTABLE = Comparator.comparing(Tuple::b);

    public static void writeStackToBuffer(FriendlyByteBuf buffer, ItemStack stack) {
        if (stack.m_41619_()) {
            buffer.writeBoolean(false);
        } else {
            buffer.writeBoolean(true);
            Item item = stack.m_41720_();
            buffer.m_236818_((IdMap)BuiltInRegistries.f_257033_, (Object)item);
            buffer.writeInt(stack.m_41613_());
            CompoundTag compoundtag = null;
            if (item.m_41465_() || item.m_41468_()) {
                compoundtag = stack.m_41783_();
            }
            buffer.m_130079_(compoundtag);
        }
    }

    public static ItemStack readStackFromBuffer(FriendlyByteBuf buffer) {
        Item item;
        if (buffer.readBoolean() && (item = (Item)buffer.m_236816_((IdMap)BuiltInRegistries.f_257033_)) != null) {
            int count = buffer.readInt();
            ItemStack stack = new ItemStack((ItemLike)item, count);
            stack.m_41751_(buffer.m_130260_());
            return stack;
        }
        return ItemStack.f_41583_;
    }

    public static ResourceLocation resourceLocation(String name) {
        return new ResourceLocation("classicpipes", name);
    }

    public static <T> ResourceKey<T> makeKey(ResourceKey<? extends Registry<T>> registry, String name) {
        return ResourceKey.m_135785_(registry, (ResourceLocation)MiscUtil.resourceLocation(name));
    }

    public static Direction nextDirection(Direction direction) {
        return Direction.m_122376_((int)((direction.m_122411_() + 1) % 6));
    }

    public static Direction prevDirection(Direction direction) {
        return Direction.m_122376_((int)((direction.m_122411_() + 5) % 6));
    }

    public static boolean itemIsPipe(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            return blockItem.m_40614_() instanceof PipeBlock;
        }
        return false;
    }

    public static String modFromItem(ItemStack stack) {
        return BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_()).toString().split(":")[0];
    }

    public static <T> void loadFromTag(Tag tag, Codec<T> codec, Consumer<? super T> resultConsumer) {
        codec.parse((DynamicOps)NbtOps.f_128958_, (Object)tag).result().ifPresent(resultConsumer);
    }

    public static <T> void saveToTag(Tag tag, T thing, Codec<T> codec, Consumer<? super Tag> resultConsumer) {
        codec.encode(thing, (DynamicOps)NbtOps.f_128958_, (Object)tag).result().ifPresent(resultConsumer);
    }

    public static <T> void saveToTag(T thing, Codec<T> codec, Consumer<? super Tag> resultConsumer) {
        codec.encodeStart((DynamicOps)NbtOps.f_128958_, thing).result().ifPresent(resultConsumer);
    }
}

