/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.util;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;

public class MissingItem {
    private final ItemStack stack;
    private final List<MissingItem> missingIngredients;

    public MissingItem(ItemStack stack) {
        this.stack = stack;
        this.missingIngredients = new ArrayList<MissingItem>();
    }

    public boolean isEmpty() {
        return this.stack.m_41619_();
    }

    public int getCount() {
        return this.stack.m_41613_();
    }

    public void shrink(int decrement) {
        this.stack.m_41774_(decrement);
    }

    public void grow(int increment) {
        this.stack.m_41769_(increment);
    }

    public boolean hasMissingIngredients() {
        return !this.missingIngredients.isEmpty();
    }

    public void addMissingIngredient(MissingItem ingredient) {
        for (MissingItem alreadyThere : this.missingIngredients) {
            if (!ItemStack.m_150942_((ItemStack)ingredient.stack, (ItemStack)alreadyThere.stack)) continue;
            alreadyThere.grow(ingredient.getCount());
            for (MissingItem ingredientIngredient : ingredient.missingIngredients) {
                alreadyThere.addMissingIngredient(ingredientIngredient);
            }
            return;
        }
        this.missingIngredients.add(ingredient);
    }

    public List<ItemStack> getBaseItems(List<ItemStack> baseItems) {
        if (this.hasMissingIngredients()) {
            for (MissingItem ingredient : this.missingIngredients) {
                baseItems = ingredient.getBaseItems(baseItems);
            }
        } else {
            boolean matched = false;
            for (ItemStack alreadyThere : baseItems) {
                if (!ItemStack.m_150942_((ItemStack)this.stack, (ItemStack)alreadyThere)) continue;
                alreadyThere.m_41769_(this.stack.m_41613_());
                matched = true;
                break;
            }
            if (!matched) {
                baseItems.add(this.stack.m_41777_());
            }
        }
        return baseItems;
    }
}

