/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.blockentity;

import jagm.classicpipes.block.FluidPipeBlock;
import jagm.classicpipes.blockentity.FluidPipeEntity;
import jagm.classicpipes.util.FluidInPipe;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class NeoForgeFluidPipeWrapper
implements IFluidHandler {
    private final FluidPipeEntity pipe;
    private final Direction side;

    public NeoForgeFluidPipeWrapper(FluidPipeEntity pipe, Direction side) {
        this.pipe = pipe;
        this.side = side;
    }

    public int getTanks() {
        return 1;
    }

    public FluidStack getFluidInTank(int i) {
        return new FluidStack(this.pipe.getFluid(), this.pipe.totalAmount());
    }

    public int getTankCapacity(int i) {
        return 1000;
    }

    public boolean isFluidValid(int i, FluidStack fluidStack) {
        return true;
    }

    public int fill(FluidStack fluidStack, IFluidHandler.FluidAction fluidAction) {
        if (fluidStack.isEmpty() || !this.pipe.emptyOrMatches(fluidStack.getFluid()) || !((Boolean)this.pipe.getBlockState().getValue((Property)FluidPipeBlock.PROPERTY_BY_DIRECTION.get(this.side))).booleanValue()) {
            return 0;
        }
        int amount = Math.min(this.pipe.remainingCapacity(), fluidStack.getAmount());
        if (fluidAction.execute()) {
            Level level = this.pipe.getLevel();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                this.pipe.setFluid(fluidStack.getFluid());
                FluidInPipe fluidPacket = new FluidInPipe(amount, this.pipe.getTargetSpeed(), 0, this.side, this.side, 0);
                this.pipe.insertFluidPacket((Level)serverLevel, fluidPacket);
                serverLevel.sendBlockUpdated(this.pipe.getBlockPos(), this.pipe.getBlockState(), this.pipe.getBlockState(), 2);
            }
            this.pipe.setChanged();
        }
        return amount;
    }

    public FluidStack drain(FluidStack fluidStack, IFluidHandler.FluidAction fluidAction) {
        return FluidStack.EMPTY;
    }

    public FluidStack drain(int i, IFluidHandler.FluidAction fluidAction) {
        return FluidStack.EMPTY;
    }
}

