/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.block;

import jagm.classicpipes.ClassicPipes;
import jagm.classicpipes.block.FluidPipeBlock;
import jagm.classicpipes.blockentity.DiamondFluidPipeEntity;
import jagm.classicpipes.blockentity.PipeEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class DiamondFluidPipeBlock
extends FluidPipeBlock {
    public DiamondFluidPipeBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new DiamondFluidPipeEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return blockEntityType == ClassicPipes.DIAMOND_FLUID_PIPE_ENTITY ? PipeEntity::tick : null;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockEntity blockEntity;
        if (level instanceof ServerLevel && (blockEntity = level.getBlockEntity(pos)) instanceof DiamondFluidPipeEntity) {
            DiamondFluidPipeEntity diamondFluidPipe = (DiamondFluidPipeEntity)blockEntity;
            player.openMenu((MenuProvider)diamondFluidPipe);
        }
        return InteractionResult.SUCCESS;
    }
}

