/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.blockentity;

import jagm.classicpipes.ClassicPipes;
import jagm.classicpipes.blockentity.ItemPipeEntity;
import jagm.classicpipes.util.ItemInPipe;
import jagm.classicpipes.util.MiscUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;

public class BonePipeEntity
extends ItemPipeEntity {
    public BonePipeEntity(BlockPos pos, BlockState state) {
        super(ClassicPipes.BONE_PIPE_ENTITY, pos, state);
    }

    protected List<Direction> getValidDirections(BlockState state, ItemInPipe item) {
        ArrayList<Direction> validDirections = new ArrayList<Direction>();
        Direction direction = MiscUtil.nextDirection(item.getFromDirection());
        for (int i = 0; i < 5; ++i) {
            if (this.isPipeConnected(state, direction)) {
                validDirections.add(direction);
            }
            direction = MiscUtil.nextDirection(direction);
        }
        return validDirections;
    }

    @Override
    public void routeItem(BlockState state, ItemInPipe item) {
        List<Direction> validDirections = this.getValidDirections(state, item);
        if (!validDirections.isEmpty() && this.getLevel() != null) {
            int count = item.getStack().getCount();
            if (count == 1) {
                item.setTargetDirection(validDirections.get(this.getLevel().getRandom().nextInt(validDirections.size())));
                item.setEjecting(false);
            } else {
                HashMap<Direction, Integer> routeMap = new HashMap<Direction, Integer>();
                validDirections.forEach(direction -> routeMap.put((Direction)direction, 0));
                for (int i = 0; i < count; ++i) {
                    Direction direction2 = validDirections.get(this.getLevel().getRandom().nextInt(validDirections.size()));
                    routeMap.put(direction2, (Integer)routeMap.get(direction2) + 1);
                }
                boolean inputRouted = false;
                for (Direction direction3 : validDirections) {
                    int routeCount = (Integer)routeMap.get(direction3);
                    if (routeCount <= 0) continue;
                    if (!inputRouted) {
                        inputRouted = true;
                        item.setStack(item.getStack().copyWithCount(routeCount));
                        item.setTargetDirection(direction3);
                        item.setEjecting(false);
                        continue;
                    }
                    this.queued.add(new ItemInPipe(item.getStack().copyWithCount(routeCount), item.getSpeed(), item.getProgress(), item.getFromDirection(), direction3, false, item.getAge()));
                }
            }
        } else {
            item.setTargetDirection(item.getFromDirection().getOpposite());
            item.setEjecting(true);
        }
    }

    @Override
    public short getTargetSpeed() {
        return 64;
    }

    @Override
    public short getAcceleration() {
        return 1;
    }
}

