/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.blockentity;

import jagm.classicpipes.ClassicPipes;
import jagm.classicpipes.blockentity.FluidPipeEntity;
import jagm.classicpipes.inventory.container.DirectionalFilterContainer;
import jagm.classicpipes.inventory.menu.DiamondFluidPipeMenu;
import jagm.classicpipes.util.FluidInPipe;
import jagm.classicpipes.util.MiscUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;

public class DiamondFluidPipeEntity
extends FluidPipeEntity
implements MenuProvider {
    private final DirectionalFilterContainer filter = new DirectionalFilterContainer(this, false);

    public DiamondFluidPipeEntity(BlockPos pos, BlockState state) {
        super(ClassicPipes.DIAMOND_FLUID_PIPE_ENTITY, pos, state);
    }

    @Override
    protected List<Direction> getValidDirections(BlockState state, FluidInPipe fluidPacket) {
        int i;
        ArrayList<Direction> validDirections = new ArrayList<Direction>();
        Direction direction = MiscUtil.nextDirection(fluidPacket.getFromDirection());
        ItemStack bucket = new ItemStack((ItemLike)this.getFluid().getBucket());
        for (i = 0; i < 5; ++i) {
            if (this.isPipeConnected(state, direction) && this.filter.directionMatches(bucket, direction)) {
                validDirections.add(direction);
            }
            direction = MiscUtil.nextDirection(direction);
        }
        if (validDirections.isEmpty() && this.filter.directionMatches(bucket, direction)) {
            validDirections.add(fluidPacket.getFromDirection());
        }
        if (validDirections.isEmpty()) {
            direction = MiscUtil.nextDirection(fluidPacket.getFromDirection());
            for (i = 0; i < 5; ++i) {
                if (this.isPipeConnected(state, direction) && this.filter.directionEmpty(direction)) {
                    validDirections.add(direction);
                }
                direction = MiscUtil.nextDirection(direction);
            }
        }
        if (validDirections.isEmpty() && this.filter.directionEmpty(fluidPacket.getFromDirection())) {
            validDirections.add(fluidPacket.getFromDirection());
        }
        return validDirections;
    }

    @Override
    protected void loadAdditional(CompoundTag valueInput, HolderLookup.Provider registries) {
        this.filter.clearContent();
        super.loadAdditional(valueInput, registries);
        ListTag filterList = valueInput.getList("filter", 10);
        filterList.forEach(tag -> {
            if (tag instanceof CompoundTag) {
                CompoundTag compoundTag = (CompoundTag)tag;
                int slot = compoundTag.getInt("slot");
                MiscUtil.loadFromTag(tag, ItemStack.CODEC, registries, stack -> this.filter.setItem(slot, (ItemStack)stack));
            }
        });
    }

    @Override
    protected void saveAdditional(CompoundTag valueOutput, HolderLookup.Provider registries) {
        super.saveAdditional(valueOutput, registries);
        ListTag filterList = new ListTag();
        for (int slot = 0; slot < this.filter.getContainerSize(); ++slot) {
            ItemStack stack = this.filter.getItem(slot);
            if (stack.isEmpty()) continue;
            CompoundTag tag = new CompoundTag();
            tag.putInt("slot", slot);
            MiscUtil.saveToTag((Tag)tag, stack, ItemStack.CODEC, registries, arg_0 -> filterList.add(arg_0));
        }
        valueOutput.put("filter", (Tag)filterList);
    }

    public Component getDisplayName() {
        return Component.translatable((String)"container.classicpipes.diamond_fluid_pipe");
    }

    public AbstractContainerMenu createMenu(int id, Inventory playerInventory, Player player) {
        return new DiamondFluidPipeMenu(id, playerInventory, this.filter);
    }
}

