/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.blockentity;

import jagm.classicpipes.ClassicPipes;
import jagm.classicpipes.block.MatchingPipeBlock;
import jagm.classicpipes.block.ProviderPipeBlock;
import jagm.classicpipes.blockentity.MatchingPipe;
import jagm.classicpipes.blockentity.NetworkedPipeEntity;
import jagm.classicpipes.blockentity.ProviderPipe;
import jagm.classicpipes.inventory.menu.StoragePipeMenu;
import jagm.classicpipes.services.Services;
import jagm.classicpipes.util.FacingOrNone;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class StoragePipeEntity
extends NetworkedPipeEntity
implements MenuProvider,
ProviderPipe,
MatchingPipe {
    private boolean defaultRoute = false;
    private boolean matchComponents = false;
    private boolean leaveOne = false;
    private final List<ItemStack> cache = new ArrayList<ItemStack>();
    private boolean cacheInitialised = false;
    private final List<ItemStack> cannotFit = new ArrayList<ItemStack>();

    public StoragePipeEntity(BlockPos pos, BlockState state) {
        super(ClassicPipes.STORAGE_PIPE_ENTITY, pos, state);
    }

    @Override
    public void tickServer(ServerLevel level, BlockPos pos, BlockState state) {
        if (!this.cacheInitialised && !((FacingOrNone)((Object)state.getValue((Property)MatchingPipeBlock.FACING))).equals((Object)FacingOrNone.NONE)) {
            this.updateCache(level, pos, ((FacingOrNone)((Object)state.getValue((Property)MatchingPipeBlock.FACING))).getDirection());
            this.cacheInitialised = true;
        }
        super.tickServer(level, pos, state);
    }

    @Override
    public void updateCache(ServerLevel level, BlockPos pos, Direction facing) {
        this.cache.clear();
        this.cannotFit.clear();
        List<ItemStack> stacks = Services.LOADER_SERVICE.getContainerItems(level, pos.relative(facing), facing.getOpposite());
        Iterator<ItemStack> iterator = stacks.iterator();
        while (iterator.hasNext()) {
            ItemStack stack = iterator.next();
            if (!this.shouldLeaveOne()) continue;
            stack.shrink(1);
            if (!stack.isEmpty()) continue;
            iterator.remove();
        }
        this.cache.addAll(stacks);
        if (this.hasNetwork()) {
            this.getNetwork().cacheUpdated();
        }
    }

    @Override
    public Direction getFacing() {
        return ((FacingOrNone)((Object)this.getBlockState().getValue((Property)ProviderPipeBlock.FACING))).getDirection();
    }

    @Override
    public boolean matches(ItemStack stack) {
        for (ItemStack cannotFitStack : this.cannotFit) {
            if (!ItemStack.isSameItemSameComponents((ItemStack)cannotFitStack, (ItemStack)stack)) continue;
            return false;
        }
        for (ItemStack containerStack : this.cache) {
            if (!stack.is(containerStack.getItem()) || this.shouldMatchComponents() && !ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)containerStack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public NetworkedPipeEntity getAsPipe() {
        return this;
    }

    @Override
    public void markCannotFit(ItemStack stack) {
        this.cannotFit.add(stack);
    }

    @Override
    public boolean isDefaultRoute() {
        return this.defaultRoute;
    }

    public void setDefaultRoute(boolean defaultRoute) {
        this.defaultRoute = defaultRoute;
        if (defaultRoute) {
            this.getNetwork().addPipe(this);
        } else {
            this.getNetwork().getDefaultRoutes().remove(this);
        }
    }

    public boolean shouldMatchComponents() {
        return this.matchComponents;
    }

    public void setMatchComponents(boolean matchComponents) {
        this.matchComponents = matchComponents;
    }

    public void setLeaveOne(boolean leaveOne) {
        this.leaveOne = leaveOne;
        Direction facing = ((FacingOrNone)((Object)this.getBlockState().getValue((Property)ProviderPipeBlock.FACING))).getDirection();
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (facing != null) {
                this.updateCache(serverLevel, this.getBlockPos(), facing);
            }
        }
    }

    public boolean shouldLeaveOne() {
        return this.leaveOne;
    }

    @Override
    protected void loadAdditional(CompoundTag valueInput, HolderLookup.Provider registries) {
        this.cacheInitialised = false;
        super.loadAdditional(valueInput, registries);
        this.defaultRoute = valueInput.getBoolean("default_route");
        this.matchComponents = valueInput.getBoolean("match_components");
        this.leaveOne = valueInput.getBoolean("leave_one");
    }

    @Override
    protected void saveAdditional(CompoundTag valueOutput, HolderLookup.Provider registries) {
        super.saveAdditional(valueOutput, registries);
        valueOutput.putBoolean("default_route", this.isDefaultRoute());
        valueOutput.putBoolean("match_components", this.shouldMatchComponents());
        valueOutput.putBoolean("leave_one", this.shouldLeaveOne());
    }

    public Component getDisplayName() {
        return Component.translatable((String)"container.classicpipes.storage_pipe");
    }

    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
        return new StoragePipeMenu(id, inventory, this.isDefaultRoute(), this.shouldMatchComponents(), this.shouldLeaveOne(), this);
    }

    @Override
    public List<ItemStack> getCache() {
        return this.cache;
    }

    @Override
    public boolean extractItem(ServerLevel level, ItemStack stack) {
        Direction facing = ((FacingOrNone)((Object)this.getBlockState().getValue((Property)ProviderPipeBlock.FACING))).getDirection();
        if (facing != null) {
            boolean extracted = Services.LOADER_SERVICE.extractSpecificItem(this, level, this.getBlockPos().relative(facing), facing.getOpposite(), stack.copy());
            this.updateCache(level, this.getBlockPos(), facing);
            return extracted;
        }
        return false;
    }

    @Override
    public BlockPos getProviderPipePos() {
        return this.getBlockPos();
    }
}

