/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.compat;

import jagm.classicpipes.ClassicPipes;
import jagm.classicpipes.client.screen.FilterScreen;
import jagm.classicpipes.client.screen.FluidFilterScreen;
import jagm.classicpipes.inventory.container.Filter;
import jagm.classicpipes.inventory.menu.RecipePipeMenu;
import jagm.classicpipes.network.ServerBoundSetFilterPayload;
import jagm.classicpipes.network.ServerBoundTransferRecipePayload;
import jagm.classicpipes.services.Services;
import jagm.classicpipes.util.MiscUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IUniversalRecipeTransferHandler;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;

@JeiPlugin
public class ForgeJEIPlugin
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return MiscUtil.resourceLocation("jei_plugin");
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addUniversalRecipeTransferHandler((IUniversalRecipeTransferHandler)new IUniversalRecipeTransferHandler<RecipePipeMenu>(this){

            public Class<? extends RecipePipeMenu> getContainerClass() {
                return RecipePipeMenu.class;
            }

            public Optional<MenuType<RecipePipeMenu>> getMenuType() {
                return Optional.of(ClassicPipes.RECIPE_PIPE_MENU);
            }

            public IRecipeTransferError transferRecipe(RecipePipeMenu recipePipeMenu, Object recipe, IRecipeSlotsView recipeSlots, Player player, boolean maxTransfer, boolean doTransfer) {
                if (doTransfer) {
                    ItemStack stack;
                    List inputs = recipeSlots.getSlotViews(RecipeIngredientRole.INPUT);
                    ArrayList<ItemStack> recipeToSend = new ArrayList<ItemStack>();
                    ArrayList<Integer> slotsToSend = new ArrayList<Integer>();
                    for (int i = 0; i < 9; ++i) {
                        ItemStack itemStack = stack = inputs.size() > i ? ((IRecipeSlotView)inputs.get(i)).getDisplayedItemStack().orElse(ItemStack.EMPTY) : ItemStack.EMPTY;
                        if (!stack.isEmpty()) {
                            recipeToSend.add(stack);
                            slotsToSend.add(i);
                        }
                        recipePipeMenu.getSlot(i).set(stack);
                    }
                    List outputs = recipeSlots.getSlotViews(RecipeIngredientRole.OUTPUT);
                    stack = ((IRecipeSlotView)outputs.getFirst()).getDisplayedItemStack().orElse(ItemStack.EMPTY);
                    if (!stack.isEmpty()) {
                        recipeToSend.add(stack);
                        slotsToSend.add(9);
                    }
                    recipePipeMenu.getSlot(9).set(stack);
                    Services.LOADER_SERVICE.sendToServer(new ServerBoundTransferRecipePayload(recipeToSend, slotsToSend));
                }
                return null;
            }
        });
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addGhostIngredientHandler(FilterScreen.class, (IGhostIngredientHandler)new IGhostIngredientHandler<FilterScreen>(this){

            public <I> List<IGhostIngredientHandler.Target<I>> getTargetsTyped(final FilterScreen filterScreen, ITypedIngredient<I> ingredient, boolean doStart) {
                ArrayList<IGhostIngredientHandler.Target<I>> validSlots;
                block5: {
                    ItemStack stack;
                    block6: {
                        Fluid fluid;
                        validSlots = new ArrayList<IGhostIngredientHandler.Target<I>>();
                        if (!doStart) break block5;
                        stack = ingredient.getItemStack().orElse(ItemStack.EMPTY);
                        if (!(filterScreen instanceof FluidFilterScreen)) break block6;
                        Object object = ingredient.getIngredient();
                        if (object instanceof FluidStack) {
                            FluidStack fluidStack = (FluidStack)object;
                            fluid = fluidStack.getFluid();
                        } else {
                            fluid = Services.LOADER_SERVICE.getFluidFromStack(stack);
                        }
                        if (fluid == null || fluid.getBucket() == Items.AIR) break block5;
                        for (int i = 0; i < filterScreen.filterSlots(); ++i) {
                            final Slot slot = filterScreen.getMenu().getSlot(i);
                            if (!(slot.container instanceof Filter)) continue;
                            validSlots.add(new IGhostIngredientHandler.Target<I>(this){

                                public Rect2i getArea() {
                                    return new Rect2i(filterScreen.filterScreenLeft() + slot.x, filterScreen.filterScreenTop() + slot.y, 16, 16);
                                }

                                public void accept(I ingredient) {
                                    ItemStack bucketStack = new ItemStack((ItemLike)fluid.getBucket());
                                    slot.set(bucketStack);
                                    Services.LOADER_SERVICE.sendToServer(new ServerBoundSetFilterPayload(slot.index, bucketStack));
                                }
                            });
                        }
                        break block5;
                    }
                    if (!stack.isEmpty()) {
                        for (int i = 0; i < filterScreen.filterSlots(); ++i) {
                            final Slot slot = filterScreen.getMenu().getSlot(i);
                            if (!(slot.container instanceof Filter)) continue;
                            validSlots.add(new IGhostIngredientHandler.Target<I>(this){

                                public Rect2i getArea() {
                                    return new Rect2i(filterScreen.filterScreenLeft() + slot.x, filterScreen.filterScreenTop() + slot.y, 16, 16);
                                }

                                public void accept(I ingredient) {
                                    slot.set(stack);
                                    Services.LOADER_SERVICE.sendToServer(new ServerBoundSetFilterPayload(slot.index, stack));
                                }
                            });
                        }
                    }
                }
                return validSlots;
            }

            public void onComplete() {
            }
        });
    }
}

