/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.network;

import jagm.classicpipes.network.SelfHandler;
import jagm.classicpipes.util.MiscUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.ChannelBuilder;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.SimpleChannel;
import net.minecraftforge.network.simple.SimpleFlow;

public class ForgePacketHandler {
    private static final SimpleChannel INSTANCE = ChannelBuilder.named((ResourceLocation)MiscUtil.resourceLocation("main")).simpleChannel();

    public static <T extends SelfHandler> void registerServerPayload(Class<T> clazz, StreamCodec<RegistryFriendlyByteBuf, T> codec) {
        ((SimpleFlow)INSTANCE.play().serverbound()).add(clazz, codec, (payload, context) -> {
            context.enqueueWork(() -> payload.handle((Player)context.getSender()));
            context.setPacketHandled(true);
        });
    }

    public static <T extends SelfHandler> void registerClientPayload(Class<T> clazz, StreamCodec<RegistryFriendlyByteBuf, T> codec) {
        ((SimpleFlow)INSTANCE.play().clientbound()).add(clazz, codec, (payload, context) -> {
            context.enqueueWork(() -> payload.handle((Player)Minecraft.getInstance().player));
            context.setPacketHandled(true);
        });
    }

    public static void sendToServer(CustomPacketPayload payload) {
        INSTANCE.send((Object)payload, PacketDistributor.SERVER.noArg());
    }

    public static void sendToClient(ServerPlayer player, CustomPacketPayload payload) {
        INSTANCE.send((Object)payload, PacketDistributor.PLAYER.with((Object)player));
    }
}

