/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.util;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;

public class MissingItem {
    private final ItemStack stack;
    private final List<MissingItem> missingIngredients;

    public MissingItem(ItemStack stack) {
        this.stack = stack;
        this.missingIngredients = new ArrayList<MissingItem>();
    }

    public boolean isEmpty() {
        return this.stack.isEmpty();
    }

    public int getCount() {
        return this.stack.getCount();
    }

    public void shrink(int decrement) {
        this.stack.shrink(decrement);
    }

    public void grow(int increment) {
        this.stack.grow(increment);
    }

    public boolean hasMissingIngredients() {
        return !this.missingIngredients.isEmpty();
    }

    public void addMissingIngredient(MissingItem ingredient) {
        for (MissingItem alreadyThere : this.missingIngredients) {
            if (!ItemStack.isSameItemSameComponents((ItemStack)ingredient.stack, (ItemStack)alreadyThere.stack)) continue;
            alreadyThere.grow(ingredient.getCount());
            for (MissingItem ingredientIngredient : ingredient.missingIngredients) {
                alreadyThere.addMissingIngredient(ingredientIngredient);
            }
            return;
        }
        this.missingIngredients.add(ingredient);
    }

    public List<ItemStack> getBaseItems(List<ItemStack> baseItems) {
        if (this.hasMissingIngredients()) {
            for (MissingItem ingredient : this.missingIngredients) {
                baseItems = ingredient.getBaseItems(baseItems);
            }
        } else {
            boolean matched = false;
            for (ItemStack alreadyThere : baseItems) {
                if (!ItemStack.isSameItemSameComponents((ItemStack)this.stack, (ItemStack)alreadyThere)) continue;
                alreadyThere.grow(this.stack.getCount());
                matched = true;
                break;
            }
            if (!matched) {
                baseItems.add(this.stack.copy());
            }
        }
        return baseItems;
    }
}

