/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public class RequestItemTrigger
extends SimpleCriterionTrigger<RequestItemTriggerInstance> {
    public void trigger(ServerPlayer player, ItemStack stack, int uniqueItemsCrafted) {
        this.trigger(player, instance -> instance.matches(stack, uniqueItemsCrafted));
    }

    public Codec<RequestItemTriggerInstance> codec() {
        return RequestItemTriggerInstance.CODEC;
    }

    public record RequestItemTriggerInstance(Optional<ContextAwarePredicate> player, Optional<ItemPredicate> item, Optional<MinMaxBounds.Ints> uniqueItemsCrafted) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<RequestItemTriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(RequestItemTriggerInstance::player), (App)ItemPredicate.CODEC.optionalFieldOf("item").forGetter(RequestItemTriggerInstance::item), (App)MinMaxBounds.Ints.CODEC.optionalFieldOf("unique_items_crafted").forGetter(RequestItemTriggerInstance::uniqueItemsCrafted)).apply((Applicative)instance, RequestItemTriggerInstance::new));

        public boolean matches(ItemStack stack, int uniqueItemsCrafted) {
            if (this.item().isEmpty() || this.item().get().test(stack)) {
                return this.uniqueItemsCrafted().isEmpty() || this.uniqueItemsCrafted().get().matches(uniqueItemsCrafted);
            }
            return false;
        }
    }
}

