/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.util;

import jagm.classicpipes.util.MiscUtil;
import jagm.classicpipes.util.Tuple;
import java.util.Comparator;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public enum SortingMode {
    AMOUNT_ASCENDING(0, MiscUtil.AMOUNT.thenComparing(MiscUtil.NAME), "amount", "ascending"),
    AMOUNT_DESCENDING(1, MiscUtil.AMOUNT.reversed().thenComparing(MiscUtil.NAME), "amount", "descending"),
    A_TO_Z(2, MiscUtil.NAME, "name", "az"),
    Z_TO_A(3, MiscUtil.NAME.reversed(), "name", "za"),
    MOD_A_TO_Z(4, MiscUtil.MOD.thenComparing(MiscUtil.AMOUNT.reversed().thenComparing(MiscUtil.NAME)), "mod", "az"),
    MOD_Z_TO_A(5, MiscUtil.MOD.reversed().thenComparing(MiscUtil.AMOUNT.reversed().thenComparing(MiscUtil.NAME.reversed())), "mod", "za"),
    CRAFTABLE_A_TO_Z(6, MiscUtil.CRAFTABLE.reversed().thenComparing(MiscUtil.NAME), "craftable", "az"),
    CRAFTABLE_Z_TO_A(7, MiscUtil.CRAFTABLE.reversed().thenComparing(MiscUtil.NAME.reversed()), "craftable", "za");

    private final byte value;
    private final Comparator<Tuple<ItemStack, Boolean>> comparator;
    private final String type;
    private final String direction;

    private SortingMode(byte value, Comparator<Tuple<ItemStack, Boolean>> comparator, String type, String direction) {
        this.value = value;
        this.comparator = comparator;
        this.type = type;
        this.direction = direction;
    }

    public Comparator<Tuple<ItemStack, Boolean>> getComparator() {
        return this.comparator;
    }

    public Component getType() {
        return Component.translatable((String)("widget.classicpipes." + this.type));
    }

    public Component getDirection() {
        return Component.translatable((String)("widget.classicpipes." + this.direction));
    }

    public SortingMode nextType() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> Z_TO_A;
            case 1 -> A_TO_Z;
            case 2 -> MOD_A_TO_Z;
            case 3 -> MOD_Z_TO_A;
            case 4 -> CRAFTABLE_A_TO_Z;
            case 5 -> CRAFTABLE_Z_TO_A;
            case 6 -> AMOUNT_DESCENDING;
            case 7 -> AMOUNT_ASCENDING;
        };
    }

    public SortingMode prevType() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> CRAFTABLE_Z_TO_A;
            case 1 -> CRAFTABLE_A_TO_Z;
            case 2 -> AMOUNT_DESCENDING;
            case 3 -> AMOUNT_ASCENDING;
            case 4 -> A_TO_Z;
            case 5 -> Z_TO_A;
            case 6 -> MOD_A_TO_Z;
            case 7 -> MOD_Z_TO_A;
        };
    }

    public SortingMode otherDirection() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> AMOUNT_DESCENDING;
            case 1 -> AMOUNT_ASCENDING;
            case 2 -> Z_TO_A;
            case 3 -> A_TO_Z;
            case 4 -> MOD_Z_TO_A;
            case 5 -> MOD_A_TO_Z;
            case 6 -> CRAFTABLE_Z_TO_A;
            case 7 -> CRAFTABLE_A_TO_Z;
        };
    }

    public byte getValue() {
        return this.value;
    }

    public static SortingMode fromByte(byte value) {
        for (SortingMode sortingMode : SortingMode.values()) {
            if (sortingMode.getValue() != value) continue;
            return sortingMode;
        }
        return AMOUNT_DESCENDING;
    }
}

