/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.blockentity;

import jagm.classicpipes.blockentity.FluidPipeEntity;
import jagm.classicpipes.util.FluidInPipe;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;

public class NeoForgeFluidPipeWrapper
implements ResourceHandler<FluidResource> {
    private final FluidPipeEntity pipe;
    private final Direction side;

    public NeoForgeFluidPipeWrapper(FluidPipeEntity pipe, Direction side) {
        this.pipe = pipe;
        this.side = side;
    }

    public int size() {
        return 1;
    }

    public FluidResource getResource(int tank) {
        return FluidResource.EMPTY;
    }

    public long getAmountAsLong(int tank) {
        return 0L;
    }

    public long getCapacityAsLong(int tank, FluidResource fluidResource) {
        return 1000L;
    }

    public boolean isValid(int tank, FluidResource fluidResource) {
        return this.pipe.isPipeConnected(this.pipe.getBlockState(), this.side);
    }

    public int insert(int tank, FluidResource fluidResource, int maxAmount, TransactionContext transaction) {
        if (maxAmount <= 0 || !this.pipe.emptyOrMatches(fluidResource.getFluid()) || !this.isValid(tank, fluidResource)) {
            return 0;
        }
        int amount = Math.min(this.pipe.remainingCapacity(), maxAmount);
        Level level = this.pipe.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.pipe.setFluid(fluidResource.getFluid());
            FluidInPipe fluidPacket = new FluidInPipe(amount, this.pipe.getTargetSpeed(), 0, this.side, this.side, 0);
            this.pipe.insertFluidPacket((Level)serverLevel, fluidPacket);
            serverLevel.sendBlockUpdated(this.pipe.getBlockPos(), this.pipe.getBlockState(), this.pipe.getBlockState(), 2);
        }
        this.pipe.setChanged();
        return amount;
    }

    public int extract(int tank, FluidResource fluidResource, int amount, TransactionContext transaction) {
        return 0;
    }
}

