/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import jagm.classicpipes.blockentity.ItemPipeEntity;
import jagm.classicpipes.blockentity.NetworkedPipeEntity;
import jagm.classicpipes.client.renderer.ItemInPipeRenderState;
import jagm.classicpipes.util.ItemInPipe;
import jagm.classicpipes.util.Tuple;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionfc;

public class PipeRenderer<T extends ItemPipeEntity>
implements BlockEntityRenderer<T, PipeRenderState> {
    protected final BlockEntityRendererProvider.Context context;

    public PipeRenderer(BlockEntityRendererProvider.Context context) {
        this.context = context;
    }

    public PipeRenderState createRenderState() {
        return new PipeRenderState();
    }

    public void extractRenderState(T pipe, PipeRenderState pipeState, float partialTicks, Vec3 cameraPos, ModelFeatureRenderer.CrumblingOverlay breakProgress) {
        super.extractRenderState(pipe, (BlockEntityRenderState)pipeState, partialTicks, cameraPos, breakProgress);
        ArrayList<ItemInPipeRenderState> itemRenderStates = new ArrayList<ItemInPipeRenderState>();
        for (ItemInPipe item : ((ItemPipeEntity)((Object)pipe)).getContents()) {
            ItemStackRenderState stackState = new ItemStackRenderState();
            this.context.itemModelResolver().updateForTopItem(stackState, item.getStack(), ItemDisplayContext.FIXED, pipe.getLevel(), null, 0);
            itemRenderStates.add(new ItemInPipeRenderState(stackState, item.getRenderPosition(partialTicks), item.getProgress() < 1024 ? item.getFromDirection() : item.getTargetDirection()));
        }
        if (pipe instanceof NetworkedPipeEntity) {
            NetworkedPipeEntity networkedPipe = (NetworkedPipeEntity)((Object)pipe);
            pipeState.initialise(itemRenderStates, ((ItemPipeEntity)((Object)pipe)).networkDistances, this.context.font(), networkedPipe.isController(), networkedPipe.syncedNetworkPos);
        } else {
            pipeState.initialise(itemRenderStates, ((ItemPipeEntity)((Object)pipe)).networkDistances, this.context.font());
        }
    }

    public void submit(PipeRenderState pipeState, PoseStack poses, SubmitNodeCollector queue, CameraRenderState cameraState) {
        if (!pipeState.contents().isEmpty()) {
            for (ItemInPipeRenderState itemState : pipeState.contents()) {
                poses.pushPose();
                poses.translate(itemState.renderPos());
                poses.scale(0.4375f, 0.4375f, 0.4375f);
                if (itemState.direction().equals((Object)Direction.EAST) || itemState.direction().equals((Object)Direction.WEST)) {
                    poses.mulPose((Quaternionfc)Axis.YP.rotationDegrees(90.0f));
                } else if (itemState.direction().equals((Object)Direction.UP) || itemState.direction().equals((Object)Direction.DOWN)) {
                    poses.mulPose((Quaternionfc)Axis.XP.rotationDegrees(90.0f));
                }
                itemState.stackState().submit(poses, queue, pipeState.lightCoords, OverlayTexture.NO_OVERLAY, 0);
                poses.popPose();
            }
        }
    }

    public static class PipeRenderState
    extends BlockEntityRenderState {
        private List<ItemInPipeRenderState> contents;
        private Map<Direction, Tuple<BlockPos, Integer>> networkDistances;
        private Font font;
        private boolean controller;
        private BlockPos syncedNetworkPos;
        private List<ItemStackRenderState> heldItems;
        private List<Float> angles;

        public void initialise(List<ItemInPipeRenderState> contents, Map<Direction, Tuple<BlockPos, Integer>> networkDistances, Font font, boolean controller, BlockPos syncedNetworkPos) {
            this.contents = contents;
            this.networkDistances = networkDistances;
            this.font = font;
            this.controller = controller;
            this.syncedNetworkPos = syncedNetworkPos;
        }

        public void initialise(List<ItemInPipeRenderState> contents, Map<Direction, Tuple<BlockPos, Integer>> networkDistances, Font font) {
            this.initialise(contents, networkDistances, font, false, null);
        }

        public void setHeldItems(List<ItemStackRenderState> heldItems, List<Float> angles) {
            this.heldItems = heldItems;
            this.angles = angles;
        }

        public List<ItemInPipeRenderState> contents() {
            return this.contents;
        }

        public Map<Direction, Tuple<BlockPos, Integer>> networkDistances() {
            return this.networkDistances;
        }

        public Font font() {
            return this.font;
        }

        public boolean controller() {
            return this.controller;
        }

        public BlockPos syncedNetworkPos() {
            return this.syncedNetworkPos;
        }

        public List<ItemStackRenderState> heldItems() {
            return this.heldItems;
        }

        public List<Float> angles() {
            return this.angles;
        }
    }
}

