/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.client.screen.widget;

import jagm.classicpipes.util.MiscUtil;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.input.InputWithModifiers;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;

public class SmallerCheckbox
extends AbstractButton {
    private static final ResourceLocation CHECKBOX_SELECTED_SPRITE = MiscUtil.resourceLocation("widget/checkbox_selected");
    private static final ResourceLocation CHECKBOX_SPRITE = MiscUtil.resourceLocation("widget/checkbox");
    public static final int SIZE = 12;
    private boolean selected;
    private final OnValueChange onValueChange;
    private final Component label;
    private final Font font;

    public SmallerCheckbox(int x, int y, OnValueChange onValueChange, boolean selected, Component label, Font font) {
        super(x, y, 0, 0, CommonComponents.EMPTY);
        this.width = 12 + (font != null ? 2 + font.width((FormattedText)label) : 0);
        this.height = 12;
        this.selected = selected;
        this.onValueChange = onValueChange;
        this.label = label;
        this.font = font;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void onPress(InputWithModifiers modifiers) {
        this.selected = !this.selected;
        this.onValueChange.onValueChange(this, this.selected);
    }

    public boolean selected() {
        return this.selected;
    }

    public void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        narrationElementOutput.add(NarratedElementType.TITLE, (Component)this.createNarrationMessage());
        if (this.active) {
            if (this.isFocused()) {
                narrationElementOutput.add(NarratedElementType.USAGE, (Component)Component.translatable((String)"narration.checkbox.usage.focused"));
            } else {
                narrationElementOutput.add(NarratedElementType.USAGE, (Component)Component.translatable((String)"narration.checkbox.usage.hovered"));
            }
        }
    }

    public void renderWidget(GuiGraphics graphics, int x, int y, float f) {
        ResourceLocation spriteLocation = this.selected() ? CHECKBOX_SELECTED_SPRITE : CHECKBOX_SPRITE;
        graphics.blitSprite(RenderPipelines.GUI_TEXTURED, spriteLocation, this.getX(), this.getY(), 12, 12, ARGB.white((float)this.alpha));
        graphics.drawString(this.font, this.label, this.getX() + 12 + 2, this.getY() + 3, -12566464, false);
    }

    public static interface OnValueChange {
        public static final OnValueChange NOP = (checkbox, value) -> {};

        public void onValueChange(SmallerCheckbox var1, boolean var2);
    }

    public static class Builder {
        private int x = 0;
        private int y = 0;
        private OnValueChange onValueChange = OnValueChange.NOP;
        private Tooltip tooltip = null;
        private boolean selected = false;
        private Component label = null;
        private Font font = null;

        Builder() {
        }

        public Builder pos(int x, int y) {
            this.x = x;
            this.y = y;
            return this;
        }

        public Builder onValueChange(OnValueChange onValueChange) {
            this.onValueChange = onValueChange;
            return this;
        }

        public Builder tooltip(Tooltip tooltip) {
            this.tooltip = tooltip;
            return this;
        }

        public Builder selected(boolean selected) {
            this.selected = selected;
            return this;
        }

        public Builder label(Component label, Font font) {
            this.label = label;
            this.font = font;
            return this;
        }

        public SmallerCheckbox build() {
            SmallerCheckbox checkbox = new SmallerCheckbox(this.x, this.y, this.onValueChange, this.selected, this.label, this.font);
            checkbox.setTooltip(this.tooltip);
            return checkbox;
        }
    }
}

