/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.item;

import jagm.classicpipes.ClassicPipes;
import jagm.classicpipes.item.LabelItem;
import jagm.classicpipes.services.Services;
import jagm.classicpipes.util.MiscUtil;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.Level;

public class ModLabelItem
extends LabelItem {
    public ModLabelItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        ItemStack targetStack = player.getItemInHand(hand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND);
        if (targetStack.isEmpty()) {
            if (level.isClientSide()) {
                player.displayClientMessage((Component)Component.translatable((String)"chat.classicpipes.nothing_in_offhand"), false);
            }
        } else {
            ItemStack labelStack = player.getItemInHand(hand);
            String mod = MiscUtil.modFromItem(targetStack);
            labelStack.set(ClassicPipes.LABEL_COMPONENT, (Object)mod);
            if (level.isClientSide()) {
                player.displayClientMessage((Component)Component.translatable((String)"chat.classicpipes.mod_set", (Object[])new Object[]{Component.literal((String)Services.LOADER_SERVICE.getModName(mod)).withStyle(ChatFormatting.LIGHT_PURPLE)}), false);
            }
        }
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        return InteractionResult.SUCCESS;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> tooltipAdder, TooltipFlag flag) {
        String mod = (String)stack.get(ClassicPipes.LABEL_COMPONENT);
        if (mod != null) {
            tooltipAdder.accept((Component)Component.literal((String)Services.LOADER_SERVICE.getModName(mod)).withStyle(ChatFormatting.LIGHT_PURPLE));
        } else {
            tooltipAdder.accept((Component)Component.translatable((String)"item.classicpipes.mod_label.desc").withStyle(ChatFormatting.GRAY));
        }
    }

    @Override
    public boolean itemMatches(ItemStack tagStack, ItemStack compareStack) {
        String mod = (String)tagStack.get(ClassicPipes.LABEL_COMPONENT);
        return mod != null && mod.equals(MiscUtil.modFromItem(compareStack));
    }
}

