/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.services;

import jagm.classicpipes.blockentity.FluidPipeEntity;
import jagm.classicpipes.blockentity.ItemPipeEntity;
import jagm.classicpipes.client.renderer.FluidRenderInfo;
import jagm.classicpipes.services.LoaderService;
import jagm.classicpipes.util.FluidInPipe;
import jagm.classicpipes.util.ItemInPipe;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.access.ItemAccess;
import net.neoforged.neoforge.transfer.fluid.FluidResource;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import net.neoforged.neoforgespi.language.IModInfo;
import org.apache.commons.lang3.function.TriFunction;

public class NeoForgeService
implements LoaderService {
    @Override
    public <B extends BlockEntity> BlockEntityType<B> createBlockEntityType(BiFunction<BlockPos, BlockState, B> blockEntitySupplier, Block ... validBlocks) {
        return new BlockEntityType(blockEntitySupplier::apply, Set.of(validBlocks));
    }

    @Override
    public <M extends AbstractContainerMenu, D> MenuType<M> createMenuType(TriFunction<Integer, Inventory, D, M> menuSupplier, StreamCodec<RegistryFriendlyByteBuf, D> codec) {
        return IMenuTypeExtension.create((id, inventory, buffer) -> (AbstractContainerMenu)menuSupplier.apply((Object)id, (Object)inventory, codec.decode((Object)buffer)));
    }

    @Override
    public <M extends AbstractContainerMenu> MenuType<M> createSimpleMenuType(BiFunction<Integer, Inventory, M> menuSupplier) {
        return new MenuType(menuSupplier::apply, FeatureFlags.DEFAULT_FLAGS);
    }

    @Override
    public <D> void openMenu(ServerPlayer player, MenuProvider menuProvider, D payload, StreamCodec<RegistryFriendlyByteBuf, D> codec) {
        player.openMenu(menuProvider, buffer -> codec.encode(buffer, payload));
    }

    @Override
    public void sendToServer(CustomPacketPayload payload) {
        ClientPacketDistributor.sendToServer((CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void sendToClient(ServerPlayer player, CustomPacketPayload payload) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public boolean canAccessContainer(Level level, BlockPos containerPos, Direction face) {
        BlockEntity blockEntity = level.getBlockEntity(containerPos);
        if (blockEntity instanceof ItemPipeEntity) {
            return false;
        }
        BlockState state = level.getBlockState(containerPos);
        ResourceHandler itemHandler = (ResourceHandler)level.getCapability(Capabilities.Item.BLOCK, containerPos, state, blockEntity, (Object)face);
        if (itemHandler != null) {
            return itemHandler.size() > 0;
        }
        return false;
    }

    @Override
    public boolean handleItemInsertion(ItemPipeEntity pipe, ServerLevel level, BlockPos pipePos, BlockState pipeState, ItemInPipe item) {
        BlockPos containerPos = pipePos.relative(item.getTargetDirection());
        BlockEntity blockEntity = level.getBlockEntity(containerPos);
        if (blockEntity instanceof ItemPipeEntity) {
            ItemPipeEntity nextPipe = (ItemPipeEntity)blockEntity;
            item.resetProgress(item.getTargetDirection().getOpposite());
            nextPipe.insertPipeItem((Level)level, item);
            level.sendBlockUpdated(containerPos, nextPipe.getBlockState(), nextPipe.getBlockState(), 2);
            return true;
        }
        Direction face = item.getTargetDirection().getOpposite();
        BlockState state = level.getBlockState(containerPos);
        ResourceHandler itemHandler = (ResourceHandler)level.getCapability(Capabilities.Item.BLOCK, containerPos, state, blockEntity, (Object)face);
        if (itemHandler != null) {
            ItemStack stack = item.getStack();
            try (Transaction transaction = Transaction.open(null);){
                for (int slot = 0; slot < itemHandler.size(); ++slot) {
                    stack.shrink(itemHandler.insert(slot, (Resource)ItemResource.of((ItemStack)stack), stack.getCount(), (TransactionContext)transaction));
                    if (!stack.isEmpty()) continue;
                    transaction.commit();
                    boolean bl = true;
                    return bl;
                }
                transaction.commit();
            }
            item.setStack(stack);
        }
        item.resetProgress(item.getTargetDirection());
        pipe.routeItem(pipeState, item);
        return false;
    }

    @Override
    public boolean handleItemExtraction(ItemPipeEntity pipe, BlockState pipeState, ServerLevel level, BlockPos containerPos, Direction face, int amount, Predicate<ItemStack> predicate) {
        BlockEntity blockEntity = level.getBlockEntity(containerPos);
        if (blockEntity instanceof ItemPipeEntity) {
            return false;
        }
        BlockState state = level.getBlockState(containerPos);
        ResourceHandler itemHandler = (ResourceHandler)level.getCapability(Capabilities.Item.BLOCK, containerPos, state, blockEntity, (Object)face);
        if (itemHandler != null) {
            try (Transaction transaction = Transaction.open(null);){
                for (int slot = itemHandler.size() - 1; slot >= 0; --slot) {
                    ItemStack extracted;
                    int amountToExtract;
                    ItemResource itemResource = (ItemResource)itemHandler.getResource(slot);
                    if (itemResource.isEmpty() || !predicate.test(itemResource.toStack(amountToExtract = Math.min(amount, itemResource.getMaxStackSize()))) || (extracted = itemResource.toStack(itemHandler.extract(slot, (Resource)itemResource, amountToExtract, (TransactionContext)transaction))).isEmpty()) continue;
                    pipe.setItem(face.getOpposite(), extracted);
                    transaction.commit();
                    boolean bl = true;
                    return bl;
                }
            }
        }
        return false;
    }

    @Override
    public boolean extractSpecificItem(ItemPipeEntity pipe, ServerLevel level, BlockPos containerPos, Direction face, ItemStack stack) {
        ItemStack target = stack.copy();
        ResourceHandler itemHandler = (ResourceHandler)level.getCapability(Capabilities.Item.BLOCK, containerPos, (Object)face);
        if (itemHandler != null) {
            try (Transaction transaction = Transaction.open(null);){
                for (int slot = itemHandler.size() - 1; slot >= 0; --slot) {
                    ItemStack extracted;
                    ItemResource itemResource = (ItemResource)itemHandler.getResource(slot);
                    if (itemResource.isEmpty() || !itemResource.matches(target) || (extracted = itemResource.toStack(itemHandler.extract(slot, (Resource)itemResource, target.getCount(), (TransactionContext)transaction))).isEmpty()) continue;
                    target.shrink(extracted.getCount());
                    pipe.setItem(face.getOpposite(), extracted);
                    if (!target.isEmpty()) continue;
                    transaction.commit();
                    boolean bl = true;
                    return bl;
                }
            }
        }
        return false;
    }

    @Override
    public List<ItemStack> getContainerItems(ServerLevel level, BlockPos pos, Direction face) {
        ResourceHandler itemHandler = (ResourceHandler)level.getCapability(Capabilities.Item.BLOCK, pos, (Object)face);
        if (itemHandler != null) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            for (int slot = 0; slot < itemHandler.size(); ++slot) {
                ItemStack slotStack = ((ItemResource)itemHandler.getResource(slot)).toStack(itemHandler.getAmountAsInt(slot));
                if (slotStack.isEmpty()) continue;
                boolean matched = false;
                for (ItemStack stack : stacks) {
                    if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)slotStack)) continue;
                    stack.setCount(stack.getCount() + slotStack.getCount());
                    matched = true;
                    break;
                }
                if (matched) continue;
                stacks.add(slotStack.copy());
            }
            return stacks;
        }
        return List.of();
    }

    @Override
    public String getModName(String modId) {
        return ModList.get().getModContainerById(modId).map(ModContainer::getModInfo).map(IModInfo::getDisplayName).orElse(modId);
    }

    @Override
    public boolean handleFluidInsertion(FluidPipeEntity pipe, ServerLevel level, BlockPos pipePos, BlockState pipeState, BlockEntity containerEntity, BlockPos containerPos, Fluid fluid, FluidInPipe fluidPacket) {
        Direction face = fluidPacket.getTargetDirection().getOpposite();
        BlockState state = level.getBlockState(containerPos);
        ResourceHandler fluidHandler = (ResourceHandler)level.getCapability(Capabilities.Fluid.BLOCK, containerPos, state, containerEntity, (Object)face);
        if (fluidHandler != null) {
            try (Transaction transaction = Transaction.open(null);){
                int amountFilled = fluidHandler.insert((Resource)FluidResource.of((Fluid)fluid), fluidPacket.getAmount(), (TransactionContext)transaction);
                transaction.commit();
                if (amountFilled >= fluidPacket.getAmount()) {
                    boolean bl = true;
                    return bl;
                }
                fluidPacket.setAmount(fluidPacket.getAmount() - amountFilled);
            }
        }
        return false;
    }

    @Override
    public boolean canAccessFluidContainer(Level level, BlockPos containerPos, Direction face) {
        BlockEntity blockEntity = level.getBlockEntity(containerPos);
        if (blockEntity instanceof FluidPipeEntity) {
            return false;
        }
        BlockState state = level.getBlockState(containerPos);
        ResourceHandler fluidHandler = (ResourceHandler)level.getCapability(Capabilities.Fluid.BLOCK, containerPos, state, blockEntity, (Object)face);
        if (fluidHandler != null) {
            return fluidHandler.size() > 0;
        }
        return false;
    }

    @Override
    public boolean handleFluidExtraction(FluidPipeEntity pipe, BlockState pipeState, ServerLevel level, BlockPos containerPos, Direction face, int amount, Predicate<Fluid> predicate) {
        BlockEntity blockEntity = level.getBlockEntity(containerPos);
        if (blockEntity instanceof FluidPipeEntity || pipe.totalAmount() >= 1000) {
            return false;
        }
        BlockState state = level.getBlockState(containerPos);
        ResourceHandler fluidHandler = (ResourceHandler)level.getCapability(Capabilities.Fluid.BLOCK, containerPos, state, blockEntity, (Object)face);
        if (fluidHandler != null) {
            FlowingFluid fluid;
            int amountToDrain = Math.min(amount, pipe.remainingCapacity());
            Object object = fluid = pipe.getFluid() != null ? pipe.getFluid() : Fluids.WATER;
            if (pipe.isEmpty()) {
                for (int tank = 0; tank < fluidHandler.size(); ++tank) {
                    FluidResource fluidResource = (FluidResource)fluidHandler.getResource(tank);
                    if (fluidResource.isEmpty() || !predicate.test(fluidResource.getFluid())) continue;
                    fluid = fluidResource.getFluid();
                    break;
                }
            }
            try (Transaction transaction = Transaction.open(null);){
                int amountExtracted = fluidHandler.extract((Resource)FluidResource.of((Fluid)fluid), amountToDrain, (TransactionContext)transaction);
                if (amountExtracted > 0) {
                    pipe.setFluid((Fluid)fluid);
                    pipe.insertFluidPacket((Level)level, new FluidInPipe(amountExtracted, pipe.getTargetSpeed(), 0, face.getOpposite(), face.getOpposite(), 0));
                    transaction.commit();
                    boolean bl = true;
                    return bl;
                }
            }
        }
        return false;
    }

    @Override
    public FluidRenderInfo getFluidRenderInfo(FluidState fluidState, BlockAndTintGetter level, BlockPos pos) {
        IClientFluidTypeExtensions fluidInfo = IClientFluidTypeExtensions.of((FluidState)fluidState);
        int tint = fluidInfo.getTintColor(fluidState, level, pos);
        AbstractTexture texture = Minecraft.getInstance().getTextureManager().getTexture(TextureAtlas.LOCATION_BLOCKS);
        if (texture instanceof TextureAtlas) {
            TextureAtlas blockAtlas = (TextureAtlas)texture;
            return new FluidRenderInfo(tint, blockAtlas.getSprite(fluidInfo.getStillTexture(fluidState, level, pos)));
        }
        return new FluidRenderInfo(tint, null);
    }

    @Override
    public FluidRenderInfo getFluidRenderInfo(FluidState fluidState) {
        IClientFluidTypeExtensions fluidInfo = IClientFluidTypeExtensions.of((FluidState)fluidState);
        int tint = fluidInfo.getTintColor();
        AbstractTexture texture = Minecraft.getInstance().getTextureManager().getTexture(TextureAtlas.LOCATION_BLOCKS);
        if (texture instanceof TextureAtlas) {
            TextureAtlas blockAtlas = (TextureAtlas)texture;
            return new FluidRenderInfo(tint, blockAtlas.getSprite(fluidInfo.getStillTexture()));
        }
        return new FluidRenderInfo(tint, null);
    }

    @Override
    public Fluid getFluidFromStack(ItemStack stack) {
        Fluid fluid = null;
        ResourceHandler fluidHandler = (ResourceHandler)ItemAccess.forStack((ItemStack)stack).getCapability(Capabilities.Fluid.ITEM);
        if (fluidHandler != null) {
            fluid = ((FluidResource)fluidHandler.getResource(0)).getFluid();
        } else {
            Item item = stack.getItem();
            if (item instanceof BucketItem) {
                BucketItem bucket = (BucketItem)item;
                fluid = bucket.content;
            }
        }
        return fluid != null && fluid.isSame(Fluids.EMPTY) ? null : fluid;
    }

    @Override
    public Component getFluidName(Fluid fluid) {
        return fluid.getFluidType().getDescription();
    }
}

