/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes;

import jagm.classicpipes.ClassicPipes;
import jagm.classicpipes.blockentity.FluidPipeEntity;
import jagm.classicpipes.blockentity.ForgeFluidPipeWrapper;
import jagm.classicpipes.blockentity.ForgeItemPipeWrapper;
import jagm.classicpipes.blockentity.ItemPipeEntity;
import jagm.classicpipes.client.renderer.FluidPipeRenderer;
import jagm.classicpipes.client.renderer.PipeRenderer;
import jagm.classicpipes.client.renderer.RecipePipeRenderer;
import jagm.classicpipes.client.screen.AdvancedCopperFluidPipeScreen;
import jagm.classicpipes.client.screen.AdvancedCopperPipeScreen;
import jagm.classicpipes.client.screen.DiamondFluidPipeScreen;
import jagm.classicpipes.client.screen.DiamondPipeScreen;
import jagm.classicpipes.client.screen.MatchingPipeScreen;
import jagm.classicpipes.client.screen.ProviderPipeScreen;
import jagm.classicpipes.client.screen.RecipePipeScreen;
import jagm.classicpipes.client.screen.RequestScreen;
import jagm.classicpipes.client.screen.RoutingPipeScreen;
import jagm.classicpipes.client.screen.StockingPipeScreen;
import jagm.classicpipes.client.screen.StoragePipeScreen;
import jagm.classicpipes.network.ClientBoundItemListPayload;
import jagm.classicpipes.network.ForgePacketHandler;
import jagm.classicpipes.network.ServerBoundActiveStockingPayload;
import jagm.classicpipes.network.ServerBoundDefaultRoutePayload;
import jagm.classicpipes.network.ServerBoundLeaveOnePayload;
import jagm.classicpipes.network.ServerBoundMatchComponentsPayload;
import jagm.classicpipes.network.ServerBoundRequestPayload;
import jagm.classicpipes.network.ServerBoundSetFilterPayload;
import jagm.classicpipes.network.ServerBoundSlotDirectionPayload;
import jagm.classicpipes.network.ServerBoundSortingModePayload;
import jagm.classicpipes.network.ServerBoundTransferRecipePayload;
import jagm.classicpipes.util.MiscUtil;
import java.util.HashMap;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;

@Mod(value="classicpipes")
public class ForgeEntrypoint {

    @Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="classicpipes", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ClientModEventHandler {
        @SubscribeEvent
        public static void onRegisterRenderers(EntityRenderersEvent.RegisterRenderers event) {
            event.registerBlockEntityRenderer(ClassicPipes.BASIC_PIPE_ENTITY, PipeRenderer::new);
            event.registerBlockEntityRenderer(ClassicPipes.GOLDEN_PIPE_ENTITY, PipeRenderer::new);
            event.registerBlockEntityRenderer(ClassicPipes.COPPER_PIPE_ENTITY, PipeRenderer::new);
            event.registerBlockEntityRenderer(ClassicPipes.IRON_PIPE_ENTITY, PipeRenderer::new);
            event.registerBlockEntityRenderer(ClassicPipes.DIAMOND_PIPE_ENTITY, PipeRenderer::new);
            event.registerBlockEntityRenderer(ClassicPipes.FLINT_PIPE_ENTITY, PipeRenderer::new);
            event.registerBlockEntityRenderer(ClassicPipes.LAPIS_PIPE_ENTITY, PipeRenderer::new);
            event.registerBlockEntityRenderer(ClassicPipes.OBSIDIAN_PIPE_ENTITY, PipeRenderer::new);
            event.registerBlockEntityRenderer(ClassicPipes.BONE_PIPE_ENTITY, PipeRenderer::new);
            event.registerBlockEntityRenderer(ClassicPipes.ROUTING_PIPE_ENTITY, PipeRenderer::new);
            event.registerBlockEntityRenderer(ClassicPipes.PROVIDER_PIPE_ENTITY, PipeRenderer::new);
            event.registerBlockEntityRenderer(ClassicPipes.REQUEST_PIPE_ENTITY, PipeRenderer::new);
            event.registerBlockEntityRenderer(ClassicPipes.STOCKING_PIPE_ENTITY, PipeRenderer::new);
            event.registerBlockEntityRenderer(ClassicPipes.MATCHING_PIPE_ENTITY, PipeRenderer::new);
            event.registerBlockEntityRenderer(ClassicPipes.STORAGE_PIPE_ENTITY, PipeRenderer::new);
            event.registerBlockEntityRenderer(ClassicPipes.RECIPE_PIPE_ENTITY, RecipePipeRenderer::new);
            event.registerBlockEntityRenderer(ClassicPipes.FLUID_PIPE_ENTITY, FluidPipeRenderer::new);
            event.registerBlockEntityRenderer(ClassicPipes.COPPER_FLUID_PIPE_ENTITY, FluidPipeRenderer::new);
            event.registerBlockEntityRenderer(ClassicPipes.IRON_FLUID_PIPE_ENTITY, FluidPipeRenderer::new);
            event.registerBlockEntityRenderer(ClassicPipes.LAPIS_FLUID_PIPE_ENTITY, FluidPipeRenderer::new);
            event.registerBlockEntityRenderer(ClassicPipes.DIAMOND_FLUID_PIPE_ENTITY, FluidPipeRenderer::new);
            event.registerBlockEntityRenderer(ClassicPipes.OBSIDIAN_FLUID_PIPE_ENTITY, FluidPipeRenderer::new);
            event.registerBlockEntityRenderer(ClassicPipes.ADVANCED_COPPER_PIPE_ENTITY, PipeRenderer::new);
            event.registerBlockEntityRenderer(ClassicPipes.ADVANCED_COPPER_FLUID_PIPE_ENTITY, FluidPipeRenderer::new);
        }

        @SubscribeEvent
        public static void onFillCreativeTabs(BuildCreativeModeTabContentsEvent event) {
            if (event.getTabKey() == ClassicPipes.PIPES_TAB_KEY) {
                ClassicPipes.ITEMS.forEach((name, item) -> event.accept((ItemLike)item));
            }
        }

        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            event.enqueueWork(() -> {
                MenuScreens.register(ClassicPipes.DIAMOND_PIPE_MENU, DiamondPipeScreen::new);
                MenuScreens.register(ClassicPipes.ROUTING_PIPE_MENU, RoutingPipeScreen::new);
                MenuScreens.register(ClassicPipes.PROVIDER_PIPE_MENU, ProviderPipeScreen::new);
                MenuScreens.register(ClassicPipes.REQUEST_MENU, RequestScreen::new);
                MenuScreens.register(ClassicPipes.STOCKING_PIPE_MENU, StockingPipeScreen::new);
                MenuScreens.register(ClassicPipes.MATCHING_PIPE_MENU, MatchingPipeScreen::new);
                MenuScreens.register(ClassicPipes.STORAGE_PIPE_MENU, StoragePipeScreen::new);
                MenuScreens.register(ClassicPipes.RECIPE_PIPE_MENU, RecipePipeScreen::new);
                MenuScreens.register(ClassicPipes.DIAMOND_FLUID_PIPE_MENU, DiamondFluidPipeScreen::new);
                MenuScreens.register(ClassicPipes.ADVANCED_COPPER_PIPE_MENU, AdvancedCopperPipeScreen::new);
                MenuScreens.register(ClassicPipes.ADVANCED_COPPER_FLUID_PIPE_MENU, AdvancedCopperFluidPipeScreen::new);
            });
        }
    }

    @Mod.EventBusSubscriber(modid="classicpipes", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ForgeEventHandler {
        @SubscribeEvent
        public static void onRegisterCapabilities(AttachCapabilitiesEvent<BlockEntity> event) {
            Object object = event.getObject();
            if (object instanceof ItemPipeEntity) {
                ItemPipeEntity pipe = (ItemPipeEntity)((Object)object);
                wrapperForSide = new HashMap<Direction, LazyOptional>();
                for (Direction side : Direction.values()) {
                    wrapperForSide.put(side, LazyOptional.of(() -> new ForgeItemPipeWrapper(pipe, side)));
                }
                event.addCapability(MiscUtil.resourceLocation("item_pipe"), new ICapabilityProvider(){

                    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
                        if (cap == ForgeCapabilities.ITEM_HANDLER && side != null) {
                            return ((LazyOptional)wrapperForSide.get(side)).cast();
                        }
                        return LazyOptional.empty();
                    }
                });
                event.addListener(() -> wrapperForSide.forEach((direction, lazyOptional) -> lazyOptional.invalidate()));
            } else {
                wrapperForSide = event.getObject();
                if (wrapperForSide instanceof FluidPipeEntity) {
                    FluidPipeEntity pipe = (FluidPipeEntity)((Object)wrapperForSide);
                    wrapperForSide = new HashMap();
                    for (Direction side : Direction.values()) {
                        wrapperForSide.put(side, LazyOptional.of(() -> new ForgeFluidPipeWrapper(pipe, side)));
                    }
                    event.addCapability(MiscUtil.resourceLocation("fluid_pipe"), new ICapabilityProvider(){

                        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
                            if (cap == ForgeCapabilities.FLUID_HANDLER && side != null) {
                                return ((LazyOptional)wrapperForSide.get(side)).cast();
                            }
                            return LazyOptional.empty();
                        }
                    });
                    event.addListener(() -> wrapperForSide.forEach((direction, lazyOptional) -> lazyOptional.invalidate()));
                }
            }
        }
    }

    @Mod.EventBusSubscriber(modid="classicpipes", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ModEventHandler {
        @SubscribeEvent
        public static void onRegister(RegisterEvent event) {
            event.register(ForgeRegistries.Keys.BLOCKS, helper -> ClassicPipes.BLOCKS.forEach((arg_0, arg_1) -> ((RegisterEvent.RegisterHelper)helper).register(arg_0, arg_1)));
            event.register(ForgeRegistries.Keys.ITEMS, helper -> ClassicPipes.ITEMS.forEach((arg_0, arg_1) -> ((RegisterEvent.RegisterHelper)helper).register(arg_0, arg_1)));
            event.register(ForgeRegistries.Keys.SOUND_EVENTS, helper -> ClassicPipes.SOUNDS.forEach((arg_0, arg_1) -> ((RegisterEvent.RegisterHelper)helper).register(arg_0, arg_1)));
            event.register(Registries.CREATIVE_MODE_TAB, helper -> helper.register(ClassicPipes.PIPES_TAB_KEY, (Object)ClassicPipes.PIPES_TAB));
            event.register(Registries.DATA_COMPONENT_TYPE, helper -> helper.register(ClassicPipes.LABEL_COMPONENT_KEY, ClassicPipes.LABEL_COMPONENT));
            event.register(Registries.TRIGGER_TYPE, helper -> helper.register(MiscUtil.resourceLocation("request_item"), (Object)ClassicPipes.REQUEST_ITEM_TRIGGER));
            event.register(ForgeRegistries.Keys.BLOCK_ENTITY_TYPES, helper -> {
                helper.register("basic_pipe", ClassicPipes.BASIC_PIPE_ENTITY);
                helper.register("golden_pipe", ClassicPipes.GOLDEN_PIPE_ENTITY);
                helper.register("copper_pipe", ClassicPipes.COPPER_PIPE_ENTITY);
                helper.register("iron_pipe", ClassicPipes.IRON_PIPE_ENTITY);
                helper.register("diamond_pipe", ClassicPipes.DIAMOND_PIPE_ENTITY);
                helper.register("flint_pipe", ClassicPipes.FLINT_PIPE_ENTITY);
                helper.register("lapis_pipe", ClassicPipes.LAPIS_PIPE_ENTITY);
                helper.register("obsidian_pipe", ClassicPipes.OBSIDIAN_PIPE_ENTITY);
                helper.register("bone_pipe", ClassicPipes.BONE_PIPE_ENTITY);
                helper.register("routing_pipe", ClassicPipes.ROUTING_PIPE_ENTITY);
                helper.register("provider_pipe", ClassicPipes.PROVIDER_PIPE_ENTITY);
                helper.register("request_pipe", ClassicPipes.REQUEST_PIPE_ENTITY);
                helper.register("stocking_pipe", ClassicPipes.STOCKING_PIPE_ENTITY);
                helper.register("matching_pipe", ClassicPipes.MATCHING_PIPE_ENTITY);
                helper.register("storage_pipe", ClassicPipes.STORAGE_PIPE_ENTITY);
                helper.register("recipe_pipe", ClassicPipes.RECIPE_PIPE_ENTITY);
                helper.register("fluid_pipe", ClassicPipes.FLUID_PIPE_ENTITY);
                helper.register("copper_fluid_pipe", ClassicPipes.COPPER_FLUID_PIPE_ENTITY);
                helper.register("iron_fluid_pipe", ClassicPipes.IRON_FLUID_PIPE_ENTITY);
                helper.register("lapis_fluid_pipe", ClassicPipes.LAPIS_FLUID_PIPE_ENTITY);
                helper.register("diamond_fluid_pipe", ClassicPipes.DIAMOND_FLUID_PIPE_ENTITY);
                helper.register("obsidian_fluid_pipe", ClassicPipes.OBSIDIAN_FLUID_PIPE_ENTITY);
                helper.register("advanced_copper_pipe", ClassicPipes.ADVANCED_COPPER_PIPE_ENTITY);
                helper.register("advanced_copper_fluid_pipe", ClassicPipes.ADVANCED_COPPER_FLUID_PIPE_ENTITY);
            });
            event.register(ForgeRegistries.Keys.MENU_TYPES, helper -> {
                helper.register("diamond_pipe", ClassicPipes.DIAMOND_PIPE_MENU);
                helper.register("routing_pipe", ClassicPipes.ROUTING_PIPE_MENU);
                helper.register("provider_pipe", ClassicPipes.PROVIDER_PIPE_MENU);
                helper.register("request", ClassicPipes.REQUEST_MENU);
                helper.register("stocking_pipe", ClassicPipes.STOCKING_PIPE_MENU);
                helper.register("matching_pipe", ClassicPipes.MATCHING_PIPE_MENU);
                helper.register("storage_pipe", ClassicPipes.STORAGE_PIPE_MENU);
                helper.register("recipe_pipe", ClassicPipes.RECIPE_PIPE_MENU);
                helper.register("diamond_fluid_pipe", ClassicPipes.DIAMOND_FLUID_PIPE_MENU);
                helper.register("advanced_copper_pipe", ClassicPipes.ADVANCED_COPPER_PIPE_MENU);
                helper.register("advanced_copper_fluid_pipe", ClassicPipes.ADVANCED_COPPER_FLUID_PIPE_MENU);
            });
        }

        @SubscribeEvent
        public static void onCommonSetup(FMLCommonSetupEvent event) {
            event.enqueueWork(() -> {
                ForgePacketHandler.registerServerPayload(ServerBoundMatchComponentsPayload.class, ServerBoundMatchComponentsPayload.STREAM_CODEC);
                ForgePacketHandler.registerServerPayload(ServerBoundDefaultRoutePayload.class, ServerBoundDefaultRoutePayload.STREAM_CODEC);
                ForgePacketHandler.registerServerPayload(ServerBoundLeaveOnePayload.class, ServerBoundLeaveOnePayload.STREAM_CODEC);
                ForgePacketHandler.registerServerPayload(ServerBoundSortingModePayload.class, ServerBoundSortingModePayload.STREAM_CODEC);
                ForgePacketHandler.registerServerPayload(ServerBoundRequestPayload.class, ServerBoundRequestPayload.STREAM_CODEC);
                ForgePacketHandler.registerServerPayload(ServerBoundActiveStockingPayload.class, ServerBoundActiveStockingPayload.STREAM_CODEC);
                ForgePacketHandler.registerServerPayload(ServerBoundSlotDirectionPayload.class, ServerBoundSlotDirectionPayload.STREAM_CODEC);
                ForgePacketHandler.registerServerPayload(ServerBoundTransferRecipePayload.class, ServerBoundTransferRecipePayload.STREAM_CODEC);
                ForgePacketHandler.registerServerPayload(ServerBoundSetFilterPayload.class, ServerBoundSetFilterPayload.STREAM_CODEC);
                ForgePacketHandler.registerClientPayload(ClientBoundItemListPayload.class, ClientBoundItemListPayload.STREAM_CODEC);
            });
        }
    }
}

