/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.blockentity;

import jagm.classicpipes.ClassicPipes;
import jagm.classicpipes.block.StockingPipeBlock;
import jagm.classicpipes.blockentity.NetworkedPipeEntity;
import jagm.classicpipes.inventory.container.FilterContainer;
import jagm.classicpipes.inventory.menu.StockingPipeMenu;
import jagm.classicpipes.services.Services;
import jagm.classicpipes.util.FacingOrNone;
import jagm.classicpipes.util.ItemInPipe;
import jagm.classicpipes.util.RequestedItem;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.ItemStackWithSlot;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class StockingPipeEntity
extends NetworkedPipeEntity
implements MenuProvider {
    private final FilterContainer filter = new FilterContainer(this, 9, true);
    private boolean activeStocking = false;
    private final List<ItemStack> missingItemsCache = new ArrayList<ItemStack>();
    private boolean cacheInitialised = false;

    public StockingPipeEntity(BlockPos pos, BlockState state) {
        super(ClassicPipes.STOCKING_PIPE_ENTITY, pos, state);
    }

    @Override
    public void tickServer(ServerLevel level, BlockPos pos, BlockState state) {
        super.tickServer(level, pos, state);
        if (!this.cacheInitialised) {
            this.updateCache(level);
            this.cacheInitialised = true;
        }
    }

    public void updateCache(ServerLevel level) {
        this.missingItemsCache.clear();
        Direction facing = ((FacingOrNone)((Object)this.getBlockState().getValue((Property)StockingPipeBlock.FACING))).getDirection();
        if (facing != null) {
            ArrayList<ItemStack> filterItems = new ArrayList<ItemStack>();
            Iterator iterator = this.filter.iterator();
            while (iterator.hasNext()) {
                ItemStack stack = (ItemStack)iterator.next();
                if (stack.isEmpty()) continue;
                boolean matched = false;
                for (ItemStack filterStack : filterItems) {
                    if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)filterStack)) continue;
                    filterStack.grow(stack.getCount());
                    matched = true;
                    break;
                }
                if (matched) continue;
                filterItems.add(stack.copy());
            }
            if (!filterItems.isEmpty()) {
                List<ItemStack> containerItems = Services.LOADER_SERVICE.getContainerItems(level, this.getBlockPos().relative(facing), facing.getOpposite());
                for (ItemStack filterStack : filterItems) {
                    boolean matched = false;
                    for (ItemStack containerStack : containerItems) {
                        if (!ItemStack.isSameItemSameComponents((ItemStack)filterStack, (ItemStack)containerStack)) continue;
                        matched = true;
                        int missing = filterStack.getCount() - containerStack.getCount();
                        if (missing <= 0) break;
                        this.missingItemsCache.add(containerStack.copyWithCount(missing));
                        break;
                    }
                    if (matched) continue;
                    this.missingItemsCache.add(filterStack);
                }
            }
        }
        if (this.activeStocking) {
            this.tryRequests(level);
        }
    }

    public void updateCache() {
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.updateCache(serverLevel);
        }
    }

    public void tryRequests(ServerLevel level) {
        if (this.hasNetwork()) {
            for (ItemStack stack : this.missingItemsCache) {
                int alreadyRequested = 0;
                for (ItemInPipe item : this.contents) {
                    if (!ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)item.getStack())) continue;
                    alreadyRequested += item.getStack().getCount();
                }
                for (RequestedItem requestedItem : this.getNetwork().getRequestedItems()) {
                    if (!requestedItem.matches(stack) || !requestedItem.getDestination().equals((Object)this.getBlockPos())) continue;
                    alreadyRequested += requestedItem.getAmountRemaining();
                }
                if (alreadyRequested >= stack.getCount()) continue;
                this.getNetwork().request(level, stack.copyWithCount(stack.getCount() - alreadyRequested), this.getBlockPos(), null, true);
            }
        }
    }

    public boolean isActiveStocking() {
        return this.activeStocking;
    }

    public void setActiveStocking(boolean activeStocking) {
        Level level;
        this.activeStocking = activeStocking;
        if (activeStocking && (level = this.getLevel()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.tryRequests(serverLevel);
        }
    }

    public boolean shouldMatchComponents() {
        return this.filter.shouldMatchComponents();
    }

    public List<ItemStack> getMissingItemsCache() {
        return this.missingItemsCache;
    }

    @Override
    protected void loadAdditional(ValueInput valueInput) {
        this.filter.clearContent();
        super.loadAdditional(valueInput);
        ValueInput.TypedInputList filterList = valueInput.listOrEmpty("filter", ItemStackWithSlot.CODEC);
        for (ItemStackWithSlot slotStack : filterList) {
            this.filter.setItem(slotStack.slot(), slotStack.stack());
        }
        this.filter.setMatchComponents(valueInput.getBooleanOr("match_components", true));
        this.activeStocking = valueInput.getBooleanOr("active_stocking", false);
    }

    @Override
    protected void saveAdditional(ValueOutput valueOutput) {
        super.saveAdditional(valueOutput);
        ValueOutput.TypedOutputList filterList = valueOutput.list("filter", ItemStackWithSlot.CODEC);
        for (int slot = 0; slot < this.filter.getContainerSize(); ++slot) {
            ItemStack stack = this.filter.getItem(slot);
            if (stack.isEmpty()) continue;
            filterList.add((Object)new ItemStackWithSlot(slot, stack));
        }
        valueOutput.putBoolean("match_components", this.filter.shouldMatchComponents());
        valueOutput.putBoolean("active_stocking", this.activeStocking);
    }

    public Component getDisplayName() {
        return Component.translatable((String)"container.classicpipes.stocking_pipe");
    }

    public AbstractContainerMenu createMenu(int id, Inventory playerInventory, Player player) {
        return new StockingPipeMenu(id, playerInventory, this.filter, this.activeStocking);
    }
}

