/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import jagm.classicpipes.blockentity.RecipePipeEntity;
import jagm.classicpipes.client.renderer.PipeRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionfc;

public class RecipePipeRenderer
implements BlockEntityRenderer<RecipePipeEntity> {
    private final BlockEntityRendererProvider.Context context;

    public RecipePipeRenderer(BlockEntityRendererProvider.Context context) {
        this.context = context;
    }

    public void render(RecipePipeEntity pipe, float partialTicks, PoseStack poses, MultiBufferSource bufferSource, int light, int overlay, Vec3 cameraPos) {
        PipeRenderer.renderPipeItems(this.context, pipe, partialTicks, poses, bufferSource, light, overlay);
        NonNullList<ItemStack> heldItems = pipe.getHeldItems();
        for (int i = 0; i < heldItems.size(); ++i) {
            ItemStack stack = (ItemStack)heldItems.get(i);
            if (stack.isEmpty() || pipe.getLevel() == null) continue;
            int a = i;
            float xOff = a % 2 == 0 ? 0.05f : -0.05f;
            float zOff = (a /= 2) % 2 == 0 ? 0.05f : -0.05f;
            float yOff = (a /= 2) % 2 == 0 ? 0.05f : -0.05f;
            poses.pushPose();
            poses.translate(0.5f + xOff, 0.5f + yOff, 0.5f + zOff);
            poses.scale(0.4375f, 0.4375f, 0.4375f);
            poses.mulPose((Quaternionfc)Axis.YP.rotation(((float)((pipe.getLevel().getGameTime() + (long)(i * 8)) % 80L) + partialTicks) * 2.0f * (float)Math.PI / 80.0f));
            this.context.getItemRenderer().renderStatic(stack, ItemDisplayContext.FIXED, light, overlay, poses, bufferSource, pipe.getLevel(), 0);
            poses.popPose();
        }
    }
}

