/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.client.renderer;

import jagm.classicpipes.block.FluidPipeBlock;
import jagm.classicpipes.blockentity.FluidPipeEntity;
import jagm.classicpipes.client.renderer.FluidRenderInfo;
import jagm.classicpipes.services.Services;
import java.util.Arrays;
import net.minecraft.class_1058;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_2246;
import net.minecraft.class_2350;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_827;
import org.joml.Matrix4f;

public class FluidPipeRenderer
implements class_827<FluidPipeEntity> {
    private final class_5614.class_5615 context;

    public FluidPipeRenderer(class_5614.class_5615 context) {
        this.context = context;
    }

    public void render(FluidPipeEntity pipe, float partialTicks, class_4587 poses, class_4597 bufferSource, int light, int overlay) {
        poses.method_22903();
        Matrix4f matrix = poses.method_23760().method_23761();
        FluidRenderInfo info = Services.LOADER_SERVICE.getFluidRenderInfo(pipe.getFluid().method_15785(), (class_1920)pipe.method_10997(), pipe.method_11016());
        class_1058 fluidSprite = info.sprite();
        if (fluidSprite == null) {
            fluidSprite = class_310.method_1551().method_1541().method_3351().method_3339(class_2246.field_10382.method_9564());
        }
        class_4588 vertexBuffer = bufferSource.getBuffer(class_1921.method_23028((class_2960)fluidSprite.method_45852()));
        float width = pipe.lastRenderWidth + (pipe.targetRenderWidth - pipe.lastRenderWidth) * partialTicks;
        if (width > 0.01f) {
            float start = 0.5f - width / 2.0f;
            float end = 0.5f + width / 2.0f;
            boolean renderMiddle = false;
            block8: for (class_2350 direction : class_2350.values()) {
                if (pipe.skipRenderingSide[direction.method_10146()] || !((Boolean)pipe.method_11010().method_11654((class_2769)FluidPipeBlock.PROPERTY_BY_DIRECTION.get(direction))).booleanValue()) continue;
                renderMiddle = true;
                boolean[] renderSides = new boolean[6];
                Arrays.fill(renderSides, true);
                renderSides[direction.method_10153().method_10146()] = false;
                switch (direction) {
                    case field_11036: {
                        this.renderFluidCuboid(vertexBuffer, matrix, start, end, start, end, 1.0f, end, fluidSprite, info.tint(), light, renderSides);
                        continue block8;
                    }
                    case field_11033: {
                        this.renderFluidCuboid(vertexBuffer, matrix, start, 0.0f, start, end, start, end, fluidSprite, info.tint(), light, renderSides);
                        continue block8;
                    }
                    case field_11034: {
                        this.renderFluidCuboid(vertexBuffer, matrix, end, start, start, 1.0f, end, end, fluidSprite, info.tint(), light, renderSides);
                        continue block8;
                    }
                    case field_11039: {
                        this.renderFluidCuboid(vertexBuffer, matrix, 0.0f, start, start, start, end, end, fluidSprite, info.tint(), light, renderSides);
                        continue block8;
                    }
                    case field_11035: {
                        this.renderFluidCuboid(vertexBuffer, matrix, start, start, end, end, end, 1.0f, fluidSprite, info.tint(), light, renderSides);
                        continue block8;
                    }
                    case field_11043: {
                        this.renderFluidCuboid(vertexBuffer, matrix, start, start, 0.0f, end, end, start, fluidSprite, info.tint(), light, renderSides);
                    }
                }
            }
            if (renderMiddle) {
                this.renderFluidCuboid(vertexBuffer, matrix, start, start, start, end, end, end, fluidSprite, info.tint(), light, pipe.skipRenderingSide);
            }
        }
        poses.method_22909();
    }

    public void renderFluidCuboid(class_4588 vertexBuffer, Matrix4f matrix, float x1, float y1, float z1, float x2, float y2, float z2, class_1058 fluidSprite, int tint, int light, boolean[] renderSide) {
        float u1 = fluidSprite.method_4580((double)(x1 * 16.0f));
        float u2 = fluidSprite.method_4580((double)(x2 * 16.0f));
        float v1 = fluidSprite.method_4570((double)(z1 * 16.0f));
        float v2 = fluidSprite.method_4570((double)(z2 * 16.0f));
        if (renderSide[class_2350.field_11033.method_10146()]) {
            vertexBuffer.method_22918(matrix, x1, y1, z2).method_39415(tint).method_22913(u1, v2).method_22916(light).method_1344();
            vertexBuffer.method_22918(matrix, x1, y1, z1).method_39415(tint).method_22913(u1, v1).method_22916(light).method_1344();
            vertexBuffer.method_22918(matrix, x2, y1, z1).method_39415(tint).method_22913(u2, v1).method_22916(light).method_1344();
            vertexBuffer.method_22918(matrix, x2, y1, z2).method_39415(tint).method_22913(u2, v2).method_22916(light).method_1344();
        }
        if (renderSide[class_2350.field_11036.method_10146()]) {
            vertexBuffer.method_22918(matrix, x1, y2, z1).method_39415(tint).method_22913(u1, v2).method_22916(light).method_1344();
            vertexBuffer.method_22918(matrix, x1, y2, z2).method_39415(tint).method_22913(u1, v1).method_22916(light).method_1344();
            vertexBuffer.method_22918(matrix, x2, y2, z2).method_39415(tint).method_22913(u2, v1).method_22916(light).method_1344();
            vertexBuffer.method_22918(matrix, x2, y2, z1).method_39415(tint).method_22913(u2, v2).method_22916(light).method_1344();
        }
        u1 = fluidSprite.method_4580((double)(y1 * 16.0f));
        u2 = fluidSprite.method_4580((double)(y2 * 16.0f));
        v1 = fluidSprite.method_4570((double)(z1 * 16.0f));
        v2 = fluidSprite.method_4570((double)(z2 * 16.0f));
        if (renderSide[class_2350.field_11039.method_10146()]) {
            vertexBuffer.method_22918(matrix, x1, y2, z2).method_39415(tint).method_22913(u1, v2).method_22916(light).method_1344();
            vertexBuffer.method_22918(matrix, x1, y2, z1).method_39415(tint).method_22913(u1, v1).method_22916(light).method_1344();
            vertexBuffer.method_22918(matrix, x1, y1, z1).method_39415(tint).method_22913(u2, v1).method_22916(light).method_1344();
            vertexBuffer.method_22918(matrix, x1, y1, z2).method_39415(tint).method_22913(u2, v2).method_22916(light).method_1344();
        }
        if (renderSide[class_2350.field_11034.method_10146()]) {
            vertexBuffer.method_22918(matrix, x2, y2, z1).method_39415(tint).method_22913(u1, v2).method_22916(light).method_1344();
            vertexBuffer.method_22918(matrix, x2, y2, z2).method_39415(tint).method_22913(u1, v1).method_22916(light).method_1344();
            vertexBuffer.method_22918(matrix, x2, y1, z2).method_39415(tint).method_22913(u2, v1).method_22916(light).method_1344();
            vertexBuffer.method_22918(matrix, x2, y1, z1).method_39415(tint).method_22913(u2, v2).method_22916(light).method_1344();
        }
        u1 = fluidSprite.method_4580((double)(y1 * 16.0f));
        u2 = fluidSprite.method_4580((double)(y2 * 16.0f));
        v1 = fluidSprite.method_4570((double)(x1 * 16.0f));
        v2 = fluidSprite.method_4570((double)(x2 * 16.0f));
        if (renderSide[class_2350.field_11043.method_10146()]) {
            vertexBuffer.method_22918(matrix, x1, y2, z1).method_39415(tint).method_22913(u1, v2).method_22916(light).method_1344();
            vertexBuffer.method_22918(matrix, x2, y2, z1).method_39415(tint).method_22913(u1, v1).method_22916(light).method_1344();
            vertexBuffer.method_22918(matrix, x2, y1, z1).method_39415(tint).method_22913(u2, v1).method_22916(light).method_1344();
            vertexBuffer.method_22918(matrix, x1, y1, z1).method_39415(tint).method_22913(u2, v2).method_22916(light).method_1344();
        }
        if (renderSide[class_2350.field_11035.method_10146()]) {
            vertexBuffer.method_22918(matrix, x2, y2, z2).method_39415(tint).method_22913(u1, v2).method_22916(light).method_1344();
            vertexBuffer.method_22918(matrix, x1, y2, z2).method_39415(tint).method_22913(u1, v1).method_22916(light).method_1344();
            vertexBuffer.method_22918(matrix, x1, y1, z2).method_39415(tint).method_22913(u2, v1).method_22916(light).method_1344();
            vertexBuffer.method_22918(matrix, x2, y1, z2).method_39415(tint).method_22913(u2, v2).method_22916(light).method_1344();
        }
    }
}

