/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.util;

import jagm.classicpipes.ClassicPipes;
import jagm.classicpipes.blockentity.MatchingPipe;
import jagm.classicpipes.blockentity.NetworkedPipeEntity;
import jagm.classicpipes.blockentity.ProviderPipe;
import jagm.classicpipes.blockentity.RecipePipeEntity;
import jagm.classicpipes.blockentity.RoutingPipeEntity;
import jagm.classicpipes.blockentity.StockingPipeEntity;
import jagm.classicpipes.inventory.menu.RequestMenu;
import jagm.classicpipes.network.ClientBoundItemListPayload;
import jagm.classicpipes.services.Services;
import jagm.classicpipes.util.RequestState;
import jagm.classicpipes.util.RequestedItem;
import jagm.classicpipes.util.SortingMode;
import jagm.classicpipes.util.Tuple;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class PipeNetwork {
    private static final byte DEFAULT_COOLDOWN = 40;
    private final class_2338 pos;
    private final Set<RoutingPipeEntity> routingPipes = new HashSet<RoutingPipeEntity>();
    private final Set<NetworkedPipeEntity> defaultRoutes = new HashSet<NetworkedPipeEntity>();
    private final Set<ProviderPipe> providerPipes = new LinkedHashSet<ProviderPipe>();
    private final Set<StockingPipeEntity> stockingPipes = new HashSet<StockingPipeEntity>();
    private final Set<MatchingPipe> matchingPipes = new HashSet<MatchingPipe>();
    private final Set<RecipePipeEntity> recipePipes = new HashSet<RecipePipeEntity>();
    private SortingMode sortingMode;
    private boolean cacheChanged;
    private byte cacheCooldown;
    private final List<RequestedItem> requestedItems;

    public PipeNetwork(class_2338 pos, SortingMode sortingMode) {
        this.sortingMode = sortingMode;
        this.pos = pos;
        this.cacheChanged = false;
        this.cacheCooldown = 0;
        this.requestedItems = new ArrayList<RequestedItem>();
    }

    public PipeNetwork(class_2338 pos) {
        this(pos, SortingMode.AMOUNT_DESCENDING);
    }

    private Tuple<Integer, Boolean> amountCraftable(class_1799 stack, int requiredAmount, class_2338 requestPos, RequestState requestState, List<class_1799> itemsInThisBranch) {
        int amount = 0;
        boolean hasRecipe = false;
        int missingStacksSize = requestState.missingStacksSize();
        for (RecipePipeEntity recipePipe : this.recipePipes) {
            Object ingredientStack32;
            class_1799 resultStack = recipePipe.getResult();
            if (!class_1799.method_31577((class_1799)resultStack, (class_1799)stack)) continue;
            hasRecipe = true;
            requestState.reduceMissingStacks(missingStacksSize);
            List<class_1799> ingredients = recipePipe.getIngredientsCollated();
            int requiredCrafts = requiredAmount / resultStack.method_7947() + (requiredAmount % resultStack.method_7947() != 0 ? 1 : 0);
            boolean loopFound = false;
            for (class_1799 class_17992 : ingredients) {
                for (class_1799 branchStack : itemsInThisBranch) {
                    if (!class_1799.method_31577((class_1799)branchStack, (class_1799)class_17992)) continue;
                    missingStacksSize = requestState.missingStacksSize();
                    requestState.addMissingStack(class_17992.method_46651(class_17992.method_7947() * requiredCrafts));
                    loopFound = true;
                    break;
                }
                if (!loopFound) continue;
                break;
            }
            if (loopFound) continue;
            int possibleCrafts = requiredCrafts;
            for (Object ingredientStack32 : ingredients) {
                ArrayList<class_1799> newBranchItems = new ArrayList<class_1799>(itemsInThisBranch);
                newBranchItems.add((class_1799)ingredientStack32);
                RequestState backupState = requestState.copy();
                int requiredIngredientAmount = ingredientStack32.method_7947() * requiredCrafts;
                int ingredientAmount = this.availableAmount(ingredientStack32.method_46651(requiredIngredientAmount), recipePipe.method_11016(), requestState, newBranchItems);
                possibleCrafts = Math.min(possibleCrafts, ingredientAmount / ingredientStack32.method_7947());
                requestState.restore(backupState);
            }
            if (possibleCrafts <= 0) continue;
            int n = requestState.missingStacksSize();
            ingredientStack32 = ingredients.iterator();
            while (ingredientStack32.hasNext()) {
                class_1799 ingredientStack4 = (class_1799)ingredientStack32.next();
                ArrayList<class_1799> newBranchItems = new ArrayList<class_1799>(itemsInThisBranch);
                newBranchItems.add(ingredientStack4);
                int possibleIngredientAmount = ingredientStack4.method_7947() * possibleCrafts;
                this.availableAmount(ingredientStack4.method_46651(possibleIngredientAmount), recipePipe.method_11016(), requestState, newBranchItems);
            }
            requestState.reduceMissingStacks(n);
            int amountToDeliver = Math.min(resultStack.method_7947() * possibleCrafts, requiredAmount);
            amount += amountToDeliver;
            requestState.scheduleItemRouting(requestPos, resultStack.method_46651(amountToDeliver));
            missingStacksSize = requestState.missingStacksSize();
            requestState.addCraftedItem(resultStack);
            if ((requiredAmount -= resultStack.method_7947() * possibleCrafts) > 0) continue;
            if (requiredAmount >= 0) break;
            requestState.addSpareStack(stack.method_46651(-requiredAmount));
            break;
        }
        return new Tuple<Integer, Boolean>(amount, hasRecipe);
    }

    private int amountInNetwork(class_1799 stack, class_2338 requestPos, RequestState requestState) {
        int amount = 0;
        for (class_1799 spareStack : requestState.getSpareStacks()) {
            if (!class_1799.method_31577((class_1799)spareStack, (class_1799)stack)) continue;
            int spareAmount = Math.min(spareStack.method_7947(), stack.method_7947());
            if (spareAmount <= 0) break;
            amount += spareAmount;
            spareStack.method_7934(spareAmount);
            requestState.scheduleItemRouting(requestPos, stack.method_46651(spareAmount));
            break;
        }
        requestState.getSpareStacks().removeIf(class_1799::method_7960);
        if (amount < stack.method_7947()) {
            for (ProviderPipe providerPipe : this.providerPipes) {
                for (class_1799 cacheStack : providerPipe.getCache()) {
                    if (!class_1799.method_31577((class_1799)cacheStack, (class_1799)stack)) continue;
                    int amountProvidable = Math.min(stack.method_7947() - amount, cacheStack.method_7947() - requestState.amountAlreadyWithdrawing(providerPipe, stack));
                    if (amountProvidable <= 0) break;
                    amount += amountProvidable;
                    requestState.scheduleItemWithdrawal(providerPipe, stack.method_46651(amountProvidable));
                    requestState.scheduleItemRouting(requestPos, stack.method_46651(amountProvidable));
                    break;
                }
                if (amount < stack.method_7947()) continue;
                break;
            }
        }
        return amount;
    }

    private int availableAmount(class_1799 stack, class_2338 requestPos, RequestState requestState, List<class_1799> itemsInThisBranch) {
        int amount = this.amountInNetwork(stack, requestPos, requestState);
        if (amount < stack.method_7947()) {
            Tuple<Integer, Boolean> tuple = this.amountCraftable(stack, stack.method_7947() - amount, requestPos, requestState, itemsInThisBranch);
            amount += tuple.a().intValue();
            if (!tuple.b().booleanValue()) {
                requestState.addMissingStack(stack.method_46651(stack.method_7947() - amount));
            }
        }
        return amount;
    }

    public void request(class_3218 level, class_1799 stack, class_2338 requestPos, class_1657 player, boolean partialRequests) {
        RequestState requestState = new RequestState();
        int amount = this.availableAmount(stack, requestPos, requestState, new ArrayList<class_1799>());
        if (amount < stack.method_7947()) {
            if (partialRequests) {
                this.request(level, stack.method_46651(amount), requestPos, player, false);
            } else if (player != null) {
                player.method_7353((class_2561)class_2561.method_43469((String)"chat.classicpipes.missing_item.a", (Object[])new Object[]{stack.method_7947(), stack.method_7909().method_7848()}).method_27692(class_124.field_1061), false);
                for (class_1799 missingStack : requestState.collateMissingStacks()) {
                    player.method_7353((class_2561)class_2561.method_43469((String)"chat.classicpipes.missing_item.b", (Object[])new Object[]{missingStack.method_7947(), missingStack.method_7909().method_7848()}).method_27692(class_124.field_1054), false);
                }
            }
        } else {
            String playerName = player != null ? player.method_5477().getString() : "";
            int requestedItemsSize = this.requestedItems.size();
            for (Map.Entry<class_2338, List<class_1799>> entry : requestState.getItemsToRoute().entrySet()) {
                for (class_1799 routeStack : entry.getValue()) {
                    this.requestedItems.add(new RequestedItem(routeStack, entry.getKey(), playerName));
                }
            }
            boolean success = true;
            for (Map.Entry<ProviderPipe, List<class_1799>> entry : requestState.getItemsToWithdraw().entrySet()) {
                for (class_1799 withdrawStack : entry.getValue()) {
                    boolean withdrawalSuccessful = false;
                    for (class_1799 cacheStack : entry.getKey().getCache()) {
                        if (!class_1799.method_31577((class_1799)cacheStack, (class_1799)withdrawStack)) continue;
                        int amountToExtract = Math.min(cacheStack.method_7947(), withdrawStack.method_7947());
                        withdrawalSuccessful = entry.getKey().extractItem(level, cacheStack.method_46651(amountToExtract));
                        break;
                    }
                    if (withdrawalSuccessful) continue;
                    success = false;
                    while (this.requestedItems.size() > requestedItemsSize) {
                        this.requestedItems.remove(this.requestedItems.size() - 1);
                    }
                    if (player == null) break;
                    player.method_7353((class_2561)class_2561.method_43469((String)"chat.classicpipes.could_not_extract", (Object[])new Object[]{stack.method_7947(), stack.method_7909().method_7848(), entry.getKey().getProviderPipePos().method_23854()}).method_27692(class_124.field_1061), false);
                    break;
                }
                if (success) continue;
                break;
            }
            if (success && player != null) {
                player.method_7339(ClassicPipes.ITEMS_REQUESTED_STAT, stack.method_7947());
                ClassicPipes.REQUEST_ITEM_TRIGGER.trigger((class_3222)player, stack, requestState.getUniqueCrafts());
                player.method_7353((class_2561)class_2561.method_43469((String)"chat.classicpipes.requested", (Object[])new Object[]{stack.method_7947(), stack.method_7909().method_7848()}).method_27692(class_124.field_1060), false);
            }
        }
    }

    public void tick(class_3218 level) {
        int updatablePipesCount = this.providerPipes.size() + this.matchingPipes.size() + this.stockingPipes.size();
        int pipeToUpdate = level.method_8409().method_43048(Math.max(100, updatablePipesCount));
        if (pipeToUpdate < this.providerPipes.size()) {
            i = 0;
            for (ProviderPipe providerPipe : this.providerPipes) {
                if (i == pipeToUpdate) {
                    class_2350 facing = providerPipe.getFacing();
                    if (facing == null) break;
                    providerPipe.updateCache();
                    break;
                }
                ++i;
            }
        } else if (pipeToUpdate < this.providerPipes.size() + this.matchingPipes.size()) {
            i = 0;
            for (MatchingPipe matchingPipe : this.matchingPipes) {
                if (i == pipeToUpdate) {
                    matchingPipe.updateCache();
                    break;
                }
                ++i;
            }
        } else if (pipeToUpdate < updatablePipesCount) {
            i = 0;
            for (Object stockingPipe : this.stockingPipes) {
                if (i == pipeToUpdate) {
                    stockingPipe.updateCache();
                    break;
                }
                ++i;
            }
        }
        if (this.cacheChanged && this.cacheCooldown <= 0) {
            List playerList = level.method_18766(player -> {
                RequestMenu menu;
                class_1703 patt14801$temp = player.field_7512;
                return patt14801$temp instanceof RequestMenu && (menu = (RequestMenu)patt14801$temp).getNetworkPos().equals((Object)this.getPos());
            });
            if (!playerList.isEmpty()) {
                ClientBoundItemListPayload toSend = this.requestItemList(this.pos);
                for (class_3222 player2 : playerList) {
                    Services.LOADER_SERVICE.sendToClient(player2, toSend);
                }
            }
            for (Object stockingPipe : this.stockingPipes) {
                if (!stockingPipe.isActiveStocking()) continue;
                stockingPipe.tryRequests(level);
            }
            this.cacheChanged = false;
            this.cacheCooldown = (byte)40;
        } else if (this.cacheCooldown > 0) {
            this.cacheCooldown = (byte)(this.cacheCooldown - 1);
        }
        this.getRequestedItems().removeIf(requestedItem -> {
            if (requestedItem.timedOut()) {
                requestedItem.sendMessage(level, (class_2561)class_2561.method_43469((String)"chat.classicpipes.timed_out", (Object[])new Object[]{requestedItem.getAmountRemaining(), requestedItem.getStack().method_7909().method_7848()}).method_27692(class_124.field_1061));
                for (RecipePipeEntity craftingPipe : this.recipePipes) {
                    if (!requestedItem.matches(craftingPipe.getResult())) continue;
                    craftingPipe.dropHeldItems(level, craftingPipe.method_11016());
                }
                return true;
            }
            return false;
        });
    }

    public void resetRequests(class_3218 level) {
        this.requestedItems.clear();
        for (RecipePipeEntity craftingPipe : this.recipePipes) {
            craftingPipe.dropHeldItems(level, craftingPipe.method_11016());
        }
    }

    public Set<RoutingPipeEntity> getRoutingPipes() {
        return this.routingPipes;
    }

    public Set<NetworkedPipeEntity> getDefaultRoutes() {
        return this.defaultRoutes;
    }

    public Set<StockingPipeEntity> getStockingPipes() {
        return this.stockingPipes;
    }

    public Set<MatchingPipe> getMatchingPipes() {
        return this.matchingPipes;
    }

    public class_2338 getPos() {
        return this.pos;
    }

    public void addPipe(NetworkedPipeEntity pipe) {
        if (pipe.isDefaultRoute()) {
            this.defaultRoutes.add(pipe);
        }
        if (pipe instanceof RoutingPipeEntity) {
            RoutingPipeEntity routingPipe = (RoutingPipeEntity)pipe;
            this.routingPipes.add(routingPipe);
        }
        if (pipe instanceof ProviderPipe) {
            ProviderPipe providerPipe = (ProviderPipe)((Object)pipe);
            this.providerPipes.add(providerPipe);
        }
        if (pipe instanceof StockingPipeEntity) {
            StockingPipeEntity stockingPipe = (StockingPipeEntity)pipe;
            this.stockingPipes.add(stockingPipe);
        }
        if (pipe instanceof MatchingPipe) {
            MatchingPipe matchingPipe = (MatchingPipe)((Object)pipe);
            this.matchingPipes.add(matchingPipe);
        }
        if (pipe instanceof RecipePipeEntity) {
            RecipePipeEntity recipePipe = (RecipePipeEntity)pipe;
            this.recipePipes.add(recipePipe);
        }
    }

    public void removePipe(class_3218 level, NetworkedPipeEntity pipe) {
        if (pipe.isDefaultRoute()) {
            this.defaultRoutes.remove((Object)pipe);
        }
        if (pipe instanceof RoutingPipeEntity) {
            RoutingPipeEntity routingPipe = (RoutingPipeEntity)pipe;
            this.routingPipes.remove((Object)routingPipe);
        }
        if (pipe instanceof ProviderPipe) {
            ProviderPipe providerPipe = (ProviderPipe)((Object)pipe);
            this.providerPipes.remove(providerPipe);
        }
        if (pipe instanceof StockingPipeEntity) {
            StockingPipeEntity stockingPipe = (StockingPipeEntity)pipe;
            this.stockingPipes.remove((Object)stockingPipe);
        }
        if (pipe instanceof MatchingPipe) {
            MatchingPipe matchingPipe = (MatchingPipe)((Object)pipe);
            this.matchingPipes.remove(matchingPipe);
        }
        if (pipe instanceof RecipePipeEntity) {
            RecipePipeEntity recipePipe = (RecipePipeEntity)pipe;
            this.recipePipes.remove((Object)recipePipe);
        }
        this.requestedItems.removeIf(requestedItem -> {
            if (requestedItem.getDestination().equals((Object)pipe.method_11016())) {
                requestedItem.sendMessage(level, (class_2561)class_2561.method_43469((String)"chat.classicpipes.destination_removed", (Object[])new Object[]{requestedItem.getAmountRemaining(), requestedItem.getStack().method_7909().method_7848(), pipe.method_11016().method_23854()}).method_27692(class_124.field_1061));
                return true;
            }
            return false;
        });
    }

    public ClientBoundItemListPayload requestItemList(class_2338 requestPos) {
        ArrayList<class_1799> existingItems = new ArrayList<class_1799>();
        for (ProviderPipe providerPipe : this.providerPipes) {
            for (class_1799 stack : providerPipe.getCache()) {
                boolean alreadyThere = false;
                for (class_1799 inStack : existingItems) {
                    if (!class_1799.method_31577((class_1799)stack, (class_1799)inStack)) continue;
                    inStack.method_7933(stack.method_7947());
                    if (inStack.method_7947() < 0) {
                        inStack.method_7939(Integer.MAX_VALUE);
                    }
                    alreadyThere = true;
                    break;
                }
                if (alreadyThere) continue;
                existingItems.add(stack.method_7972());
            }
        }
        ArrayList<class_1799> craftableItems = new ArrayList<class_1799>();
        for (RecipePipeEntity recipePipe : this.recipePipes) {
            class_1799 result = recipePipe.getResult();
            if (result.method_7960()) continue;
            boolean matched = false;
            for (class_1799 alreadyCraftable : craftableItems) {
                if (!class_1799.method_31577((class_1799)alreadyCraftable, (class_1799)result)) continue;
                matched = true;
                break;
            }
            if (matched) continue;
            craftableItems.add(result.method_46651(1));
        }
        return new ClientBoundItemListPayload(existingItems, craftableItems, this.pos, requestPos, this.sortingMode);
    }

    public void cacheUpdated() {
        this.cacheChanged = true;
    }

    public void setSortingMode(SortingMode sortingMode) {
        this.sortingMode = sortingMode;
    }

    public SortingMode getSortingMode() {
        return this.sortingMode;
    }

    public List<RequestedItem> getRequestedItems() {
        return this.requestedItems;
    }

    public void removeRequestedItem(RequestedItem requestedItem) {
        this.requestedItems.remove(requestedItem);
    }

    public void addRequestedItem(RequestedItem requestedItem) {
        this.requestedItems.add(requestedItem);
    }
}

