/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.util;

import jagm.classicpipes.blockentity.ProviderPipe;
import jagm.classicpipes.util.MiscUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2338;

public class RequestState {
    private final Map<ProviderPipe, List<class_1799>> itemsToWithdraw;
    private final Map<class_2338, List<class_1799>> itemsToRoute;
    private final List<class_1799> missingStacks;
    private final Set<class_1792> uniqueCraftedItems;
    private final List<class_1799> spareStacks;

    public RequestState() {
        this.itemsToWithdraw = new HashMap<ProviderPipe, List<class_1799>>();
        this.itemsToRoute = new HashMap<class_2338, List<class_1799>>();
        this.missingStacks = new ArrayList<class_1799>();
        this.uniqueCraftedItems = new HashSet<class_1792>();
        this.spareStacks = new ArrayList<class_1799>();
    }

    private RequestState(Map<ProviderPipe, List<class_1799>> itemsToWithdraw, Map<class_2338, List<class_1799>> itemsToRoute, List<class_1799> missingStacks, Set<class_1792> uniqueCraftedItems, List<class_1799> spareStacks) {
        this.itemsToWithdraw = itemsToWithdraw;
        this.itemsToRoute = itemsToRoute;
        this.missingStacks = missingStacks;
        this.uniqueCraftedItems = uniqueCraftedItems;
        this.spareStacks = spareStacks;
    }

    public RequestState copy() {
        HashMap<ProviderPipe, List<class_1799>> copiedItemsToWithdraw = new HashMap<ProviderPipe, List<class_1799>>();
        for (Map.Entry<ProviderPipe, List<class_1799>> entry : this.itemsToWithdraw.entrySet()) {
            ArrayList arrayList = new ArrayList();
            entry.getValue().forEach(withdrawStack -> copiedWithdrawStacks.add(withdrawStack.method_7972()));
            copiedItemsToWithdraw.put(entry.getKey(), arrayList);
        }
        HashMap<class_2338, List<class_1799>> copiedItemsToRoute = new HashMap<class_2338, List<class_1799>>();
        for (Map.Entry<class_2338, List<class_1799>> entry : this.itemsToRoute.entrySet()) {
            ArrayList copiedRouteStacks = new ArrayList();
            entry.getValue().forEach(routeStack -> copiedRouteStacks.add(routeStack.method_7972()));
            copiedItemsToRoute.put(entry.getKey(), copiedRouteStacks);
        }
        ArrayList<class_1799> arrayList = new ArrayList<class_1799>();
        this.spareStacks.forEach(spareStack -> copiedSpareStacks.add(spareStack.method_7972()));
        return new RequestState(copiedItemsToWithdraw, copiedItemsToRoute, this.missingStacks, new HashSet<class_1792>(this.uniqueCraftedItems), arrayList);
    }

    public void restore(RequestState backupState) {
        this.itemsToWithdraw.clear();
        this.itemsToWithdraw.putAll(backupState.itemsToWithdraw);
        this.itemsToRoute.clear();
        this.itemsToRoute.putAll(backupState.itemsToRoute);
        this.uniqueCraftedItems.clear();
        this.uniqueCraftedItems.addAll(backupState.uniqueCraftedItems);
        this.spareStacks.clear();
        this.spareStacks.addAll(backupState.spareStacks);
    }

    public int amountAlreadyWithdrawing(ProviderPipe providerPipe, class_1799 stack) {
        int amount = 0;
        if (this.itemsToWithdraw.containsKey(providerPipe)) {
            for (class_1799 withdrawStack : this.itemsToWithdraw.get(providerPipe)) {
                if (!class_1799.method_31577((class_1799)withdrawStack, (class_1799)stack)) continue;
                amount += withdrawStack.method_7947();
            }
        }
        return amount;
    }

    public void scheduleItemWithdrawal(ProviderPipe providerPipe, class_1799 stack) {
        if (this.itemsToWithdraw.containsKey(providerPipe)) {
            MiscUtil.mergeStackIntoList(this.itemsToWithdraw.get(providerPipe), stack);
        } else {
            ArrayList<class_1799> withdrawStacks = new ArrayList<class_1799>();
            withdrawStacks.add(stack);
            this.itemsToWithdraw.put(providerPipe, withdrawStacks);
        }
    }

    public void scheduleItemRouting(class_2338 requestPos, class_1799 stack) {
        boolean matched = false;
        for (class_2338 pos : this.itemsToRoute.keySet()) {
            if (!pos.equals((Object)requestPos)) continue;
            MiscUtil.mergeStackIntoList(this.itemsToRoute.get(pos), stack);
            matched = true;
            break;
        }
        if (!matched) {
            ArrayList<class_1799> stacksToRoute = new ArrayList<class_1799>();
            stacksToRoute.add(stack);
            this.itemsToRoute.put(requestPos, stacksToRoute);
        }
    }

    public void addMissingStack(class_1799 stack) {
        this.missingStacks.add(stack);
    }

    public int missingStacksSize() {
        return this.missingStacks.size();
    }

    public void reduceMissingStacks(int targetSize) {
        while (this.missingStacks.size() > targetSize) {
            this.missingStacks.remove(this.missingStacks.size() - 1);
        }
    }

    public List<class_1799> collateMissingStacks() {
        ArrayList<class_1799> collatedStacks = new ArrayList<class_1799>();
        for (class_1799 missingStack : this.missingStacks) {
            MiscUtil.mergeStackIntoList(collatedStacks, missingStack);
        }
        return collatedStacks;
    }

    public Map<class_2338, List<class_1799>> getItemsToRoute() {
        return this.itemsToRoute;
    }

    public Map<ProviderPipe, List<class_1799>> getItemsToWithdraw() {
        return this.itemsToWithdraw;
    }

    public void addCraftedItem(class_1799 stack) {
        this.uniqueCraftedItems.add(stack.method_7909());
    }

    public int getUniqueCrafts() {
        return this.uniqueCraftedItems.size();
    }

    public void addSpareStack(class_1799 stack) {
        MiscUtil.mergeStackIntoList(this.spareStacks, stack);
    }

    public List<class_1799> getSpareStacks() {
        return this.spareStacks;
    }
}

