/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import jagm.classicpipes.blockentity.NetworkedPipeEntity;
import jagm.classicpipes.util.ItemInPipe;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class RequestedItem {
    private static final short TIMEOUT = 24000;
    public static final Codec<RequestedItem> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_1799.field_24671.fieldOf("item").orElse((Object)class_1799.field_8037).forGetter(RequestedItem::getStack), (App)class_2338.field_25064.fieldOf("destination").orElse((Object)class_2338.field_10980).forGetter(RequestedItem::getDestination), (App)Codec.STRING.fieldOf("player").orElse((Object)"").forGetter(RequestedItem::getPlayerName)).apply((Applicative)instance, RequestedItem::new));
    private final class_1799 stack;
    private final class_2338 destination;
    private final String playerName;
    private short age;

    public RequestedItem(class_1799 stack, class_2338 destination, String playerName) {
        this.stack = stack;
        this.destination = destination;
        this.playerName = playerName;
        this.age = 0;
    }

    public void sendMessage(class_3218 level, class_2561 component) {
        List players = level.method_18766(player -> player.method_5477().getString().equals(this.playerName));
        if (!players.isEmpty()) {
            ((class_3222)players.get(0)).method_7353(component, false);
        }
    }

    public boolean matches(ItemInPipe pipeItem) {
        return this.matches(pipeItem.getStack());
    }

    public boolean matches(class_1799 stack) {
        return class_1799.method_31577((class_1799)stack, (class_1799)this.stack);
    }

    public boolean matches(RequestedItem anotherItem) {
        return this.playerName.equals(anotherItem.playerName) && this.destination.equals((Object)anotherItem.destination) && this.matches(anotherItem.stack);
    }

    public NetworkedPipeEntity getTarget(class_1937 level) {
        class_2586 target = level.method_8321(this.destination);
        if (target instanceof NetworkedPipeEntity) {
            return (NetworkedPipeEntity)target;
        }
        return null;
    }

    public int getAmountRemaining() {
        return this.stack.method_7947();
    }

    public void arrived(int amount) {
        this.age = 0;
        this.stack.method_7934(amount);
    }

    public boolean timedOut() {
        this.age = (short)(this.age + 1);
        return this.age > 24000;
    }

    public boolean isDelivered() {
        return this.stack.method_7947() <= 0;
    }

    public class_1799 getStack() {
        return this.stack;
    }

    public class_2338 getDestination() {
        return this.destination;
    }

    private String getPlayerName() {
        return this.playerName;
    }
}

