/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.block;

import jagm.classicpipes.block.FluidPipeBlock;
import jagm.classicpipes.blockentity.ItemPipeEntity;
import jagm.classicpipes.blockentity.PipeEntity;
import jagm.classicpipes.services.Services;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_10;
import net.minecraft.class_10225;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.minecraft.class_8923;

public abstract class PipeBlock
extends class_8923
implements class_3737,
class_2343 {
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    private final Function<class_2680, class_265> shapes;

    public PipeBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        Map map = class_259.method_66504((class_265)class_2248.method_66408((double)8.0, (double)0.0, (double)8.0));
        this.shapes = this.method_33615(state -> {
            class_265 shape = class_2248.method_66393((double)8.0);
            for (class_2350 direction : class_2350.values()) {
                if (!this.isPipeConnected((class_2680)state, direction)) continue;
                shape = class_259.method_1084((class_265)((class_265)map.get(direction)), (class_265)shape);
            }
            return shape;
        });
    }

    public abstract boolean isPipeConnected(class_2680 var1, class_2350 var2);

    public abstract class_2680 setPipeConnected(class_2680 var1, class_2350 var2, boolean var3);

    protected boolean canConnect(class_1937 level, class_2338 pipePos, class_2350 direction) {
        class_2338 neighbourPos = pipePos.method_10093(direction);
        class_2248 class_22482 = level.method_8320(neighbourPos).method_26204();
        if (class_22482 instanceof PipeBlock) {
            PipeBlock pipeBlock = (PipeBlock)class_22482;
            return PipeBlock.canConnectToPipeBothWays(this, pipeBlock);
        }
        return Services.LOADER_SERVICE.canAccessContainer(level, neighbourPos, direction.method_10153());
    }

    protected static boolean canConnectToPipeBothWays(PipeBlock pipe1, PipeBlock pipe2) {
        return pipe1.canConnectToPipe(pipe2) && pipe2.canConnectToPipe(pipe1);
    }

    protected boolean canConnectToPipe(PipeBlock pipeBlock) {
        return true;
    }

    public class_2680 method_9605(class_1750 context) {
        return (class_2680)this.method_9564().method_47968((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(context.method_8045().method_8316(context.method_8037()).method_39360((class_3611)class_3612.field_15910)));
    }

    protected class_2680 method_9559(class_2680 state, class_4538 level, class_10225 scheduledTickAccess, class_2338 pipePos, class_2350 direction, class_2338 neighborPos, class_2680 neighborState, class_5819 random) {
        class_2586 class_25862;
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            scheduledTickAccess.method_64312(pipePos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789(level));
        }
        boolean wasConnected = this.isPipeConnected(state, direction);
        boolean willConnect = this.canConnect((class_1937)level, pipePos, direction);
        class_2680 newState = this.setPipeConnected(state, direction, willConnect);
        if (wasConnected != willConnect && (class_25862 = level.method_8321(pipePos)) instanceof PipeEntity) {
            PipeEntity pipe = (PipeEntity)class_25862;
            if (level instanceof class_3218) {
                class_3218 serverLevel = (class_3218)level;
                pipe.update(serverLevel, newState, pipePos, direction, wasConnected);
            }
        }
        return newState;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{WATERLOGGED});
    }

    protected boolean method_9516(class_2680 state, class_10 pathComputationType) {
        return false;
    }

    protected class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    protected boolean method_9579(class_2680 state) {
        return false;
    }

    protected class_265 method_9530(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        return this.shapes.apply(state);
    }

    public class_2680 method_9576(class_1937 level, class_2338 pos, class_2680 state, class_1657 player) {
        class_3218 serverLevel;
        class_2586 blockEntity;
        if (!(this instanceof FluidPipeBlock) && level instanceof class_3218 && (blockEntity = (serverLevel = (class_3218)level).method_8321(pos)) instanceof ItemPipeEntity) {
            ItemPipeEntity pipe = (ItemPipeEntity)blockEntity;
            pipe.dropItems(serverLevel, pos);
        }
        return super.method_9576(level, pos, state, player);
    }

    protected boolean method_9498(class_2680 state) {
        return true;
    }

    protected int method_9572(class_2680 state, class_1937 level, class_2338 pos) {
        class_2586 blockEntity = level.method_8321(pos);
        if (blockEntity instanceof PipeEntity) {
            PipeEntity pipe = (PipeEntity)blockEntity;
            return pipe.getComparatorOutput();
        }
        return 0;
    }
}

