/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.inventory.menu;

import jagm.classicpipes.ClassicPipes;
import jagm.classicpipes.blockentity.NetworkedPipeEntity;
import jagm.classicpipes.inventory.container.RequestMenuContainer;
import jagm.classicpipes.inventory.menu.FilterSlot;
import jagm.classicpipes.network.ClientBoundItemListPayload;
import jagm.classicpipes.network.ServerBoundSortingModePayload;
import jagm.classicpipes.services.Services;
import jagm.classicpipes.util.MiscUtil;
import jagm.classicpipes.util.SortingMode;
import jagm.classicpipes.util.Tuple;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2586;
import net.minecraft.class_6862;

public class RequestMenu
extends class_1703 {
    private static final Pattern MOD_LOOKUP = Pattern.compile("@\\S+");
    private static final Pattern TAG_LOOKUP = Pattern.compile("#\\S+");
    private List<Tuple<class_1799, Boolean>> networkItems;
    private final class_1263 toDisplay;
    public final class_2371<class_1735> displaySlots = class_2371.method_10211();
    private final Map<class_1799, Boolean> craftableCache;
    private String search;
    private int page;
    private int maxPage;
    private SortingMode sortingMode;
    private final class_2338 networkPos;
    private final class_2338 requestPos;
    private final class_2586 controllerPipe;
    private final class_2586 requestPipe;

    public RequestMenu(int id, class_1661 inventory, ClientBoundItemListPayload payload) {
        super(ClassicPipes.REQUEST_MENU, id);
        this.networkItems = RequestMenu.buildNetworkItems(payload.existingItems(), payload.craftableItems());
        this.craftableCache = new HashMap<class_1799, Boolean>();
        this.networkPos = payload.networkPos();
        this.requestPos = payload.requestPos();
        this.sortingMode = payload.sortingMode();
        this.networkItems.sort(this.sortingMode.getComparator());
        this.toDisplay = new RequestMenuContainer();
        class_1937 level = inventory.field_7546.method_37908();
        this.controllerPipe = level.method_8321(this.networkPos);
        this.requestPipe = level.method_8321(this.requestPos);
        this.search = "";
        this.page = 0;
        this.maxPage = 0;
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.displaySlots.add((Object)new FilterSlot(this.toDisplay, i * 9 + j, 8 + j * 18, 36 + i * 18));
            }
        }
        this.updateSearch();
    }

    private static List<Tuple<class_1799, Boolean>> buildNetworkItems(List<class_1799> existingItems, List<class_1799> craftableItems) {
        ArrayList<Tuple<class_1799, Boolean>> networkItems = new ArrayList<Tuple<class_1799, Boolean>>();
        for (class_1799 craftable : craftableItems) {
            networkItems.add(new Tuple<class_1799, Boolean>(craftable, true));
        }
        int craftableCount = networkItems.size();
        for (class_1799 stack : existingItems) {
            boolean matched = false;
            for (int i = 0; i < craftableCount; ++i) {
                if (!class_1799.method_31577((class_1799)stack, (class_1799)((class_1799)((Tuple)networkItems.get(i)).a()))) continue;
                networkItems.set(i, new Tuple<class_1799, Boolean>(stack.method_46651(stack.method_7947() + 1), true));
                matched = true;
                break;
            }
            if (matched) continue;
            networkItems.add(new Tuple<class_1799, Boolean>(stack, false));
        }
        return networkItems;
    }

    public void update(List<class_1799> existingItems, List<class_1799> craftableItems) {
        this.networkItems = RequestMenu.buildNetworkItems(existingItems, craftableItems);
        this.update();
    }

    public void update() {
        this.networkItems.sort(this.sortingMode.getComparator());
        this.updateSearch();
    }

    public void updateSearch() {
        this.toDisplay.method_5448();
        this.craftableCache.clear();
        int display = this.toDisplay.method_5439();
        ArrayList<Tuple> matchingItems = new ArrayList<Tuple>();
        ListIterator<Tuple<class_1799, Boolean>> iterator = this.networkItems.listIterator();
        while (iterator.hasNext()) {
            Tuple tuple = (Tuple)iterator.next();
            if (((class_1799)tuple.a()).method_7960()) {
                iterator.remove();
                continue;
            }
            if (!this.search.isEmpty() && !RequestMenu.itemMatchesSearch((class_1799)tuple.a(), this.search)) continue;
            matchingItems.add(tuple);
        }
        this.maxPage = matchingItems.size() / display;
        if (this.page > this.maxPage) {
            this.page = this.maxPage;
        }
        int index = 0;
        for (Tuple tuple : matchingItems) {
            if (index >= (this.page + 1) * display) break;
            if (index >= this.page * display) {
                int slot = index % display;
                this.toDisplay.method_5447(slot, (class_1799)tuple.a());
                this.craftableCache.put((class_1799)tuple.a(), (Boolean)tuple.b());
            }
            ++index;
        }
    }

    public int getMaxPage() {
        return this.maxPage;
    }

    public class_1799 method_7601(class_1657 player, int index) {
        return class_1799.field_8037;
    }

    public boolean method_7597(class_1657 player) {
        class_2586 class_25862 = this.controllerPipe;
        if (class_25862 instanceof NetworkedPipeEntity) {
            NetworkedPipeEntity controller = (NetworkedPipeEntity)class_25862;
            class_25862 = this.requestPipe;
            if (class_25862 instanceof NetworkedPipeEntity) {
                NetworkedPipeEntity requester = (NetworkedPipeEntity)class_25862;
                return player.method_37908().method_8321(controller.method_11016()) == controller && class_1263.method_49105((class_2586)requester, (class_1657)player) && controller.isController() && controller.getNetwork() == requester.getNetwork();
            }
        }
        return false;
    }

    public String getSearch() {
        return this.search;
    }

    public SortingMode getSortingMode() {
        return this.sortingMode;
    }

    public void setSortingMode(SortingMode sortingMode) {
        this.sortingMode = sortingMode;
        Services.LOADER_SERVICE.sendToServer(new ServerBoundSortingModePayload(sortingMode));
        this.networkItems.sort(this.sortingMode.getComparator());
        this.updateSearch();
    }

    public void setSearch(String search) {
        this.search = search;
        this.updateSearch();
    }

    public void changePage(int increment) {
        this.page += increment;
        if (this.page < 0) {
            this.page = 0;
        } else if (this.page > this.maxPage) {
            this.page = this.maxPage;
        }
        this.updateSearch();
    }

    public int getPage() {
        return this.page;
    }

    public class_2338 getNetworkPos() {
        return this.networkPos;
    }

    public class_2338 getRequestPos() {
        return this.requestPos;
    }

    public boolean itemCraftable(class_1799 stack) {
        return this.craftableCache.get(stack);
    }

    private static boolean itemMatchesSearch(class_1799 stack, String search) {
        Matcher modMatcher = MOD_LOOKUP.matcher(search);
        if (modMatcher.find()) {
            String match = modMatcher.group();
            search = search.replace(match, "");
            String searchedMod = RequestMenu.normalise(match.replaceFirst("@", ""));
            String itemModID = MiscUtil.modFromItem(stack);
            String itemModName = RequestMenu.normalise(Services.LOADER_SERVICE.getModName(itemModID));
            if (!RequestMenu.normalise(itemModID).contains(searchedMod) && !itemModName.contains(searchedMod)) {
                return false;
            }
        }
        Matcher tagMatcher = TAG_LOOKUP.matcher(search);
        while (tagMatcher.find()) {
            boolean foundTag = false;
            String match = tagMatcher.group();
            search = search.replace(match, "");
            for (class_6862 tag : stack.method_40133().toList()) {
                String searchedTag = RequestMenu.normalise(match.replaceFirst("#", ""));
                String itemTag = RequestMenu.normalise(tag.comp_327().toString());
                if (!itemTag.contains(searchedTag)) continue;
                foundTag = true;
                break;
            }
            if (foundTag) continue;
            return false;
        }
        search = RequestMenu.normalise(search);
        String itemName = RequestMenu.normalise(stack.method_63693().getString());
        return itemName.contains(search);
    }

    private static String normalise(String s) {
        return s.toLowerCase().replaceAll("[^a-z0-9]", "");
    }
}

