/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.blockentity;

import jagm.classicpipes.block.PipeBlock;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_7225;

public abstract class PipeEntity
extends class_2586 {
    private final List<ScheduledPipeUpdate> updates = new ArrayList<ScheduledPipeUpdate>();

    public PipeEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public static <T extends class_2586> void tick(class_1937 level, class_2338 pos, class_2680 state, T blockEntity) {
        if (blockEntity instanceof PipeEntity) {
            PipeEntity pipe = (PipeEntity)blockEntity;
            if (level instanceof class_3218) {
                class_3218 serverLevel = (class_3218)level;
                pipe.tickServer(serverLevel, pos, state);
                for (ScheduledPipeUpdate update : pipe.updates) {
                    pipe.update(update.level(), update.state(), update.pos(), update.direction(), update.wasConnected());
                }
                pipe.updates.clear();
            } else {
                pipe.tickClient(level, pos);
            }
        }
    }

    public abstract void tickServer(class_3218 var1, class_2338 var2, class_2680 var3);

    public abstract void tickClient(class_1937 var1, class_2338 var2);

    public final void scheduleUpdate(class_3218 level, class_2680 state, class_2338 pos, class_2350 direction, boolean wasConnected) {
        this.updates.add(new ScheduledPipeUpdate(level, state, pos, direction, wasConnected));
    }

    protected abstract void update(class_3218 var1, class_2680 var2, class_2338 var3, class_2350 var4, boolean var5);

    public abstract int getComparatorOutput();

    public abstract short getTargetSpeed();

    public abstract short getAcceleration();

    protected final boolean isPipeConnected(class_2680 state, class_2350 direction) {
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof PipeBlock) {
            PipeBlock pipeBlock = (PipeBlock)class_22482;
            return pipeBlock.isPipeConnected(state, direction);
        }
        return false;
    }

    protected final int countConnections(class_2680 state) {
        int count = 0;
        for (class_2350 direction : class_2350.values()) {
            if (!this.isPipeConnected(state, direction)) continue;
            ++count;
        }
        return count;
    }

    public class_2487 method_16887(class_7225.class_7874 registries) {
        return this.method_38244(registries);
    }

    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    private record ScheduledPipeUpdate(class_3218 level, class_2680 state, class_2338 pos, class_2350 direction, boolean wasConnected) {
    }
}

