/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.blockentity;

import jagm.classicpipes.ClassicPipes;
import jagm.classicpipes.blockentity.ItemPipeEntity;
import jagm.classicpipes.util.ItemInPipe;
import jagm.classicpipes.util.MiscUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2591;
import net.minecraft.class_2680;

public class RoundRobinPipeEntity
extends ItemPipeEntity {
    protected class_2350 nextDirection = class_2350.field_11033;

    public RoundRobinPipeEntity(class_2338 pos, class_2680 state) {
        this(ClassicPipes.BASIC_PIPE_ENTITY, pos, state);
    }

    public RoundRobinPipeEntity(class_2591<?> blockEntityType, class_2338 pos, class_2680 state) {
        super(blockEntityType, pos, state);
    }

    protected void updateRoundRobin(List<class_2350> validDirections) {
        if (!validDirections.isEmpty()) {
            do {
                this.nextDirection = MiscUtil.nextDirection(this.nextDirection);
            } while (!validDirections.contains(this.nextDirection));
        }
    }

    protected List<class_2350> getValidDirections(class_2680 state, ItemInPipe item) {
        ArrayList<class_2350> validDirections = new ArrayList<class_2350>();
        class_2350 direction = MiscUtil.nextDirection(item.getFromDirection());
        for (int i = 0; i < 5; ++i) {
            if (this.isPipeConnected(state, direction)) {
                validDirections.add(direction);
            }
            direction = MiscUtil.nextDirection(direction);
        }
        return validDirections;
    }

    @Override
    public void routeItem(class_2680 state, ItemInPipe item) {
        List<class_2350> validDirections = this.getValidDirections(state, item);
        if (validDirections.size() == 1) {
            item.setTargetDirection(validDirections.getFirst());
            item.setEjecting(false);
        } else if (validDirections.isEmpty() || this.nextDirection == null) {
            item.setTargetDirection(item.getFromDirection().method_10153());
            item.setEjecting(true);
        } else {
            int count;
            if (!validDirections.contains(this.nextDirection)) {
                this.updateRoundRobin(validDirections);
            }
            if ((count = item.getStack().method_7947()) == 1) {
                item.setTargetDirection(this.nextDirection);
                item.setEjecting(false);
                this.updateRoundRobin(validDirections);
            } else {
                HashMap<class_2350, Integer> routeMap = new HashMap<class_2350, Integer>();
                validDirections.forEach(direction -> routeMap.put((class_2350)direction, 0));
                for (int i = 0; i < count; ++i) {
                    routeMap.put(this.nextDirection, (Integer)routeMap.get(this.nextDirection) + 1);
                    this.updateRoundRobin(validDirections);
                }
                boolean inputRouted = false;
                for (class_2350 direction2 : validDirections) {
                    int routeCount = (Integer)routeMap.get(direction2);
                    if (routeCount <= 0) continue;
                    if (!inputRouted) {
                        inputRouted = true;
                        item.setStack(item.getStack().method_46651(routeCount));
                        item.setTargetDirection(direction2);
                        item.setEjecting(false);
                        continue;
                    }
                    this.queued.add(new ItemInPipe(item.getStack().method_46651(routeCount), item.getSpeed(), item.getProgress(), item.getFromDirection(), direction2, false, item.getAge()));
                }
            }
        }
    }

    @Override
    public short getTargetSpeed() {
        return 64;
    }

    @Override
    public short getAcceleration() {
        return 1;
    }

    @Override
    protected void method_11014(class_11368 valueInput) {
        super.method_11014(valueInput);
        this.nextDirection = class_2350.method_10143((int)valueInput.method_71421("next_direction", (byte)0));
    }

    @Override
    protected void method_11007(class_11372 valueOutput) {
        super.method_11007(valueOutput);
        valueOutput.method_71462("next_direction", (byte)this.nextDirection.method_10146());
    }
}

