/*
 * Decompiled with CFR 0.152.
 */
package jagm.classicpipes.client.renderer;

import jagm.classicpipes.block.FluidPipeBlock;
import jagm.classicpipes.blockentity.FluidPipeEntity;
import jagm.classicpipes.client.renderer.FluidRenderInfo;
import jagm.classicpipes.services.Services;
import java.util.Arrays;
import net.minecraft.class_1058;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_2246;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5614;
import net.minecraft.class_827;
import org.joml.Matrix4f;

public class FluidPipeRenderer
implements class_827<FluidPipeEntity, FluidPipeRenderState> {
    private final class_5614.class_5615 context;

    public FluidPipeRenderer(class_5614.class_5615 context) {
        this.context = context;
    }

    public FluidPipeRenderState createRenderState() {
        return new FluidPipeRenderState();
    }

    public void extractRenderState(FluidPipeEntity pipe, FluidPipeRenderState pipeState, float partialTicks, class_243 cameraPos, class_11683.class_11792 breakProgress) {
        super.method_74331((class_2586)pipe, (class_11954)pipeState, partialTicks, cameraPos, breakProgress);
        FluidRenderInfo fluidInfo = Services.LOADER_SERVICE.getFluidRenderInfo(pipe.getFluid().method_15785(), (class_1920)pipe.method_10997(), pipe.method_11016());
        boolean[] pipeDirections = new boolean[6];
        for (int i = 0; i < 6; ++i) {
            pipeDirections[i] = (Boolean)pipe.method_11010().method_11654((class_2769)FluidPipeBlock.PROPERTY_BY_DIRECTION.get(class_2350.method_10143((int)i)));
        }
        float width = pipe.lastRenderWidth + (pipe.targetRenderWidth - pipe.lastRenderWidth) * partialTicks;
        pipeState.initialise(fluidInfo, width, pipe.skipRenderingSide, pipeDirections);
    }

    public void submit(FluidPipeRenderState pipeState, class_4587 poses, class_11659 queue, class_12075 cameraState) {
        poses.method_22903();
        if (pipeState.width() > 0.01f) {
            class_1058 fluidSprite = pipeState.fluidInfo().sprite() == null ? class_310.method_1551().method_1541().method_3351().method_3339(class_2246.field_10382.method_9564()) : pipeState.fluidInfo().sprite();
            queue.method_73483(poses, class_1921.method_23028((class_2960)fluidSprite.method_45852()), (pose, vertexBuffer) -> {
                Matrix4f matrix = pose.method_23761();
                float start = 0.5f - pipeState.width() / 2.0f;
                float end = 0.5f + pipeState.width() / 2.0f;
                boolean renderMiddle = false;
                block8: for (class_2350 direction : class_2350.values()) {
                    if (pipeState.middleSides()[direction.method_10146()] || !pipeState.pipeDirections()[direction.method_10146()]) continue;
                    renderMiddle = true;
                    boolean[] renderSides = new boolean[6];
                    Arrays.fill(renderSides, true);
                    renderSides[direction.method_10153().method_10146()] = false;
                    switch (direction) {
                        case field_11036: {
                            this.renderFluidCuboid(vertexBuffer, matrix, start, end, start, end, 1.0f, end, fluidSprite, pipeState.fluidInfo().tint(), pipeState.field_62676, renderSides);
                            continue block8;
                        }
                        case field_11033: {
                            this.renderFluidCuboid(vertexBuffer, matrix, start, 0.0f, start, end, start, end, fluidSprite, pipeState.fluidInfo().tint(), pipeState.field_62676, renderSides);
                            continue block8;
                        }
                        case field_11034: {
                            this.renderFluidCuboid(vertexBuffer, matrix, end, start, start, 1.0f, end, end, fluidSprite, pipeState.fluidInfo().tint(), pipeState.field_62676, renderSides);
                            continue block8;
                        }
                        case field_11039: {
                            this.renderFluidCuboid(vertexBuffer, matrix, 0.0f, start, start, start, end, end, fluidSprite, pipeState.fluidInfo().tint(), pipeState.field_62676, renderSides);
                            continue block8;
                        }
                        case field_11035: {
                            this.renderFluidCuboid(vertexBuffer, matrix, start, start, end, end, end, 1.0f, fluidSprite, pipeState.fluidInfo().tint(), pipeState.field_62676, renderSides);
                            continue block8;
                        }
                        case field_11043: {
                            this.renderFluidCuboid(vertexBuffer, matrix, start, start, 0.0f, end, end, start, fluidSprite, pipeState.fluidInfo().tint(), pipeState.field_62676, renderSides);
                        }
                    }
                }
                if (renderMiddle) {
                    this.renderFluidCuboid(vertexBuffer, matrix, start, start, start, end, end, end, fluidSprite, pipeState.fluidInfo().tint(), pipeState.field_62676, pipeState.middleSides());
                }
            });
        }
        poses.method_22909();
    }

    public void renderFluidCuboid(class_4588 vertexBuffer, Matrix4f matrix, float x1, float y1, float z1, float x2, float y2, float z2, class_1058 fluidSprite, int tint, int light, boolean[] renderSide) {
        float u1 = fluidSprite.method_4580(x1);
        float u2 = fluidSprite.method_4580(x2);
        float v1 = fluidSprite.method_4570(z1);
        float v2 = fluidSprite.method_4570(z2);
        if (renderSide[class_2350.field_11033.method_10146()]) {
            vertexBuffer.method_22918(matrix, x1, y1, z2).method_39415(tint).method_22913(u1, v2).method_60803(light);
            vertexBuffer.method_22918(matrix, x1, y1, z1).method_39415(tint).method_22913(u1, v1).method_60803(light);
            vertexBuffer.method_22918(matrix, x2, y1, z1).method_39415(tint).method_22913(u2, v1).method_60803(light);
            vertexBuffer.method_22918(matrix, x2, y1, z2).method_39415(tint).method_22913(u2, v2).method_60803(light);
        }
        if (renderSide[class_2350.field_11036.method_10146()]) {
            vertexBuffer.method_22918(matrix, x1, y2, z1).method_39415(tint).method_22913(u1, v2).method_60803(light);
            vertexBuffer.method_22918(matrix, x1, y2, z2).method_39415(tint).method_22913(u1, v1).method_60803(light);
            vertexBuffer.method_22918(matrix, x2, y2, z2).method_39415(tint).method_22913(u2, v1).method_60803(light);
            vertexBuffer.method_22918(matrix, x2, y2, z1).method_39415(tint).method_22913(u2, v2).method_60803(light);
        }
        u1 = fluidSprite.method_4580(y1);
        u2 = fluidSprite.method_4580(y2);
        v1 = fluidSprite.method_4570(z1);
        v2 = fluidSprite.method_4570(z2);
        if (renderSide[class_2350.field_11039.method_10146()]) {
            vertexBuffer.method_22918(matrix, x1, y2, z2).method_39415(tint).method_22913(u1, v2).method_60803(light);
            vertexBuffer.method_22918(matrix, x1, y2, z1).method_39415(tint).method_22913(u1, v1).method_60803(light);
            vertexBuffer.method_22918(matrix, x1, y1, z1).method_39415(tint).method_22913(u2, v1).method_60803(light);
            vertexBuffer.method_22918(matrix, x1, y1, z2).method_39415(tint).method_22913(u2, v2).method_60803(light);
        }
        if (renderSide[class_2350.field_11034.method_10146()]) {
            vertexBuffer.method_22918(matrix, x2, y2, z1).method_39415(tint).method_22913(u1, v2).method_60803(light);
            vertexBuffer.method_22918(matrix, x2, y2, z2).method_39415(tint).method_22913(u1, v1).method_60803(light);
            vertexBuffer.method_22918(matrix, x2, y1, z2).method_39415(tint).method_22913(u2, v1).method_60803(light);
            vertexBuffer.method_22918(matrix, x2, y1, z1).method_39415(tint).method_22913(u2, v2).method_60803(light);
        }
        u1 = fluidSprite.method_4580(y1);
        u2 = fluidSprite.method_4580(y2);
        v1 = fluidSprite.method_4570(x1);
        v2 = fluidSprite.method_4570(x2);
        if (renderSide[class_2350.field_11043.method_10146()]) {
            vertexBuffer.method_22918(matrix, x1, y2, z1).method_39415(tint).method_22913(u1, v2).method_60803(light);
            vertexBuffer.method_22918(matrix, x2, y2, z1).method_39415(tint).method_22913(u1, v1).method_60803(light);
            vertexBuffer.method_22918(matrix, x2, y1, z1).method_39415(tint).method_22913(u2, v1).method_60803(light);
            vertexBuffer.method_22918(matrix, x1, y1, z1).method_39415(tint).method_22913(u2, v2).method_60803(light);
        }
        if (renderSide[class_2350.field_11035.method_10146()]) {
            vertexBuffer.method_22918(matrix, x2, y2, z2).method_39415(tint).method_22913(u1, v2).method_60803(light);
            vertexBuffer.method_22918(matrix, x1, y2, z2).method_39415(tint).method_22913(u1, v1).method_60803(light);
            vertexBuffer.method_22918(matrix, x1, y1, z2).method_39415(tint).method_22913(u2, v1).method_60803(light);
            vertexBuffer.method_22918(matrix, x2, y1, z2).method_39415(tint).method_22913(u2, v2).method_60803(light);
        }
    }

    public static class FluidPipeRenderState
    extends class_11954 {
        private FluidRenderInfo fluidInfo;
        private float width;
        private boolean[] middleSides;
        private boolean[] pipeDirections;

        public void initialise(FluidRenderInfo fluidInfo, float width, boolean[] middleSides, boolean[] pipeDirections) {
            this.fluidInfo = fluidInfo;
            this.width = width;
            this.middleSides = middleSides;
            this.pipeDirections = pipeDirections;
        }

        public FluidRenderInfo fluidInfo() {
            return this.fluidInfo;
        }

        public float width() {
            return this.width;
        }

        public boolean[] middleSides() {
            return this.middleSides;
        }

        public boolean[] pipeDirections() {
            return this.pipeDirections;
        }
    }
}

